/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeAnalysis;
import cgdp.recog.coregenome.CoreGenomeSearch;
import cgdp.recog.coregenome.CoreGenomeSearchResult;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.coregenome.OrthologSpNode;
import cgdp.recog.coregenome.OrthologSpNodeConnection;
import cgdp.recog.organism.Organism;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenomeAlign {
    private String domClustId;
    private String clusterViewId;
    private String coreGenomeId;
    private String filepath;
    private List organismList = new ArrayList();
    private List orthologGroupList = new ArrayList();
    private Map clusterIdOrthologGroupListMap = new HashMap();
    private Map nodeConnectionMap = new HashMap();
    private List clusterBorderIndexList = new ArrayList();
    private CoreGenomeAnalysis coreGenomeAnalysis;

    public String getCoreGenomeId() {
        return this.coreGenomeId;
    }

    public void setCoreGenomeId(String string) {
        this.coreGenomeId = string;
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public String getClusterViewId() {
        return this.clusterViewId;
    }

    public void setClusterViewId(String string) {
        this.clusterViewId = string;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }

    public List getOrganismCodeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Organism organism : this.organismList) {
            arrayList.add(organism.getOrganismCode());
        }
        return arrayList;
    }

    public void setOrganismCodeList(List list) {
        for (String string : list) {
            Organism organism = this.getOrganism(string);
            if (organism != null) continue;
            organism = new Organism();
            organism.setOrganismCode(string);
            this.organismList.add(organism);
        }
    }

    private Organism getOrganism(String string) {
        Organism organism = null;
        for (Organism organism2 : this.organismList) {
            if (!organism2.equalsOrganismCode(string)) continue;
            organism = organism2;
            break;
        }
        return organism;
    }

    public Organism getOrganism(int n) {
        return (Organism)this.organismList.get(n);
    }

    public String getOrganismCode(int n) {
        Organism organism = this.getOrganism(n);
        return organism.getOrganismCode();
    }

    public int getOrganismSize() {
        return this.organismList.size();
    }

    public List getOrganismList() {
        return this.organismList;
    }

    public void setOrganismList(List list) {
        this.organismList = list;
    }

    public List getOrthologGroupList() {
        return this.orthologGroupList;
    }

    public List getOrganismNameList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Organism organism : this.organismList) {
            arrayList.add(organism.getName());
        }
        return arrayList;
    }

    public int getOrthologGroupSize() {
        return this.orthologGroupList.size();
    }

    public OrthologGroup getOrthologGroup(int n) {
        return (OrthologGroup)this.orthologGroupList.get(n);
    }

    OrthologGroup getOrthologGroup(String string) {
        OrthologGroup orthologGroup = null;
        for (OrthologGroup orthologGroup2 : this.orthologGroupList) {
            if (!orthologGroup2.getOrthologGroupId().equals(string)) continue;
            orthologGroup = orthologGroup2;
            break;
        }
        return orthologGroup;
    }

    Set getOrthologGroupSet(Set set) {
        HashSet<OrthologGroup> hashSet = new HashSet<OrthologGroup>();
        for (OrthologGroup orthologGroup : this.orthologGroupList) {
            String string = orthologGroup.getConbineClusterId();
            if (!set.contains(string)) continue;
            hashSet.add(orthologGroup);
        }
        return hashSet;
    }

    Set getOrthologGroupSetByClusterId(Set set) {
        HashSet hashSet = new HashSet();
        for (String string : set) {
            List list = (List)this.clusterIdOrthologGroupListMap.get(string);
            if (CollectionUtil.isNull(list)) continue;
            hashSet.addAll(list);
        }
        return hashSet;
    }

    public void addOrthologGroup(OrthologGroup orthologGroup) {
        this.orthologGroupList.add(orthologGroup);
        this.updateClusterOrthologGroupMap(orthologGroup);
    }

    public List getOrthologGroupIDList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OrthologGroup orthologGroup : this.orthologGroupList) {
            arrayList.add(orthologGroup.getOrthologGroupId());
        }
        return arrayList;
    }

    public List getOrthologSpNodeList(String string) {
        ArrayList<OrthologSpNode> arrayList = new ArrayList<OrthologSpNode>();
        for (OrthologGroup orthologGroup : this.orthologGroupList) {
            OrthologSpNode orthologSpNode = orthologGroup.getOrthologSpNode(string);
            if (orthologSpNode == null) continue;
            arrayList.add(orthologSpNode);
        }
        return arrayList;
    }

    public List getLocusTagList(String string) {
        ArrayList arrayList = new ArrayList();
        for (OrthologGroup orthologGroup : this.orthologGroupList) {
            List list = orthologGroup.getLocusTagList(string);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List getLocusTagWithoutDomainNoList(String string) {
        ArrayList arrayList = new ArrayList();
        for (OrthologGroup orthologGroup : this.orthologGroupList) {
            List list = orthologGroup.getLocusTagWithoutDomainList(string);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public void setSpConnectionMap(Map map) {
        this.createNodeConnectionMap(map);
    }

    private void createNodeConnectionMap(Map map) {
        for (List list : map.values()) {
            for (OrthologSpNodeConnection orthologSpNodeConnection : list) {
                ArrayList<OrthologSpNodeConnection> arrayList = (ArrayList<OrthologSpNodeConnection>)this.nodeConnectionMap.get(orthologSpNodeConnection.getFromOrthologSpNode());
                if (arrayList == null) {
                    arrayList = new ArrayList<OrthologSpNodeConnection>();
                    this.nodeConnectionMap.put(orthologSpNodeConnection.getFromOrthologSpNode(), arrayList);
                }
                arrayList.add(orthologSpNodeConnection);
            }
        }
    }

    public List getConnectionList(OrthologSpNode orthologSpNode) {
        ArrayList arrayList = (ArrayList)this.nodeConnectionMap.get(orthologSpNode);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public int getConnectionCount(String string, int n, int n2) {
        int n3;
        int[] nArray = new int[n - n2];
        for (n3 = n2; n3 < n; ++n3) {
            OrthologGroup orthologGroup = this.getOrthologGroup(n3);
            OrthologSpNode orthologSpNode = orthologGroup.getOrthologSpNode(string);
            List list = this.getConnectionList(orthologSpNode);
            for (OrthologSpNodeConnection orthologSpNodeConnection : list) {
                int n4 = orthologSpNodeConnection.getFromOrthologGroup().getRealOrderIndex();
                int n5 = orthologSpNodeConnection.getToOrthologGroup().getRealOrderIndex();
                if (n5 < n2 || n5 > n) continue;
                for (int i = n5; i < n4; ++i) {
                    int n6 = i - n2;
                    nArray[n6] = nArray[n6] + 1;
                }
            }
        }
        n3 = 0;
        for (int i = 0; i < n - n2; ++i) {
            n3 = Math.max(n3, nArray[i]);
        }
        return n3;
    }

    public List getClusterBorderIndexList() {
        return this.clusterBorderIndexList;
    }

    public void setClusterBorderIndexList(List list) {
        this.clusterBorderIndexList = list;
    }

    public int getClusterCount() {
        return this.clusterBorderIndexList.size();
    }

    public CoreGenomeAnalysis getCoreGenomeAnalysis() {
        return this.coreGenomeAnalysis;
    }

    public void setCoreGenomeAnalysis(CoreGenomeAnalysis coreGenomeAnalysis) {
        this.coreGenomeAnalysis = coreGenomeAnalysis;
    }

    public int getClusterCount(int n) {
        int n2 = n;
        int n3 = 0;
        while (n2 > this.getOrthologGroupSize()) {
            n2 -= this.getOrthologGroupSize();
            ++n3;
        }
        int n4 = this.getClusterCount() * n3;
        Iterator iterator = this.clusterBorderIndexList.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            if (n5 > n2) continue;
            ++n4;
        }
        return n4;
    }

    public int getColumnSize() {
        return this.getOrthologGroupSize() + this.getClusterCount();
    }

    private List shiftClusterBorderIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = this.clusterBorderIndexList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next() - n;
            if (n2 < 0) {
                n2 += this.getOrthologGroupSize();
            } else if (n2 >= this.getOrthologGroupSize()) {
                n2 -= this.getOrthologGroupSize();
            }
            arrayList.add(new Integer(n2));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private List createBlankIndexList(int n) {
        List list = this.shiftClusterBorderIndexList(n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = -1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            int n4 = n3 + n2;
            if (n4 < 0) {
                n4 += this.getColumnSize();
            }
            arrayList.add(new Integer(n4));
            ++n2;
        }
        return arrayList;
    }

    public int getOrthologGroupCount(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.getColumnSize();
        for (n5 = n; n5 >= n6; n5 -= n6) {
        }
        for (n4 = n + n2 - 1; n4 >= n6; n4 -= n6) {
        }
        List list = this.createBlankIndexList(n3);
        int n7 = 0;
        if (n5 <= n4) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n8 = (Integer)iterator.next();
                if (n8 < n5 || n8 > n4) continue;
                ++n7;
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n9 = (Integer)iterator.next();
                if ((n9 < 0 || n9 > n4) && (n9 < n5 || n9 > n6)) continue;
                ++n7;
            }
        }
        return n2 - n7;
    }

    public int getClusterCount(int n, int n2) {
        int n3;
        int n4 = this.getClusterCount(n);
        if (n4 <= (n3 = this.getClusterCount(n2))) {
            return n3 - n4 + 1;
        }
        return n3 + (this.getClusterCount() - n4) + 1;
    }

    public int getClusterBorderOrthologGroupIndex(int n) {
        return (Integer)this.clusterBorderIndexList.get(this.convertClusterIndex(n));
    }

    private int convertClusterIndex(int n) {
        int n2;
        block3: {
            block2: {
                n2 = n;
                if (n2 >= 0) break block2;
                while (n2 < 0) {
                    n2 += this.getClusterCount();
                }
                break block3;
            }
            if (n2 < this.getClusterCount()) break block3;
            while (n2 >= this.getClusterCount()) {
                n2 -= this.getClusterCount();
            }
        }
        return n2;
    }

    public int indexOfClusterBorderIndex(int n) {
        int n2 = this.clusterBorderIndexList.size() - 1;
        int n3 = 0;
        Iterator iterator = this.clusterBorderIndexList.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            if (n < n4) {
                n2 = n3 - 1;
                if (n2 >= 0) break;
                n2 += this.clusterBorderIndexList.size();
                break;
            }
            ++n3;
        }
        return n2;
    }

    int indexOfOrthologGroup(OrthologGroup orthologGroup) {
        return this.orthologGroupList.indexOf(orthologGroup);
    }

    public boolean containsClusterBorderindex(int n) {
        return this.clusterBorderIndexList.contains(new Integer(n));
    }

    public int adjustOrthologGroupIndexForChromCirular(int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += this.getOrthologGroupSize();
        }
        return n2;
    }

    public int getOrthologGroupDiff(OrthologSpNodeConnection orthologSpNodeConnection) {
        return this.getOrthologGroupDiff(orthologSpNodeConnection.getFromOrthologGroup(), orthologSpNodeConnection.getToOrthologGroup());
    }

    private int getOrthologGroupDiff(OrthologGroup orthologGroup, OrthologGroup orthologGroup2) {
        int n;
        for (n = orthologGroup2.getRealOrderIndex() - orthologGroup.getRealOrderIndex(); n > 0; n -= this.getOrthologGroupSize()) {
        }
        return n;
    }

    public int getClusterDiff(OrthologSpNodeConnection orthologSpNodeConnection) {
        return this.getClusterDiff(orthologSpNodeConnection.getFromOrthologGroup(), orthologSpNodeConnection.getToOrthologGroup());
    }

    private int getClusterDiff(OrthologGroup orthologGroup, OrthologGroup orthologGroup2) {
        int n;
        for (n = orthologGroup2.getClusterPosition() - orthologGroup.getClusterPosition(); n > 0; n -= this.getClusterCount()) {
        }
        return n;
    }

    public Map createClusterOrthologGroupMap() {
        HashMap<Integer, ArrayList<OrthologGroup>> hashMap = new HashMap<Integer, ArrayList<OrthologGroup>>();
        for (OrthologGroup orthologGroup : this.orthologGroupList) {
            int n = orthologGroup.getClusterNo();
            ArrayList<OrthologGroup> arrayList = (ArrayList<OrthologGroup>)hashMap.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<OrthologGroup>();
                hashMap.put(new Integer(n), arrayList);
            }
            arrayList.add(orthologGroup);
        }
        return hashMap;
    }

    void updateOrthologGroupList(List list) {
        this.orthologGroupList = list;
        this.updateOrthologGroupOrder();
        this.updateClusterBorderIndexList();
        this.updateClusterOrthologGroupMap();
    }

    private void updateOrthologGroupOrder() {
        int n = 0;
        for (OrthologGroup orthologGroup : this.orthologGroupList) {
            orthologGroup.setRealOrderIndex(n);
            ++n;
        }
    }

    private void updateClusterBorderIndexList() {
        this.clusterBorderIndexList.clear();
        this.clusterBorderIndexList.add(new Integer(0));
        int n = Integer.MIN_VALUE;
        for (OrthologGroup orthologGroup : this.getOrthologGroupList()) {
            if (n != Integer.MIN_VALUE && n != orthologGroup.getClusterNo()) {
                this.clusterBorderIndexList.add(new Integer(orthologGroup.getRealOrderIndex()));
            }
            n = orthologGroup.getClusterNo();
        }
    }

    private void updateClusterOrthologGroupMap() {
        HashMap<String, ArrayList<OrthologGroup>> hashMap = new HashMap<String, ArrayList<OrthologGroup>>();
        for (OrthologGroup orthologGroup : this.orthologGroupList) {
            String string = orthologGroup.getConbineClusterId();
            ArrayList<OrthologGroup> arrayList = (ArrayList<OrthologGroup>)hashMap.get(string);
            if (CollectionUtil.isNull(arrayList)) {
                arrayList = new ArrayList<OrthologGroup>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(orthologGroup);
        }
        this.clusterIdOrthologGroupListMap.clear();
        this.clusterIdOrthologGroupListMap = hashMap;
    }

    private void updateClusterOrthologGroupMap(OrthologGroup orthologGroup) {
        String string = orthologGroup.getConbineClusterId();
        ArrayList<OrthologGroup> arrayList = (ArrayList<OrthologGroup>)this.clusterIdOrthologGroupListMap.get(string);
        if (CollectionUtil.isNull(arrayList)) {
            arrayList = new ArrayList<OrthologGroup>();
            this.clusterIdOrthologGroupListMap.put(string, arrayList);
        }
        if (!this.containsOrhotlogGroup(orthologGroup, arrayList)) {
            arrayList.add(orthologGroup);
        }
    }

    private boolean containsOrhotlogGroup(OrthologGroup orthologGroup, List list) {
        for (OrthologGroup orthologGroup2 : list) {
            if (!orthologGroup2.equalsOrthologGroupId(orthologGroup)) continue;
            return true;
        }
        return false;
    }

    List searchOrthologGroupList(String string, int n) {
        ArrayList<CoreGenomeSearchResult> arrayList = new ArrayList<CoreGenomeSearchResult>();
        for (int i = 0; i < this.getOrthologGroupSize(); ++i) {
            OrthologGroup orthologGroup = this.getOrthologGroup(i);
            Set set = this.searchOrthologGroup(orthologGroup, string, n);
            if (set.isEmpty()) continue;
            CoreGenomeSearchResult coreGenomeSearchResult = new CoreGenomeSearchResult();
            coreGenomeSearchResult.setOrthologGroupIndex(i);
            coreGenomeSearchResult.setGeneInfoSet(set);
            arrayList.add(coreGenomeSearchResult);
        }
        return arrayList;
    }

    private Set searchOrthologGroup(OrthologGroup orthologGroup, String string, int n) {
        HashSet hashSet = new HashSet();
        String string2 = string.toLowerCase();
        if (CoreGenomeSearch.isTypeGeneName(n)) {
            hashSet.addAll(orthologGroup.getGeneInfoListMatchGeneName(string2));
        }
        if (CoreGenomeSearch.isTypeLocusTag(n)) {
            hashSet.addAll(orthologGroup.getGeneInfoListMatchLocusTag(string2));
        }
        return hashSet;
    }
}

