/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.ClusterSorter;
import cgdp.recog.coregenome.CoreGenomeAlignmentCondition;
import cgdp.recog.coregenome.CoreGenomeAlignmentException;
import cgdp.recog.coregenome.CoreGenomeAnalysis;
import cgdp.recog.coregenome.CoreGenomeFacade;
import cgdp.recog.coregenome.CoreGenomeGeneInfo;
import cgdp.recog.coregenome.CoreGenomeImporter;
import cgdp.recog.coregenome.GeneComparator;
import cgdp.recog.coregenome.GenomeAlign;
import cgdp.recog.coregenome.OrthologGroup;
import cgdp.recog.coregenome.OrthologSpNode;
import cgdp.recog.coregenome.OrthologSpNodeConnection;
import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeTbl;
import cgdp.recog.data.ChromosomeTypeComparator;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneTbl;
import cgdp.recog.organism.Organism;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.GeneUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenomeAlignGenerater {
    private static final ApplicationLogger logger = new ApplicationLogger(GenomeAlignGenerater.class);
    private String filepath;
    private GenomeAlign genomeAlign;
    private CoreGenomeAlignmentCondition condition;
    private ClusterTbl clusterTbl;
    private Map clusterMap = new HashMap();
    private Map geneInfoMap = new HashMap();

    public void setClusterTbl(ClusterTbl clusterTbl) {
        this.clusterTbl = clusterTbl;
        this.clusterMap = clusterTbl.createClusterMap();
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }

    public GenomeAlign getGenomeAlign() {
        return this.genomeAlign;
    }

    public void setCondition(CoreGenomeAlignmentCondition coreGenomeAlignmentCondition) {
        this.condition = coreGenomeAlignmentCondition;
    }

    public void execute(ProgressImpl progressImpl) throws Exception {
        try {
            this.readCoreGenomeFile();
            if (!this.updateProgress(progressImpl, 29)) {
                return;
            }
            this.geneInfoMap = this.createGeneInfoMap(this.genomeAlign, this.clusterTbl);
            if (!this.updateProgress(progressImpl, 69)) {
                return;
            }
            ClusterSorter clusterSorter = new ClusterSorter(this.genomeAlign, this.condition.getReferenceOrganismCode());
            clusterSorter.sortCluster();
            if (!this.updateProgress(progressImpl, 79)) {
                return;
            }
            Map map = this.createConnection(this.genomeAlign);
            this.genomeAlign.setSpConnectionMap(map);
            if (!this.updateProgress(progressImpl, 99)) {
                return;
            }
            this.genomeAlign.setFilepath(this.filepath);
        }
        catch (CoreGenomeAlignmentException coreGenomeAlignmentException) {
            logger.warn(coreGenomeAlignmentException.getMessage(), coreGenomeAlignmentException);
        }
        catch (IOException iOException) {
            logger.warn("Fail to generate CoreGenomeAlign.", iOException);
        }
        catch (Exception exception) {
            logger.warn("Fail to generate CoreGenomeAlign.", exception);
        }
    }

    private boolean updateProgress(ProgressImpl progressImpl, int n) {
        if (progressImpl == null) {
            return true;
        }
        if (progressImpl.isCanceled()) {
            return false;
        }
        progressImpl.setCount(n);
        progressImpl.increment();
        return true;
    }

    private void readCoreGenomeFile() throws IOException {
        CoreGenomeImporter coreGenomeImporter = new CoreGenomeImporter(this.getFilepath());
        coreGenomeImporter.setCondition(this.condition);
        coreGenomeImporter.setClusterMap(this.clusterMap);
        coreGenomeImporter.execute();
        this.genomeAlign = coreGenomeImporter.getGenomeAlign();
        if (this.condition.getReferenceOrganismCode() == null) {
            this.condition.setReferenceOrganismCode(this.genomeAlign.getOrganismCode(0));
        }
        String string = new File(this.getFilepath()).getName();
        string = string.replaceAll(".coaln", "");
        Project project = ProjectAccesser.getSelectedProject();
        CoreGenomeAnalysis coreGenomeAnalysis = CoreGenomeFacade.getCoreGenomeAnalysis(project, string);
        if (coreGenomeAnalysis == null) {
            coreGenomeAnalysis = CoreGenomeFacade.createCoreGenomeAnalysis(string, null, this.genomeAlign.getDomClustId(), this.genomeAlign.getCoreGenomeId());
        }
        this.genomeAlign.setCoreGenomeAnalysis(coreGenomeAnalysis);
    }

    private Map createGeneMap(GenomeAlign genomeAlign, ClusterTbl clusterTbl) throws Exception {
        try {
            HashMap<String, Gene> hashMap = new HashMap<String, Gene>();
            for (Organism organism : genomeAlign.getOrganismList()) {
                String string = organism.getOrganismCode();
                GeneTbl geneTbl = new GeneTbl(organism);
                geneTbl.read();
                ArrayList arrayList = new ArrayList(geneTbl.values());
                ChromosomeTbl chromosomeTbl = new ChromosomeTbl(organism);
                chromosomeTbl.read();
                Map map = this.createOffsetGenomeLengthMap(chromosomeTbl);
                this.setChromosomeShape(organism, arrayList, chromosomeTbl);
                this.setPosition(arrayList, chromosomeTbl, map);
                this.setGeneOrder(arrayList, clusterTbl.getLocusTagWithoutDomainList(string));
                for (Gene gene : arrayList) {
                    String string2 = GeneUtil.createOrganismLocusTagKey(string, gene.getLocusTag());
                    hashMap.put(string2, gene);
                }
            }
            return hashMap;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CoreGenomeAlignmentException("Gene file is not found.", fileNotFoundException);
        }
    }

    private Map createOffsetGenomeLengthMap(ChromosomeTbl chromosomeTbl) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        ArrayList arrayList = new ArrayList(chromosomeTbl.values());
        Collections.sort(arrayList, new ChromosomeTypeComparator());
        for (Chromosome chromosome : arrayList) {
            hashMap.put(new Integer(chromosome.getId()), new Integer(n));
            n += chromosome.getLength();
        }
        return hashMap;
    }

    private void setChromosomeShape(Organism organism, List list, ChromosomeTbl chromosomeTbl) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Object object : list) {
            hashSet.add(new Integer(((Gene)object).getChromId()));
        }
        HashMap hashMap = new HashMap();
        for (Chromosome chromosome : chromosomeTbl.values()) {
            hashMap.put(new Integer(chromosome.getId()), chromosome.getShape());
        }
        organism.setChromosomeShapeMap(hashMap);
    }

    private void setPosition(List list, ChromosomeTbl chromosomeTbl, Map map) {
        Gene gene2 = null;
        Chromosome chromosome = null;
        try {
            for (Gene gene2 : list) {
                chromosome = (Chromosome)chromosomeTbl.get(String.valueOf(gene2.getChromId()));
                if (chromosome == null) {
                    System.out.println("chromosome is null: chrid=" + gene2.getChromId() + " locustag=" + gene2.getLocusTag());
                }
                double d = ((Integer)map.get(new Integer(chromosome.getId()))).doubleValue() + GeneUtil.calcGenePositionMB(gene2.getStart(), gene2.getEnd(), chromosome.getLength(), chromosome.isCircular());
                gene2.setPosition(d);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Null Pointer exception: chrid=" + gene2.getChromId());
            throw nullPointerException;
        }
    }

    private void setGeneOrder(List list, Set set) {
        Collections.sort(list, new GeneComparator());
        int n = 0;
        for (Gene gene : list) {
            if (!set.contains(gene.getLocusTag())) continue;
            gene.setOrder(n);
            ++n;
        }
    }

    public Map createGeneInfoMap(GenomeAlign genomeAlign, ClusterTbl clusterTbl) throws Exception {
        Map map = this.createGeneMap(genomeAlign, clusterTbl);
        HashMap<String, CoreGenomeGeneInfo> hashMap = new HashMap<String, CoreGenomeGeneInfo>();
        for (String string : genomeAlign.getOrganismCodeList()) {
            for (OrthologSpNode orthologSpNode : genomeAlign.getOrthologSpNodeList(string)) {
                List list = orthologSpNode.getLocusTagList();
                for (String string2 : list) {
                    String string3 = GeneUtil.createOrganismLocusTagKey(string, GeneUtil.removeDomainNo(string2));
                    Gene gene = (Gene)map.get(string3);
                    if (gene == null) {
                        System.out.println("Error: Gene not found: " + string3);
                    }
                    CoreGenomeGeneInfo coreGenomeGeneInfo = orthologSpNode.getGeneInfo(string2);
                    int n = orthologSpNode.getDomainNo(string2);
                    coreGenomeGeneInfo.setOrganismCode(string);
                    coreGenomeGeneInfo.setDirection(gene.getDirection());
                    coreGenomeGeneInfo.setGeneName(gene.getGeneName());
                    coreGenomeGeneInfo.setDomainNo(n);
                    coreGenomeGeneInfo.setPosition(gene.getPosition());
                    coreGenomeGeneInfo.setOrder(gene.getOrder());
                    coreGenomeGeneInfo.setChromId(gene.getChromId());
                    String string4 = GeneUtil.createOrganismLocusTagKey(string, string2);
                    hashMap.put(string4, coreGenomeGeneInfo);
                }
            }
        }
        return hashMap;
    }

    public Map createConnection(GenomeAlign genomeAlign) {
        HashMap hashMap = new HashMap();
        for (OrthologGroup orthologGroup : genomeAlign.getOrthologGroupList()) {
            this.createConnectionEachOrthologGroup(orthologGroup, genomeAlign, hashMap);
        }
        return hashMap;
    }

    public void createConnectionEachOrthologGroup(OrthologGroup orthologGroup, GenomeAlign genomeAlign, Map map) {
        for (Organism organism : genomeAlign.getOrganismList()) {
            List list = orthologGroup.getGeneInfoList(organism.getOrganismCode());
            if (list == null || list.isEmpty()) continue;
            List list2 = this.setConnectionEachOrganism(organism, list, orthologGroup.getRealOrderIndex(), genomeAlign);
            ArrayList arrayList = (ArrayList)map.get(organism);
            if (arrayList == null) {
                arrayList = new ArrayList();
                map.put(organism, arrayList);
            }
            arrayList.addAll(list2);
        }
    }

    private List setConnectionEachOrganism(Organism organism, List list, int n, GenomeAlign genomeAlign) {
        Object object;
        Object object2;
        int n2;
        Object object32;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        HashMap<Integer, Object> hashMap3 = new HashMap<Integer, Object>();
        HashMap<Integer, CoreGenomeGeneInfo> hashMap4 = new HashMap<Integer, CoreGenomeGeneInfo>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n3 = this.condition.getNeighborWindowAlignSize();
        if (n3 > genomeAlign.getOrthologGroupSize()) {
            n3 = genomeAlign.getOrthologGroupSize() - 1;
        }
        block0: for (Object object32 : list) {
            for (n2 = -1 * n3; n2 <= n3; ++n2) {
                if (n2 == 0 || n2 <= -1 * genomeAlign.getOrthologGroupSize() || hashSet.contains(new Integer(n2 / Math.abs(n2))) && n2 > 0) continue;
                int n4 = n + n2;
                if (n4 < 0) {
                    if (!organism.isCircular(((CoreGenomeGeneInfo)object32).getChromId())) continue;
                    n4 = genomeAlign.adjustOrthologGroupIndexForChromCirular(n4);
                }
                if (n4 >= genomeAlign.getOrthologGroupSize()) continue block0;
                OrthologGroup orthologGroup = genomeAlign.getOrthologGroup(n4);
                object2 = orthologGroup.getOrthologSpNode(organism.getOrganismCode());
                if (object2 == null) continue;
                object = ((OrthologSpNode)object2).getLocusTagList();
                List list2 = this.getGeneInfoList(organism.getOrganismCode(), (List)object);
                if (list2 == null || list2.isEmpty()) continue;
                for (CoreGenomeGeneInfo coreGenomeGeneInfo : list2) {
                    int n5;
                    if (((CoreGenomeGeneInfo)object32).getChromId() != coreGenomeGeneInfo.getChromId() || (n5 = this.getGeneDiff(((CoreGenomeGeneInfo)object32).getOrder(), coreGenomeGeneInfo.getOrder())) > this.condition.getNeighborWindowSize()) continue;
                    int n6 = this.getDirection(((CoreGenomeGeneInfo)object32).getOrder(), coreGenomeGeneInfo.getOrder());
                    Integer n7 = new Integer(n6);
                    if (!this.isMinDiff(n6, n5, n2, hashMap, hashMap2)) continue;
                    if (n5 == 0) {
                        for (Integer n8 : hashMap2.keySet()) {
                            if ((Integer)hashMap2.get(n8) / n2 <= 0) continue;
                            hashSet.add(n8);
                        }
                        for (Integer n8 : hashSet) {
                            hashMap.remove(n8);
                            hashMap2.remove(n8);
                            hashMap3.remove(n8);
                            hashMap4.remove(n8);
                        }
                    }
                    hashMap.put(n7, new Integer(n5));
                    hashMap2.put(n7, new Integer(n2));
                    hashMap3.put(n7, object32);
                    hashMap4.put(n7, coreGenomeGeneInfo);
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        object32 = hashMap.keySet().iterator();
        while (object32.hasNext()) {
            n2 = (Integer)object32.next();
            Integer n9 = new Integer(n2);
            int n10 = (Integer)hashMap2.get(n9);
            if (n10 > 0) continue;
            object2 = (CoreGenomeGeneInfo)hashMap3.get(n9);
            object = (CoreGenomeGeneInfo)hashMap4.get(n9);
            int n11 = (Integer)hashMap.get(n9);
            int n12 = n;
            int n13 = genomeAlign.adjustOrthologGroupIndexForChromCirular(n + n10);
            OrthologGroup orthologGroup = genomeAlign.getOrthologGroup(n12);
            OrthologGroup orthologGroup2 = genomeAlign.getOrthologGroup(n13);
            boolean bl = this.getDirectionInterval(((CoreGenomeGeneInfo)object2).getDirection(), ((CoreGenomeGeneInfo)object).getDirection(), orthologGroup.getDirection(), orthologGroup2.getDirection());
            Iterator iterator = new OrthologSpNodeConnection();
            ((OrthologSpNodeConnection)((Object)iterator)).setGeneDiff(n11);
            ((OrthologSpNodeConnection)((Object)iterator)).setOrthologGroupDiff(n10);
            ((OrthologSpNodeConnection)((Object)iterator)).setDirection(n2);
            ((OrthologSpNodeConnection)((Object)iterator)).setDirectionInterval(bl);
            ((OrthologSpNodeConnection)((Object)iterator)).setFromGeneInfo((CoreGenomeGeneInfo)object2);
            ((OrthologSpNodeConnection)((Object)iterator)).setToGeneInfo((CoreGenomeGeneInfo)object);
            ((OrthologSpNodeConnection)((Object)iterator)).setFromOrthologGroup(orthologGroup);
            ((OrthologSpNodeConnection)((Object)iterator)).setToOrthologGroup(orthologGroup2);
            arrayList.add(iterator);
        }
        return arrayList;
    }

    private int getDirection(int n, int n2) {
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return 0;
    }

    private int getGeneDiff(int n, int n2) {
        return Math.abs(n - n2);
    }

    private boolean isMinDiff(int n, int n2, int n3, Map map, Map map2) {
        Integer n4 = new Integer(n);
        if (map.containsKey(n4)) {
            int n5 = (Integer)map.get(n4);
            int n6 = (Integer)map2.get(n4);
            return n5 > n2 || n5 == n2 && Math.abs(n6) > Math.abs(n3);
        }
        return true;
    }

    private boolean getDirectionInterval(int n, int n2, int n3, int n4) {
        return n * n2 != n3 * n4;
    }

    private List getGeneInfoList(String string, List list) {
        ArrayList<CoreGenomeGeneInfo> arrayList = new ArrayList<CoreGenomeGeneInfo>();
        for (String string2 : list) {
            CoreGenomeGeneInfo coreGenomeGeneInfo = this.getGeneInfo(string, string2);
            if (coreGenomeGeneInfo == null) continue;
            arrayList.add(coreGenomeGeneInfo);
        }
        return arrayList;
    }

    private CoreGenomeGeneInfo getGeneInfo(String string, String string2) {
        String string3 = GeneUtil.createOrganismLocusTagKey(string, string2);
        return (CoreGenomeGeneInfo)this.geneInfoMap.get(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSortFile(String string, GenomeAlign genomeAlign) throws IOException {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            stringBuffer.append("#");
            for (Object object : genomeAlign.getOrganismCodeList()) {
                stringBuffer.append((String)object);
                if (n != genomeAlign.getOrganismSize() - 1) {
                    stringBuffer.append(",");
                }
                ++n;
            }
            stringBuffer.append(System.getProperties().getProperty("line.separator"));
            for (Object object : genomeAlign.getOrthologGroupList()) {
                stringBuffer.append(((OrthologGroup)object).getOrthologGroupId());
                stringBuffer.append("\t");
                stringBuffer.append(((OrthologGroup)object).getDisplayGeneName());
                stringBuffer.append("\t");
                stringBuffer.append(((OrthologGroup)object).getDirection());
                for (String string2 : genomeAlign.getOrganismCodeList()) {
                    OrthologSpNode orthologSpNode = ((OrthologGroup)object).getOrthologSpNode(string2);
                    if (orthologSpNode != null) {
                        List list = genomeAlign.getConnectionList(orthologSpNode);
                        int n2 = this.getConnectionStatus(list, (OrthologGroup)object);
                        if (n2 == 1) {
                            stringBuffer.append("\t*");
                        } else if (n2 == 2) {
                            stringBuffer.append("\t+");
                        } else if (n2 == 3) {
                            stringBuffer.append("\t|");
                        } else if (n2 == 4) {
                            stringBuffer.append("\t.");
                        } else if (n2 == 5) {
                            stringBuffer.append("\t");
                        }
                        if (orthologSpNode.getLocusTagCount() <= 1) continue;
                        stringBuffer.append("D");
                        continue;
                    }
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\t");
                stringBuffer.append(((OrthologGroup)object).getClusterNo());
                stringBuffer.append(System.getProperties().getProperty("line.separator"));
            }
            fileOutputStream = new FileOutputStream(string);
            printWriter = new PrintWriter(fileOutputStream);
            printWriter.println(stringBuffer.toString());
            printWriter.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private int getConnectionStatus(List list, OrthologGroup orthologGroup) {
        int n = 0;
        for (OrthologSpNodeConnection orthologSpNodeConnection : list) {
            if (orthologSpNodeConnection.getOrthologGroupDiff() == -1) {
                if (orthologSpNodeConnection.getGeneDiff() == 1) {
                    n = 1;
                    continue;
                }
                n = 2;
                continue;
            }
            n = 3;
        }
        if (n == 0) {
            n = orthologGroup.getGeneCount() > 0 ? 4 : 5;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        try {
            GenomeAlignGenerater genomeAlignGenerater = new GenomeAlignGenerater();
            genomeAlignGenerater.execute(null);
            try {
                String string = "C:\\project\\mbgd\\tmp\\output" + System.currentTimeMillis() + ".txt";
                genomeAlignGenerater.writeSortFile(string, genomeAlignGenerater.getGenomeAlign());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

