/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FuncCatTbl;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JPanel;

class LegendContext {
    private static final String FONT_NAME = "Times New Roman";
    private static final int FONT_STYLE = 0;
    private static double MAX_FOMT_SIZE = 12.0;
    private static double MIN_FOMT_SIZE = 3.0;
    private static double DEFAULT_DIRECTION_WIDTH = 22.0;
    private static double DEFAULT_DIRECTION_HEIGHT = 12.0;
    private static final float DEFAULT_DIRECTION_LINE_WIDTH = 1.0f;
    private static double DEFAULT_DIRECTION_INTERVAL_X = 6.0;
    private static double DEFAULT_DIRECTION_INTERVAL_Y = 6.0;
    private static double DEFAULT_MARGIN_TOP = 10.0;
    private static double DEFAULT_MARGIN_BOTTOM = 10.0;
    private static double DEFAULT_MARGIN_LEFT = 30.0;
    private static double DEFAULT_MARGIN_RIGHT = 10.0;
    private static int DEFAULT_COLUMN_COUNT = 1;
    private double directionWidth = DEFAULT_DIRECTION_WIDTH;
    private double directionHeight = DEFAULT_DIRECTION_HEIGHT;
    private float directionLineWidth = 1.0f;
    private double directionIntervalX = DEFAULT_DIRECTION_INTERVAL_X;
    private double directionIntervalY = DEFAULT_DIRECTION_INTERVAL_Y;
    private double nameWidth;
    private double marginTop = DEFAULT_MARGIN_TOP;
    private double marginBottom = DEFAULT_MARGIN_BOTTOM;
    private double marginLeft = DEFAULT_MARGIN_LEFT;
    private double marginRight = DEFAULT_MARGIN_RIGHT;
    private int columnCount = DEFAULT_COLUMN_COUNT;
    private boolean drawNewLineRow = false;
    private boolean showNextPageLegend = false;

    LegendContext() {
    }

    public double getFontSize() {
        double d = this.getDirectionHeight();
        if (d < MIN_FOMT_SIZE) {
            return MIN_FOMT_SIZE;
        }
        if (d > MAX_FOMT_SIZE) {
            return MAX_FOMT_SIZE;
        }
        return d;
    }

    public Font createFont() {
        return new Font(FONT_NAME, 0, (int)this.getFontSize());
    }

    public double getDirectionWidth() {
        return this.directionWidth;
    }

    public void setDirectionWidth(double d) {
        this.directionWidth = d;
    }

    public double getDirectionHeight() {
        return this.directionHeight;
    }

    public void setDirectionHeight(double d) {
        this.directionHeight = d;
    }

    public float getDirectionLineWidth() {
        return this.directionLineWidth;
    }

    public void setDirectionLineWidth(float f) {
        this.directionLineWidth = f;
    }

    public double getDirectionIntervalX() {
        return this.directionIntervalX;
    }

    public void setDirectionIntervalX(double d) {
        this.directionIntervalX = d;
    }

    public double getDirectionIntervalY() {
        return this.directionIntervalY;
    }

    public void setDirectionIntervalY(double d) {
        this.directionIntervalY = d;
    }

    public double getNameWidth() {
        return this.nameWidth;
    }

    public void setNameWidth(double d) {
        this.nameWidth = d;
    }

    public double calcNameWidth() {
        JPanel jPanel = new JPanel();
        FontMetrics fontMetrics = jPanel.getFontMetrics(this.createFont());
        double d = 0.0;
        FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
        for (FuncCat funcCat : funcCatTbl.values()) {
            double d2 = fontMetrics.stringWidth(funcCat.getName());
            if (!(d < d2)) continue;
            d = d2;
        }
        return (int)d;
    }

    public double getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(double d) {
        this.marginTop = d;
    }

    public double getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(double d) {
        this.marginBottom = d;
    }

    public double getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(double d) {
        this.marginLeft = d;
    }

    public double getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(double d) {
        this.marginRight = d;
    }

    public double getLegendHeight() {
        double d = FuncCatTbl.getInstance().size();
        return this.getDirectionHeight() * d + this.getDirectionIntervalY() * (d - 1.0);
    }

    private double getRowHeight() {
        return this.getDirectionHeight() + this.getDirectionIntervalY();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int n) {
        this.columnCount = n;
    }

    public int calcColumnCount(double d) {
        double d2 = d - this.getMarginTop() - this.getMarginBottom();
        double d3 = FuncCatTbl.getInstance().size();
        int n = (int)(d2 / this.getRowHeight());
        return (int)Math.ceil(d3 / (double)n);
    }

    public int getRowCountParColumn() {
        return LegendContext.getRowCountParColumn(this.getColumnCount());
    }

    private static int getRowCountParColumn(int n) {
        FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
        int n2 = funcCatTbl.size() / n;
        if (funcCatTbl.size() % n != 0) {
            ++n2;
        }
        return n2;
    }

    public boolean isDrawNewLineRow() {
        return this.drawNewLineRow;
    }

    public void setDrawNewLineRow(boolean bl) {
        this.drawNewLineRow = bl;
    }

    public boolean isShowNextPageLegend() {
        return this.showNextPageLegend;
    }

    public void setShowNextPageLegend(boolean bl) {
        this.showNextPageLegend = bl;
    }

    public void zoom(double d) {
        this.setMarginTop(DEFAULT_MARGIN_TOP * d);
        this.setMarginBottom(DEFAULT_MARGIN_BOTTOM * d);
        this.setMarginRight(DEFAULT_MARGIN_RIGHT * d);
        this.setDirectionWidth(DEFAULT_DIRECTION_WIDTH * d);
        this.setDirectionHeight(DEFAULT_DIRECTION_HEIGHT * d);
        this.setDirectionLineWidth((float)(1.0 * d));
        this.setDirectionIntervalX(DEFAULT_DIRECTION_INTERVAL_X * d);
        this.setDirectionIntervalY(DEFAULT_DIRECTION_INTERVAL_Y * d);
    }

    public double calcWidth(int n) {
        return (this.getMarginLeft() + this.getDirectionWidth() + this.getDirectionIntervalX() + this.getNameWidth() + this.getMarginRight()) * (double)n;
    }

    public boolean isNextColumn(int n) {
        int n2 = this.getRowCountParColumn();
        return n % n2 == 0;
    }
}

