/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeUtil;
import cgdp.recog.coregenome.LegendContext;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.util.ColorUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;

public class LegendRenderer {
    private LegendContext legendContext = new LegendContext();

    public LegendContext getLegendContext() {
        return this.legendContext;
    }

    public void setLegeneContext(LegendContext legendContext) {
        this.legendContext = legendContext;
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setFont(this.legendContext.createFont());
        this.legendContext.setNameWidth(this.calcFunctionNameWidth(graphics2D));
        this.drawLegend(graphics2D);
    }

    private void drawLegend(Graphics2D graphics2D) {
        Shape shape = this.createDirectionShape();
        double d = this.legendContext.getMarginTop();
        double d2 = this.legendContext.getMarginLeft();
        graphics2D.translate(d2, d);
        int n = 0;
        FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
        double d3 = this.legendContext.calcWidth(1);
        for (FuncCat funcCat : funcCatTbl.values()) {
            Color color = ColorUtil.str2Color(funcCat.getColor());
            graphics2D.setColor(color);
            graphics2D.fill(shape);
            graphics2D.setColor(Color.black);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(this.legendContext.getDirectionLineWidth()));
            graphics2D.draw(shape);
            graphics2D.setStroke(stroke);
            int n2 = (int)(this.legendContext.getDirectionWidth() + this.legendContext.getDirectionIntervalX());
            int n3 = (int)this.legendContext.getDirectionHeight();
            graphics2D.drawString(funcCat.getName(), n2, n3);
            double d4 = this.legendContext.getDirectionHeight() + this.legendContext.getDirectionIntervalY();
            graphics2D.translate(0.0, d4);
            d += d4;
            if (!this.legendContext.isNextColumn(++n)) continue;
            graphics2D.translate(d3, -d + this.legendContext.getMarginTop());
            d2 += d3;
            d = this.legendContext.getMarginTop();
        }
        graphics2D.translate(-d2, -d);
    }

    private double calcFunctionNameWidth(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = 0.0;
        FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
        for (FuncCat funcCat : funcCatTbl.values()) {
            double d2 = fontMetrics.stringWidth(funcCat.getName());
            d = Math.max(d, d2);
        }
        return d;
    }

    protected Shape createDirectionShape() {
        float f = (float)this.legendContext.getDirectionWidth();
        float f2 = (float)this.legendContext.getDirectionHeight();
        return CoreGenomeUtil.createDirectionShape(f, f2, 1);
    }
}

