/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.coregenome;

import cgdp.recog.coregenome.CoreGenomeGeneInfo;
import cgdp.recog.coregenome.OrthologSpNode;
import cgdp.recog.data.Cluster;
import cgdp.recog.util.GeneDirection;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrthologGroup {
    public static final int NULL_INDEX = -1;
    private String orthologGroupId;
    private Cluster cluster;
    private String divideNo = "-1";
    private int direction;
    private int clusterNo;
    private int clusterPosition;
    private String displayGeneName;
    private Map orthologSpNodeMap = new HashMap();
    private int realOrderIndex;

    public String getOrthologGroupId() {
        return this.orthologGroupId;
    }

    public void setOrthologGroupId(String string) {
        this.orthologGroupId = string;
    }

    public String getDivideNo() {
        return this.divideNo;
    }

    public void setDivideNo(String string) {
        this.divideNo = string;
    }

    public String getConbineClusterId() {
        return this.getCluster().getConbinedClusterId();
    }

    public int getIndex() {
        int n = this.getOrthologGroupId().indexOf("_");
        if (n != -1) {
            return Integer.parseInt(this.getOrthologGroupId().substring(n + 1));
        }
        return -1;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean isPositive() {
        return GeneDirection.isPositive(this.getDirection());
    }

    public boolean isNegative() {
        return GeneDirection.isNegative(this.getDirection());
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public String getClusterGeneName() {
        return this.getCluster().getGeneName();
    }

    public String getDisplayGeneName() {
        return this.displayGeneName;
    }

    public void setDisplayGeneName(String string) {
        this.displayGeneName = string;
    }

    public int getRealOrderIndex() {
        return this.realOrderIndex;
    }

    public void setRealOrderIndex(int n) {
        this.realOrderIndex = n;
    }

    public int getClusterNo() {
        return this.clusterNo;
    }

    public void setClusterNo(int n) {
        this.clusterNo = n;
    }

    public int getClusterPosition() {
        return this.clusterPosition;
    }

    public void setClusterPosition(int n) {
        this.clusterPosition = n;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public List getLocusTagList(String string) {
        OrthologSpNode orthologSpNode = (OrthologSpNode)this.orthologSpNodeMap.get(string);
        if (orthologSpNode != null) {
            return orthologSpNode.getLocusTagList();
        }
        return null;
    }

    public int getLocusTagCount(String string) {
        OrthologSpNode orthologSpNode = (OrthologSpNode)this.orthologSpNodeMap.get(string);
        int n = 0;
        if (orthologSpNode != null) {
            n = orthologSpNode.getLocusTagCount();
        }
        return n;
    }

    public List getLocusTagWithoutDomainList(String string) {
        OrthologSpNode orthologSpNode = (OrthologSpNode)this.orthologSpNodeMap.get(string);
        if (orthologSpNode != null) {
            return orthologSpNode.getLocusTagWithoutDomainList();
        }
        return null;
    }

    public void addOrthologSpNode(OrthologSpNode orthologSpNode) {
        this.orthologSpNodeMap.put(orthologSpNode.getOrganism(), orthologSpNode);
    }

    public OrthologSpNode getOrthologSpNode(String string) {
        return (OrthologSpNode)this.orthologSpNodeMap.get(string);
    }

    public int getOrganismCount() {
        return this.orthologSpNodeMap.keySet().size();
    }

    public int getOrganismCountWithoutSpC(Collection collection) {
        int n = 0;
        for (String string : this.orthologSpNodeMap.keySet()) {
            if (collection.contains(string)) continue;
            ++n;
        }
        return n;
    }

    public int getGeneCount() {
        int n = 0;
        for (OrthologSpNode orthologSpNode : this.orthologSpNodeMap.values()) {
            n += orthologSpNode.getLocusTagCount();
        }
        return n;
    }

    public List getGeneInfoList(String string) {
        OrthologSpNode orthologSpNode = this.getOrthologSpNode(string);
        if (orthologSpNode == null) {
            return null;
        }
        return orthologSpNode.getGeneInfoList();
    }

    public int indexOfGeneName(String string) {
        int n = -1;
        if (StringTool.isNull(string)) {
            return n;
        }
        return this.getDisplayGeneName().indexOf(string);
    }

    public List getGeneInfoListMatchGeneName(String string) {
        String string2 = string.toLowerCase();
        ArrayList<CoreGenomeGeneInfo> arrayList = new ArrayList<CoreGenomeGeneInfo>();
        for (OrthologSpNode orthologSpNode : this.orthologSpNodeMap.values()) {
            for (CoreGenomeGeneInfo coreGenomeGeneInfo : orthologSpNode.getGeneInfoList()) {
                if (coreGenomeGeneInfo.getGeneName().toLowerCase().indexOf(string2) == -1) continue;
                arrayList.add(coreGenomeGeneInfo);
            }
        }
        return arrayList;
    }

    public List getGeneInfoListMatchLocusTag(String string) {
        String string2 = string.toLowerCase();
        ArrayList<CoreGenomeGeneInfo> arrayList = new ArrayList<CoreGenomeGeneInfo>();
        for (OrthologSpNode orthologSpNode : this.orthologSpNodeMap.values()) {
            for (CoreGenomeGeneInfo coreGenomeGeneInfo : orthologSpNode.getGeneInfoList()) {
                if (coreGenomeGeneInfo.getLocusTag().toLowerCase().indexOf(string2) == -1) continue;
                arrayList.add(coreGenomeGeneInfo);
            }
        }
        return arrayList;
    }

    public boolean equalsOrthologGroupId(OrthologGroup orthologGroup) {
        if (orthologGroup == null) {
            return false;
        }
        return this.getOrthologGroupId().equals(orthologGroup.getOrthologGroupId());
    }
}

