/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Chromosome;
import cgdp.recog.data.ChromosomeImporter;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.util.ApplicationLogger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeMap;

public class ChromosomeTbl
extends TreeMap {
    private static final ApplicationLogger logger = new ApplicationLogger(ChromosomeTbl.class);
    private Organism organism;

    public ChromosomeTbl(String string) {
        super(new Comparator(){

            public int compare(Object object, Object object2) {
                return Integer.parseInt((String)object) - Integer.parseInt((String)object2);
            }
        });
        this.organism = OrganismUtil.getOrganism(string);
    }

    public ChromosomeTbl(Organism organism) {
        super(new Comparator(){

            public int compare(Object object, Object object2) {
                return Integer.parseInt((String)object) - Integer.parseInt((String)object2);
            }
        });
        this.organism = organism;
    }

    public void read() throws Exception {
        String string = this.organism.getOrganismCode();
        ArrayList arrayList = new ArrayList();
        ChromosomeImporter chromosomeImporter = new ChromosomeImporter(string);
        chromosomeImporter.execute();
        arrayList.addAll(chromosomeImporter.getChromosomeList());
        for (Chromosome chromosome : arrayList) {
            this.put(String.valueOf(chromosome.getId()), chromosome);
        }
    }

    public void read(String string) throws Exception {
        String string2 = this.organism.getOrganismCode();
        ArrayList arrayList = new ArrayList();
        ChromosomeImporter chromosomeImporter = new ChromosomeImporter(string2);
        chromosomeImporter.setFilepath(string);
        chromosomeImporter.execute();
        arrayList.addAll(chromosomeImporter.getChromosomeList());
        for (Chromosome chromosome : arrayList) {
            this.put(String.valueOf(chromosome.getId()), chromosome);
        }
    }

    public void readServerOnly() throws Exception {
        String string = this.organism.getOrganismCode();
        ArrayList arrayList = new ArrayList();
        ChromosomeImporter chromosomeImporter = new ChromosomeImporter(string);
        chromosomeImporter.execute();
        arrayList.addAll(chromosomeImporter.getChromosomeList());
        for (Chromosome chromosome : arrayList) {
            this.put(String.valueOf(chromosome.getId()), chromosome);
        }
    }

    public void readAll() throws Exception {
        String string = this.organism.getOrganismCode();
        ArrayList arrayList = new ArrayList();
        ChromosomeImporter chromosomeImporter = new ChromosomeImporter(string);
        chromosomeImporter.execute();
        arrayList.addAll(chromosomeImporter.getChromosomeList());
        for (Chromosome chromosome : arrayList) {
            this.put(String.valueOf(chromosome.getId()), chromosome);
        }
    }

    public Chromosome getMainChromosome() {
        Chromosome chromosome = null;
        for (Chromosome chromosome2 : this.values()) {
            if (!chromosome2.isChromosome()) continue;
            chromosome = chromosome2;
            break;
        }
        return chromosome;
    }
}

