/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Cluster;
import cgdp.recog.funccat.FunctionCategoryNoComparator;
import java.util.Comparator;

public class ClusterComparator
implements Comparator {
    public static final int CLUSTER_ID = 1;
    public static final int SUB_CLUSTER_ID = 2;
    public static final int CLUSTER_ID_SUB_CLUSTER_ID = 6;
    public static final int FUNCTION_CATEGORY = 3;
    public static final int SUB_FUNCTION_CATEGORY = 4;
    public static final int GENE_NAME = 5;
    private Comparator comparator;

    public ClusterComparator() {
        this(2);
    }

    public ClusterComparator(int n) {
        this.createComparator(n);
    }

    private void createComparator(int n) {
        this.comparator = n == 1 ? new ClusterIDComparator() : (n == 2 ? new SubClusterIDComparator() : (n == 3 ? new FunctionCategoryClusterComparator() : (n == 4 ? new SubFunctionCategoryClusterComparator() : (n == 5 ? new GeneNameComparator() : (n == 6 ? new ClusterIDSubClusterComparator() : new SubClusterIDComparator())))));
    }

    public int compare(Object object, Object object2) {
        return this.comparator.compare(object, object2);
    }

    private class GeneNameComparator
    implements Comparator {
        private GeneNameComparator() {
        }

        public int compare(Object object, Object object2) {
            Cluster cluster = (Cluster)object;
            Cluster cluster2 = (Cluster)object2;
            return cluster.getGeneName().compareToIgnoreCase(cluster2.getGeneName());
        }
    }

    private class SubFunctionCategoryClusterComparator
    implements Comparator {
        private Comparator functionCategoryComparetor = new FunctionCategoryNoComparator();

        private SubFunctionCategoryClusterComparator() {
        }

        public int compare(Object object, Object object2) {
            Cluster cluster = (Cluster)object;
            Cluster cluster2 = (Cluster)object2;
            return this.functionCategoryComparetor.compare(cluster.getSubFunctionCategory(), cluster2.getSubFunctionCategory());
        }
    }

    private class FunctionCategoryClusterComparator
    implements Comparator {
        private Comparator functionCategoryComparetor = new FunctionCategoryNoComparator();

        private FunctionCategoryClusterComparator() {
        }

        public int compare(Object object, Object object2) {
            Cluster cluster = (Cluster)object;
            Cluster cluster2 = (Cluster)object2;
            return this.functionCategoryComparetor.compare(cluster.getFunctionCategory(), cluster2.getFunctionCategory());
        }
    }

    private class ClusterIDSubClusterComparator
    implements Comparator {
        private ClusterIDSubClusterComparator() {
        }

        public int compare(Object object, Object object2) {
            Cluster cluster = (Cluster)object;
            Cluster cluster2 = (Cluster)object2;
            int n = cluster.getClusterId() - cluster2.getClusterId();
            if (n != 0) {
                return n;
            }
            n = cluster.getSubClusterId() - cluster2.getSubClusterId();
            return n;
        }
    }

    private class SubClusterIDComparator
    implements Comparator {
        private SubClusterIDComparator() {
        }

        public int compare(Object object, Object object2) {
            Cluster cluster = (Cluster)object;
            Cluster cluster2 = (Cluster)object2;
            return cluster.getSubClusterId() - cluster2.getSubClusterId();
        }
    }

    private class ClusterIDComparator
    implements Comparator {
        private ClusterIDComparator() {
        }

        public int compare(Object object, Object object2) {
            Cluster cluster = (Cluster)object;
            Cluster cluster2 = (Cluster)object2;
            return cluster.getClusterId() - cluster2.getClusterId();
        }
    }
}

