/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Cluster;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.MapUtil;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterFileAccessHelper {
    private static final String DELIMITER = "\t";
    public static final String DELIMITER_ORGANISM = ":";
    public static final String DELIMITER_LOCUSTAG = " ";
    public static final int NO_SUB_CLUSTER_ID = Integer.MAX_VALUE;

    private ClusterFileAccessHelper() {
    }

    public static String createGeneInfoString(Cluster cluster) {
        ArrayList arrayList = new ArrayList(cluster.getSpSet());
        Collections.sort(arrayList);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList) {
            List list = cluster.getGeneInformationList(string);
            if (CollectionUtil.isNull(list)) continue;
            List list2 = GeneUtil.getLocusTagList(list);
            String string2 = GeneUtil.getOrganismLocusTagsString(string, list2, DELIMITER_ORGANISM, DELIMITER_LOCUSTAG);
            stringBuffer.append(string2);
            if (n != arrayList.size() - 1) {
                stringBuffer.append(DELIMITER);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Map createOrganismCodeLocusTagMap(Collection collection) {
        HashMap hashMap = new HashMap();
        for (String string : collection) {
            Map map = GeneUtil.createLocusTagMapFromOrganismLocusTagsString(string, DELIMITER_ORGANISM, DELIMITER_LOCUSTAG);
            if (MapUtil.isNull(map)) continue;
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public static boolean isExistSubCluster(int n) {
        return n != Integer.MAX_VALUE;
    }
}

