/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.bean.Const;
import cgdp.recog.data.ClusterId;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ClusterIdTbl
extends ArrayList {
    private static ClusterIdTbl m_clusterIdTbl = new ClusterIdTbl();
    HashMap m_clusterIdMap;

    private ClusterIdTbl() {
        this.clear2();
        try {
            this.readClusterId();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, iOException.getMessage(), "Error", 0);
            System.exit(0);
        }
    }

    private void clear2() {
        this.m_clusterIdMap = new HashMap();
    }

    private void readClusterId() throws IOException {
        String string;
        if (!new File(Const.USER_CLUSTER_ID_DAT_PATH).exists()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(Const.USER_CLUSTER_ID_DAT_PATH);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (StringTool.isNull(string)) continue;
            Vector vector = StringTool.splitString(string, "<>");
            if (vector.size() != 2) {
                vector.clear();
                vector = null;
                continue;
            }
            ClusterId clusterId = new ClusterId();
            clusterId.setClusterId(Integer.parseInt((String)vector.get(0)));
            clusterId.setColor((String)vector.get(1));
            this.add(clusterId);
            this.m_clusterIdMap.put(new Integer(clusterId.getClusterId()), clusterId);
            vector.clear();
            vector = null;
        }
        fileInputStream.close();
    }

    public void writeClusterId() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(Const.USER_CLUSTER_ID_DAT_PATH);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        for (ClusterId clusterId : this) {
            printWriter.println(clusterId.getClusterId() + "<>" + clusterId.getColor());
        }
        printWriter.flush();
        fileOutputStream.close();
    }

    public static ClusterIdTbl getInstance() {
        return m_clusterIdTbl;
    }

    public HashMap getClusterIdMap() {
        return this.m_clusterIdMap;
    }

    public ArrayList createClusterIdColor(int n, int n2, int n3) {
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n2 >> 16 & 0xFF;
        int n8 = n2 >> 8 & 0xFF;
        int n9 = n2 & 0xFF;
        double d = (double)(n7 - n4) / (double)(n3 - 1);
        double d2 = (double)(n8 - n5) / (double)(n3 - 1);
        double d3 = (double)(n9 - n6) / (double)(n3 - 1);
        ArrayList<ClusterId> arrayList = new ArrayList<ClusterId>();
        for (int i = 0; i < n3; ++i) {
            int n10 = n4 + (int)((double)i * d);
            int n11 = n5 + (int)((double)i * d2);
            int n12 = n6 + (int)((double)i * d3);
            int n13 = n10 < 0 ? 0 : (n10 = n10 > 255 ? 255 : n10);
            int n14 = n11 < 0 ? 0 : (n11 = n11 > 255 ? 255 : n11);
            n12 = n12 < 0 ? 0 : (n12 > 255 ? 255 : n12);
            String string = Integer.toString(n10, 16);
            string = string.length() == 1 ? "0" + string : string;
            String string2 = Integer.toString(n11, 16);
            string2 = string2.length() == 1 ? "0" + string2 : string2;
            String string3 = Integer.toString(n12, 16);
            string3 = string3.length() == 1 ? "0" + string3 : string3;
            ClusterId clusterId = new ClusterId();
            clusterId.setClusterId(i + 1);
            clusterId.setColor("#" + string + string2 + string3);
            arrayList.add(clusterId);
        }
        return arrayList;
    }

    public void setClusterIdColor(List list) {
        this.clear();
        this.addAll(list);
        this.m_clusterIdMap.clear();
        for (ClusterId clusterId : this) {
            this.m_clusterIdMap.put(new Integer(clusterId.getClusterId()), clusterId);
        }
    }
}

