/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Contig;
import cgdp.recog.data.DataManager;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ContigImporter
extends FileImporter {
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_UDATE = "udate";
    private static final String COLUMN_GENOME = "genome";
    private static final String COLUMN_SPID = "spid";
    private static final String COLUMN_SP = "sp";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_SEQNO = "seqno";
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_SHAPE = "shape";
    private static final String COLUMN_STATUS = "status";
    private static final String COLUMN_ACCESSION = "accession";
    private static final String COLUMN_GI = "gi";
    private static final String COLUMN_SEQ = "seq";
    private static final String COLUMN_SEQ_LENGTH = "seq_length";
    private static final String COLUMN_COUNT_GENES = "count_genes";
    private static final String COLUMN_LENGTH = "length";
    private String organismCode;
    private String filepath;
    private List columnNameList = new ArrayList();
    private List contigList = new ArrayList();

    public ContigImporter(String string) {
        this.organismCode = string;
        this.filepath = DataManager.getContigFilePath(this.organismCode);
        System.err.println("contig_filepath=" + this.filepath);
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }

    @Override
    protected void parseHeaderLine(String string) {
        this.columnNameList.addAll(StringTool.splitString(string, "\t"));
    }

    @Override
    protected void parseDataLine(int n, String string) {
        Contig contig = new Contig();
        Vector vector = StringTool.splitString(string, "\t");
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)this.columnNameList.get(i);
            String string3 = String.valueOf(vector.get(i));
            this.setParameter(string2, string3, contig);
        }
        this.contigList.add(contig);
    }

    private void setParameter(String string, String string2, Contig contig) {
        if (string.equals(COLUMN_ID)) {
            contig.setId(Integer.parseInt(string2));
        } else if (string.equals(COLUMN_SPID)) {
            contig.setSpid(string2);
        } else if (string.equals(COLUMN_SP)) {
            contig.setOrganismCode(string2);
        } else if (string.equals(COLUMN_SHAPE)) {
            contig.setShape(string2);
        } else if (string.equals(COLUMN_LENGTH)) {
            contig.setLength(Integer.parseInt(string2));
        } else if (string.equals(COLUMN_NAME)) {
            contig.setName(string2);
        } else if (string.equals(COLUMN_SEQNO)) {
            contig.setSeqNo(string2);
        } else if (string.equals(COLUMN_TYPE)) {
            contig.setType(string2);
        } else if (string.equals(COLUMN_ACCESSION)) {
            contig.setAccession(string2);
        } else if (string.equals(COLUMN_GI)) {
            contig.setGi(string2);
        } else if (string.equals(COLUMN_SEQ)) {
            contig.setSeq(string2);
        } else if (string.equals(COLUMN_SEQ_LENGTH)) {
            contig.setSeqLength(Integer.parseInt(string2));
        } else if (string.equals(COLUMN_COUNT_GENES) && !StringTool.isNull(string2)) {
            contig.setCountGene(Integer.parseInt(string2));
        }
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    public List getContigList() {
        return this.contigList;
    }
}

