/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.DataFileDownloader;
import cgdp.recog.data.DataManager;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.update.AbstractDataUpdater;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;

public class DataClearExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(DataClearExecuter.class);
    private MediatorImpl mediator;

    public DataClearExecuter(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            progressImpl.setTotal(6);
            String string = AccessServer.getDataDir();
            FileUtil.delete(string);
            progressImpl.increment();
            DataFileDownloader dataFileDownloader = DataFileDownloader.getInstance();
            DataManager.createDataDirectory();
            progressImpl.increment();
            dataFileDownloader.downloadTaxonomyData(true);
            progressImpl.increment();
            dataFileDownloader.downloadGenomeData();
            progressImpl.increment();
            FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
            funcCatTbl.restoreAll(true);
            progressImpl.increment();
            AbstractDataUpdater.updateDataVersion();
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to clear data file. data directory:" + AccessServer.getDataDir();
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    @Override
    public void done() {
        this.mediator.newAnalysis();
    }
}

