/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Gene;
import cgdp.recog.util.FileExporter;
import cgdp.recog.util.FileUtil;
import java.util.List;

public class GeneExporter
extends FileExporter {
    private static final String HEADER = "id\tudate\tsp\tname\tgene\tchrid\tcontigid\tfrom1\tto1\tdir\tlocation\ttype\ttransl_table\tcodon_start\tprotid\tgi\tgeneid\tntseq\taaseq\tdescr\taalen\tfunccat";
    private static final String DELIMITER = "\t";
    private String filepath;
    private List geneList;

    public GeneExporter(String string, List list) {
        this.filepath = string;
        this.geneList = list;
    }

    @Override
    protected String getContents() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HEADER);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (Gene gene : this.geneList) {
            stringBuffer.append(gene.getId());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getUdate());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getOrganism());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getLocusTag());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getGeneName());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getChromId());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getContigId());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getStart());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getEnd());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getDirection());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getLocation());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getFeatureKey());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getTranslTable());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getCodonStart());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getAccession());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getGi());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getGeneId());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getNtseq());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getAaseq());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getDescription());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getAalen());
            stringBuffer.append(DELIMITER);
            stringBuffer.append(gene.getFunccat());
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }
}

