/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.info.gene.GeneInfo;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.util.GeneUtil;

public class GeneInformation {
    private String locusTag;
    private String geneName;
    private int domainNo;
    private int from;
    private int to;
    private boolean maxDomain = false;
    private boolean outgroupIngroup = false;
    private boolean outergroup = false;

    public String getLocusTag() {
        return this.locusTag;
    }

    public String getLocusTagWithoutDomain() {
        return GeneUtil.removeDomainNo(this.getLocusTag());
    }

    public void setLocusTag(String string) {
        this.locusTag = string;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String string) {
        this.geneName = string;
    }

    public int getDomainNo() {
        return this.domainNo;
    }

    public void setDomainNo(int n) {
        this.domainNo = n;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int n) {
        this.from = n;
    }

    public int getTo() {
        return this.to;
    }

    public void setTo(int n) {
        this.to = n;
    }

    public int getLength() {
        return GeneUtil.getDNALength(this.getFrom(), this.getTo());
    }

    public void setMaxDomain(boolean bl) {
        this.maxDomain = bl;
    }

    public boolean isMaxDomain() {
        return this.maxDomain;
    }

    public boolean isDomain() {
        return this.getDomainNo() != 0;
    }

    public boolean isOutgroupIngroup() {
        return this.outgroupIngroup;
    }

    public void setOutgroupIngroup(boolean bl) {
        this.outgroupIngroup = bl;
    }

    public boolean isOutergroup() {
        return this.outergroup;
    }

    public void setOutergroup(boolean bl) {
        this.outergroup = bl;
    }

    public boolean equalsLocusTag(String string) {
        return this.getLocusTag().equals(string);
    }

    public boolean equalsLocusTagWithoutDomain(String string) {
        return this.getLocusTagWithoutDomain().equals(string);
    }

    public boolean equalsGeneInfo(GeneInformation geneInformation) {
        if (geneInformation == null) {
            return false;
        }
        return this.equalsLocusTag(geneInformation.getLocusTag());
    }

    public GeneInfo createGeneInfoWithoutDomainNo(String string) {
        GeneInfo geneInfo = new GeneInfo();
        geneInfo.putInfo(GeneInfoTitle.TITLE_ORGANISM_CODE, string);
        geneInfo.putInfo(GeneInfoTitle.TITLE_LOCUSTAG_SERVER, this.getLocusTagWithoutDomain());
        geneInfo.putInfo(GeneInfoTitle.TITLE_START_ON_GENE, new Float(this.getFrom()));
        geneInfo.putInfo(GeneInfoTitle.TITLE_END_ON_GENE, new Float(this.getTo()));
        return geneInfo;
    }
}

