/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.DataManager;
import cgdp.recog.data.Gene;
import cgdp.recog.data.GeneImporter;
import cgdp.recog.organism.Organism;
import cgdp.recog.organism.OrganismUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileImporter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class GeneTbl
extends HashMap {
    private static final ApplicationLogger logger = new ApplicationLogger(GeneTbl.class);
    private Organism organism;
    private String geneName;
    private boolean serverOnly = false;

    public GeneTbl(String string) {
        Organism organism;
        this.organism = organism = OrganismUtil.getOrganism(string);
    }

    public GeneTbl(Organism organism) {
        this(organism, null);
    }

    private GeneTbl(Organism organism, String string) {
        this.organism = organism;
        this.geneName = string;
    }

    public static Gene readOneGene(String string, String string2) throws Exception {
        Object object = DataManager.getProjectGeneFilePath(string);
        if (new File((String)object).isFile()) {
            GeneImporter geneImporter = new GeneImporter(string, string2);
            geneImporter.setFilepath((String)object);
            geneImporter.execute();
            List list = geneImporter.getGeneList();
            if (!CollectionUtil.isNull(list)) {
                return (Gene)list.get(0);
            }
            return null;
        }
        object = new GeneImporter(string, string2);
        ((FileImporter)object).execute();
        List list = ((GeneImporter)object).getGeneList();
        if (!CollectionUtil.isNull(list)) {
            return (Gene)list.get(0);
        }
        return null;
    }

    public void read() throws Exception {
        Object object;
        if (!this.isServerOnly() && new File((String)(object = DataManager.getProjectGeneFilePath(this.organism.getOrganismCode()))).isFile()) {
            this.read((String)object);
            return;
        }
        object = new GeneImporter(this.organism.getOrganismCode(), this.geneName);
        ((FileImporter)object).execute();
        List list = ((GeneImporter)object).getGeneList();
        for (Gene gene : list) {
            this.put(gene.getLocusTag(), gene);
        }
    }

    public void read(String string) throws Exception {
        GeneImporter geneImporter = new GeneImporter(this.organism.getOrganismCode(), this.geneName);
        geneImporter.setFilepath(string);
        geneImporter.execute();
        List list = geneImporter.getGeneList();
        for (Gene gene : list) {
            this.put(gene.getLocusTag(), gene);
        }
    }

    public void read(Set set) throws Exception {
        Object object;
        if (!this.isServerOnly() && new File((String)(object = DataManager.getProjectGeneFilePath(this.organism.getOrganismCode()))).isFile()) {
            GeneImporter geneImporter = new GeneImporter(this.organism.getOrganismCode(), this.geneName);
            geneImporter.setFilepath((String)object);
            geneImporter.setLoadFields(set);
            geneImporter.execute();
            List list = geneImporter.getGeneList();
            for (Gene gene : list) {
                this.put(gene.getLocusTag(), gene);
            }
            return;
        }
        object = new GeneImporter(this.organism.getOrganismCode(), this.geneName);
        ((GeneImporter)object).setLoadFields(set);
        ((FileImporter)object).execute();
        List list = ((GeneImporter)object).getGeneList();
        for (Gene gene : list) {
            this.put(gene.getLocusTag(), gene);
        }
    }

    public List getRNAList() {
        ArrayList<Gene> arrayList = new ArrayList<Gene>();
        for (Gene gene : this.values()) {
            if (!gene.isRNA()) continue;
            arrayList.add(gene);
        }
        return arrayList;
    }

    public void setServerOnly(boolean bl) {
        this.serverOnly = bl;
    }

    public boolean isServerOnly() {
        return this.serverOnly;
    }
}

