/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Genome;
import cgdp.recog.data.GenomeImporter;
import cgdp.recog.util.FileUtil;
import java.util.List;

public class GenomeExporter {
    private static final String DELIMITER = "\t";
    private List genomeList;
    private String filepath;

    public GenomeExporter(List list, String string) {
        this.genomeList = list;
        this.filepath = string;
    }

    public void execute() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        GenomeExporter.createHeaderLine(stringBuffer);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        for (Genome genome : this.genomeList) {
            GenomeExporter.createGenomeRecode(stringBuffer, genome);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        FileUtil.outputFile(stringBuffer.toString(), this.filepath);
    }

    private static void createHeaderLine(StringBuffer stringBuffer) {
        String[] stringArray = GenomeImporter.HEADERS;
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(DELIMITER);
        }
    }

    private static void createGenomeRecode(StringBuffer stringBuffer, Genome genome) {
        stringBuffer.append(genome.getSpeciesID());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(genome.getSpeciesCode());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(genome.getSpecweight());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(genome.getAbbrev());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(genome.getOrgname());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(genome.getStrain());
        stringBuffer.append(DELIMITER);
        stringBuffer.append(genome.getMbgdUpdate());
    }
}

