/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.Genome;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileImporter;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class GenomeImporter
extends FileImporter {
    static final String DELIMITER = "\t";
    private static final String COLUMN_SPID = "spid";
    private static final String COLUMN_SP = "sp";
    private static final String COLUMN_SPECWEIGHT = "specweight";
    private static final String COLUMN_ABBREV = "abbrev";
    private static final String COLUMN_ORGNAME = "orgname";
    private static final String COLUMN_STRAIN = "strain";
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_MBGD_UPDATE = "mbgd_update";
    static final String[] HEADERS = new String[]{"spid", "sp", "specweight", "abbrev", "orgname", "strain", "mbgd_update"};
    static final String[] HEADERS_DEV = new String[]{"spid", "sp", "specweight", "abbrev", "orgname", "strain", "type", "mbgd_update"};
    private String filepath;
    private List columnNameList = new ArrayList();
    private Collection targetOrganismCodeC;
    private List genomeList = new ArrayList();

    public GenomeImporter(String string) {
        this.filepath = string;
    }

    @Override
    protected String getFilepath() {
        return this.filepath;
    }

    public void setTargetOrganismCodeSet(Collection collection) {
        this.targetOrganismCodeC = collection;
    }

    @Override
    protected void parseDataLine(int n, String string) {
        Genome genome = new Genome();
        Vector vector = StringTool.splitString(string, DELIMITER);
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)this.columnNameList.get(i);
            String string3 = String.valueOf(vector.get(i));
            this.setParameter(string2, string3, genome);
        }
        if (!CollectionUtil.isNull(this.targetOrganismCodeC) && !this.targetOrganismCodeC.contains(genome.getSpeciesCode())) {
            return;
        }
        this.genomeList.add(genome);
    }

    @Override
    protected void parseHeaderLine(String string) {
        this.columnNameList.addAll(StringTool.splitString(string, DELIMITER));
    }

    private void setParameter(String string, String string2, Genome genome) {
        if (string.equals(COLUMN_SPID)) {
            genome.setSpeciesID(string2);
        } else if (string.equals(COLUMN_SP)) {
            genome.setSpeciesCode(string2);
        } else if (string.equals(COLUMN_SPECWEIGHT)) {
            long l = Long.parseLong(string2);
            genome.setSpecweight(l);
        } else if (string.equals(COLUMN_ABBREV)) {
            genome.setAbbrev(string2);
        } else if (string.equals(COLUMN_ORGNAME)) {
            genome.setOrgname(string2);
        } else if (string.equals(COLUMN_STRAIN)) {
            genome.setStrain(string2);
        } else if (string.equals(COLUMN_TYPE)) {
            genome.setType(string2);
        } else if (string.equals(COLUMN_MBGD_UPDATE)) {
            String string3 = string2.replaceAll("-", "/");
            genome.setMbgdUpdate(string3);
        }
    }

    public List getGenomeList() {
        return this.genomeList;
    }
}

