/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.RankComparator;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RankDif {
    public static final String NO_RANK = "no rank";
    public static final String TOP_LEVEL = "top level";
    public static final String SUPERKINGDOM = "superkingdom";
    public static final String KINGDOM = "kingdom";
    public static final String SUBKINGDOM = "subkingdom";
    public static final String SUPERPHYLUM = "superphylum";
    public static final String PHYLUM = "phylum";
    public static final String SUBPHYLUM = "subphylum";
    public static final String CLASS = "class";
    public static final String SUBCLASS = "subclass";
    public static final String ORDER = "order";
    public static final String SUBORDER = "suborder";
    public static final String FAMILY = "family";
    public static final String TRIBE = "tribe";
    public static final String GENUS = "genus";
    public static final String SPECIES_GROUP = "species group";
    public static final String SPECIES = "species";
    public static final String GENOME = "genome";
    private static final int RANK_VALUE_DEFAULT = -1;
    private static final int RANK_VALUE_NO_RANK = 100;
    private static final int RANK_VALUE_TOP_LEVEL = 50;
    private static final int RANK_VALUE_SUPERKINGDOM = 46;
    private static final int RANK_VALUE_KINGDOM = 45;
    private static final int RANK_VALUE_SUBKINGDOM = 44;
    private static final int RANK_VALUE_PHYLUM = 40;
    private static final int RANK_VALUE_SUBPHYLUM = 39;
    private static final int RANK_VALUE_CLASS = 35;
    private static final int RANK_VALUE_SUBCLASS = 34;
    private static final int RANK_VALUE_ORDER = 30;
    private static final int RANK_VALUE_SUBORDER = 29;
    private static final int RANK_VALUE_FAMILY = 25;
    private static final int RANK_VALUE_TRIBE = 20;
    private static final int RANK_VALUE_GENUS = 15;
    private static final int RANK_VALUE_SPECIES_GROUP = 10;
    private static final int RANK_VALUE_SPECIES = 5;
    private static final int RANK_VALUE_GENOME = 2;
    public static final String[] RANKS = new String[]{"top level", "superkingdom", "kingdom", "superphylum", "phylum", "subphylum", "class", "subclass", "order", "suborder", "family", "tribe", "genus", "species group", "species", "no rank"};

    public static List getRankList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < RANKS.length; ++i) {
            arrayList.add(RANKS[i]);
        }
        arrayList.add(GENOME);
        arrayList.remove(NO_RANK);
        return arrayList;
    }

    public static boolean isNoRank(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(NO_RANK);
    }

    public static boolean isTopLevel(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(TOP_LEVEL);
    }

    public static boolean isSuperkingdom(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(SUPERKINGDOM);
    }

    public static boolean isKingdom(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(KINGDOM);
    }

    public static boolean isSubKingdom(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(SUBKINGDOM);
    }

    public static boolean isSuperphylum(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(SUPERPHYLUM);
    }

    public static boolean isPhylum(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(PHYLUM);
    }

    public static boolean isSubphylum(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(SUBPHYLUM);
    }

    public static boolean isClass(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(CLASS);
    }

    public static boolean isSubclass(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(SUBCLASS);
    }

    public static boolean isOrder(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(ORDER);
    }

    public static boolean isSuborder(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(SUBORDER);
    }

    public static boolean isFamily(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(FAMILY);
    }

    public static boolean isTribe(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(TRIBE);
    }

    public static boolean isGenus(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(GENUS);
    }

    public static boolean isSpeciesGroup(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(SPECIES_GROUP);
    }

    public static boolean isSpecies(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(SPECIES);
    }

    public static boolean isGenome(String string) {
        if (StringTool.isNull(string)) {
            return false;
        }
        return string.equals(GENOME);
    }

    public static int getRankValue(String string) {
        int n = -1;
        if (StringTool.isNull(string)) {
            return n;
        }
        if (RankDif.isSuperkingdom(string)) {
            n = 46;
        } else if (RankDif.isKingdom(string)) {
            n = 45;
        } else if (RankDif.isSubKingdom(string)) {
            n = 44;
        } else if (RankDif.isSuperphylum(string)) {
            n = 39;
        } else if (RankDif.isPhylum(string)) {
            n = 40;
        } else if (RankDif.isSubphylum(string)) {
            n = 39;
        } else if (RankDif.isOrder(string)) {
            n = 30;
        } else if (RankDif.isSuborder(string)) {
            n = 29;
        } else if (RankDif.isClass(string)) {
            n = 35;
        } else if (RankDif.isSubclass(string)) {
            n = 34;
        } else if (RankDif.isFamily(string)) {
            n = 25;
        } else if (RankDif.isTribe(string)) {
            n = 20;
        } else if (RankDif.isGenus(string)) {
            n = 15;
        } else if (RankDif.isSpeciesGroup(string)) {
            n = 10;
        } else if (RankDif.isSpecies(string)) {
            n = 5;
        } else if (RankDif.isGenome(string)) {
            n = 2;
        } else if (RankDif.isNoRank(string)) {
            n = 100;
        }
        return n;
    }

    public static String getMinimumRank(List list) {
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new RankComparator());
        return (String)arrayList.get(arrayList.size() - 1);
    }
}

