/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.GenomeTbl;
import cgdp.recog.organism.Organism;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AccessServer;
import cgdp.recog.spgroup.SpGroup;
import cgdp.recog.spgroup.SpGroups;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class SpGroupTbl {
    private static final ApplicationLogger logger = new ApplicationLogger(SpGroupTbl.class);
    private static final String SPGROUP_DAT_NAME = "spgroup.dat";
    private static final String SPGROUP_DAT_NAME_PREFIX = "spgroup";
    private static final String SPGROUP_DAT_NAME_EXTENSION = ".dat";
    private static final String SP_GROUP_DELIMITER = "\t";
    private static final String SP_DELIMITER = ",";
    private static final String HEADER = "Name\tSpGroup" + FileUtil.LINE_SEPARETOR;
    private static final SpGroupTbl SPGROUPTBL = new SpGroupTbl();
    private SpGroups spGroups = new SpGroups();

    private SpGroupTbl() {
        this.read();
    }

    public static SpGroupTbl getInstance() {
        return SPGROUPTBL;
    }

    public void init() throws IOException {
        this.spGroups = new SpGroups();
        this.read();
    }

    private static File getSpGroupFile() {
        String string;
        File file;
        String string2;
        File file2 = ProjectAccesser.getProjectDir();
        File file3 = new File(file2, string2 = "spgroup_" + AccessServer.getServerName() + SPGROUP_DAT_NAME_EXTENSION);
        if (!file3.isFile() && (file = new File(file2, string = SPGROUP_DAT_NAME)).isFile()) {
            file.renameTo(file3);
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        File file = SpGroupTbl.getSpGroupFile();
        if (!file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                logger.warn("Fail to read spgroup.dat", exception);
                return false;
            }
            return true;
        }
        GenomeTbl genomeTbl = new GenomeTbl();
        Map map = genomeTbl.createOrganismMap(null);
        long l = System.currentTimeMillis();
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            bufferedReader.readLine();
            while ((string = bufferedReader.readLine()) != null) {
                SpGroup spGroup = this.createSpGroup(string, map, l++);
                this.spGroups.addSpGroup(spGroup);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            logger.warn("Fail to read spgroup.dat", exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to close spgroup.dat", iOException);
                }
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to close spgroup.dat", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        File file = SpGroupTbl.getSpGroupFile();
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileWriter = new FileWriter(file);
            bufferedWriter = new BufferedWriter(fileWriter);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(HEADER);
            int n = 0;
            for (SpGroup spGroup : this.spGroups.getSpGroupList()) {
                this.createSpGroupRecode(stringBuffer, spGroup);
                if (n != this.spGroups.getSpGroupSize() - 1) {
                    stringBuffer.append(FileUtil.LINE_SEPARETOR);
                }
                ++n;
            }
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            logger.warn("Fail to write spgroup.dat", iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to close spgroup.dat", iOException);
                }
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to close spgroup.dat", iOException);
                }
            }
        }
    }

    private void createSpGroupRecode(StringBuffer stringBuffer, SpGroup spGroup) {
        stringBuffer.append(spGroup.getName());
        stringBuffer.append(SP_GROUP_DELIMITER);
        int n = 0;
        for (String string : spGroup.getSpList()) {
            stringBuffer.append(string);
            if (n != spGroup.getSpCount() - 1) {
                stringBuffer.append(SP_DELIMITER);
            }
            ++n;
        }
    }

    private SpGroup createSpGroup(String string, Map map, long l) {
        Vector vector = StringTool.splitString(string, SP_GROUP_DELIMITER);
        SpGroup spGroup = new SpGroup(l);
        spGroup.setName(String.valueOf(vector.get(0)));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Vector vector2 = StringTool.splitString(String.valueOf(vector.get(1)), SP_DELIMITER);
        for (String string2 : vector2) {
            String string3 = ((Organism)map.get(string2)).getName();
            hashMap.put(string2, string3);
        }
        spGroup.addSpMap(hashMap);
        return spGroup;
    }

    public SpGroups getSpGroups() {
        return this.spGroups;
    }

    public void setSpGroups(SpGroups spGroups) {
        this.spGroups = spGroups;
    }
}

