/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.data;

import cgdp.recog.data.DataManager;
import cgdp.recog.data.RankDif;
import cgdp.recog.data.TaxonomyItem;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TaxonomyTbl {
    private static final ApplicationLogger logger = new ApplicationLogger(TaxonomyTbl.class);
    private static final int INDEX_ORDER = 0;
    private static final int INDEX_NAME = 1;
    private static final int INDEX_ORGANISM_CODE = 2;
    private static final int INDEX_CATEGORY = 3;
    private List taxonomyItemList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileReader = new FileReader(DataManager.getTaxonomyDat());
            bufferedReader = new BufferedReader(fileReader);
            int n = 0;
            bufferedReader.readLine();
            while ((string = bufferedReader.readLine()) != null) {
                TaxonomyItem taxonomyItem = this.createTaxonomyItem(string, n);
                this.taxonomyItemList.add(taxonomyItem);
                ++n;
            }
        }
        catch (Exception exception) {
            logger.warn("Fail to read genome.dat", exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to close genome.dat", iOException);
                }
            }
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    logger.warn("Fail to close genome.dat", iOException);
                }
            }
        }
        return true;
    }

    private TaxonomyItem createTaxonomyItem(String string, int n) {
        Vector vector = StringTool.splitString(string, "\t");
        TaxonomyItem taxonomyItem = new TaxonomyItem();
        taxonomyItem.setTaxOrder(n);
        taxonomyItem.setOrder(Integer.parseInt(String.valueOf(vector.get(0))));
        taxonomyItem.setName(String.valueOf(vector.get(1)));
        taxonomyItem.setCategory(String.valueOf(vector.get(3)));
        String string2 = String.valueOf(vector.get(2));
        ArrayList arrayList = new ArrayList(StringTool.splitString(string2));
        taxonomyItem.setOrganismCodeList(arrayList);
        return taxonomyItem;
    }

    public Map getGenomeOrganismCodeIndexMap() {
        HashMap hashMap = new HashMap();
        for (TaxonomyItem taxonomyItem : this.taxonomyItemList) {
            if (!RankDif.isGenome(taxonomyItem.getCategory())) continue;
            hashMap.put(taxonomyItem.getOrganismCodeList().get(0), new Integer(taxonomyItem.getTaxOrder()));
        }
        return hashMap;
    }
}

