/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.access.AbstractImporter;
import cgdp.recog.domclust.DomClustImporter;
import cgdp.recog.domclust.DomClustListImporter;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ServerStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractDomClustImporter
extends AbstractImporter {
    protected String filepath;
    protected String formatVersion;
    protected List speciesOrganismCodeList = new ArrayList();
    protected List ingroupOrganismCodeList = new ArrayList();
    protected List outgroupOrganismCodeList = new ArrayList();
    protected String domClustId;
    protected String clusterViewId;
    protected int nClusters;
    protected String domClustConditionString;
    protected boolean forView = false;
    protected List columnNameList = new ArrayList();
    protected List clusterList = new ArrayList();
    protected ProgressImpl progressImpl = new DummyProgressComponent();
    protected boolean parameterOnly = false;
    protected boolean existHomCluster = false;

    public static AbstractDomClustImporter createDomClustImporter(String string) {
        if (string.endsWith("clusttab")) {
            return new DomClustImporter(string);
        }
        return new DomClustListImporter(string);
    }

    public static AbstractDomClustImporter createDomClustImporter(String string, String string2) {
        if (string2.equals("table")) {
            return new DomClustImporter(string);
        }
        return new DomClustListImporter(string);
    }

    public void setProgressImpl(ProgressImpl progressImpl) {
        this.progressImpl = progressImpl;
    }

    protected boolean setParameter(String string) {
        if (!ServerStatus.isParameter(string)) {
            return false;
        }
        if (ServerStatus.isFormatVer(string)) {
            this.formatVersion = ServerStatus.getFormatVer(string);
        } else if (ServerStatus.isNClusters(string)) {
            this.nClusters = ServerStatus.getNClusters(string);
        } else if (ServerStatus.isDomClustColumn(string)) {
            this.columnNameList.add(ServerStatus.getDomClustColumn(string));
        } else if (ServerStatus.isClusterId(string)) {
            this.domClustId = ServerStatus.getClusterId(string);
        } else if (ServerStatus.isClusterViewId(string)) {
            this.clusterViewId = ServerStatus.getClusterViewId(string);
        } else if (ServerStatus.isExecServer(string)) {
            this.execServer = ServerStatus.getExecServer(string);
        } else if (ServerStatus.isExecPort(string)) {
            this.execPort = ServerStatus.getExecPort(string);
        } else if (ServerStatus.isOrigExecServer(string)) {
            this.origExecServer = ServerStatus.getOrigExecServer(string);
        } else if (ServerStatus.isOrigExecPort(string)) {
            this.origExecPort = ServerStatus.getOrigExecPort(string);
        } else if (ServerStatus.isSpecies(string)) {
            this.speciesOrganismCodeList.addAll(ServerStatus.getSpeciesList(string));
        } else if (ServerStatus.isIngroup(string)) {
            this.ingroupOrganismCodeList.addAll(ServerStatus.getIngroupList(string));
        } else if (ServerStatus.isOutgroup(string)) {
            this.outgroupOrganismCodeList.addAll(ServerStatus.getOutgroupList(string));
        } else if (ServerStatus.isNClusters(string)) {
            this.nClusters = ServerStatus.getNClusters(string);
        } else if (ServerStatus.isForView(string)) {
            this.forView = true;
        } else if (ServerStatus.isQuery(string)) {
            this.domClustConditionString = ServerStatus.getQuery(string);
        }
        return true;
    }

    protected boolean isOutgroup() {
        return !this.outgroupOrganismCodeList.isEmpty();
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public String getClusterViewId() {
        return this.clusterViewId;
    }

    public List getSpeciesOrganismCodeList() {
        return this.speciesOrganismCodeList;
    }

    public List getIngroupOrganismCodeList() {
        return this.ingroupOrganismCodeList;
    }

    public List getOutgroupOrganismCodeList() {
        return this.outgroupOrganismCodeList;
    }

    public Set getOrganismCodeSet() {
        HashSet hashSet = new HashSet(this.getIngroupOrganismCodeList());
        hashSet.addAll(this.getOutgroupOrganismCodeList());
        return hashSet;
    }

    public List getOrganismCodeList() {
        ArrayList arrayList = new ArrayList(this.ingroupOrganismCodeList);
        arrayList.addAll(this.outgroupOrganismCodeList);
        return arrayList;
    }

    public boolean containsOrganism(String string) {
        if (this.ingroupOrganismCodeList.contains(string)) {
            return true;
        }
        return this.outgroupOrganismCodeList.contains(string);
    }

    public List getClusterList() {
        return this.clusterList;
    }

    public int getNClusters() {
        return this.nClusters;
    }

    public boolean isCanceled() {
        return this.progressImpl.isCanceled();
    }

    public boolean isExistCluster() {
        return !this.clusterList.isEmpty();
    }

    public String getDomClustConditionString() {
        return this.domClustConditionString;
    }

    public boolean isForView() {
        return this.forView;
    }

    public void setParameterOnly(boolean bl) {
        this.parameterOnly = bl;
    }

    protected boolean isOutgroupIngroup(boolean bl, String string) {
        return bl && this.containsOutgroup(string);
    }

    protected boolean containsOutgroup(String string) {
        return this.getOutgroupOrganismCodeList().contains(string);
    }

    public boolean isExistHomCluster() {
        return this.existHomCluster;
    }
}

