/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.bean.Const;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.StringTool;
import java.util.HashSet;
import java.util.Set;

public class DomClustCondition
implements Cloneable {
    static final int NO_VALUE = Integer.MIN_VALUE;
    public static final String DEFAULT_CONDITION_NAME = "Default Parameters";
    public static final String LAST_CONDITION_NAME = "<<Last Parameters>>";
    public static final String BASE_CONDITION_NAME = "<<Base Cluster Parameters>>";
    static final String FILEKEY_CONDITION_NAME = "domclust_conditionName";
    static final String FILEKEY_MUTABLE_FLAG = "domclust_mutableFlag";
    static final String FILEKEY_CUTOFF_EVALUE = "domclust_cutoffEvalue";
    static final String FILEKEY_CUTOFF_DP = "domclust_cutoffDp";
    static final String FILEKEY_CUTOFF_PAM = "domclust_cutoffPam";
    static final String FILEKEY_CUTOFF_IDENTITY = "domclust_cutoffIdentity";
    static final String FILEKEY_CUTOFF_INGROUP = "domclust_cutoffIngroup";
    static final String FILEKEY_ALIGN_COVERAGE = "domclust_alignCoverage";
    static final String FILEKEY_ALIGN_COVERAGE_DOMAIN = "domclust_alignCoverageDomain";
    static final String FILEKEY_SCORE_CUTOFF_DOMAIN = "domclust_scoreCutoffForDomain";
    static final String FILEKEY_SIMILARITY_ORTHOLOGY = "domclust_similarityOrthology";
    static final String FILEKEY_BEST_HIT_CRITERION = "domclust_bestHitCriterion";
    static final String FILEKEY_CUTOFF_SCORE_BEST = "domclust_cutoffSocreBest";
    static final String FILEKEY_SCORE_MISSING_RELATIONSHIP = "domclust_scoreMissingRelationship";
    static final String FILEKEY_CLUSTERING_MODE = "domclust_clusteringMode";
    static final String FILEKEY_CUTOFF_PARALOG_TREE_SPLIT = "domclust_cutoffParalogTreeSplit";
    static final String FILEKEY_PHYLOG_ORGANISM = "domclust_phylogOrganism";
    static final String FILEKEY_OVERLAP_MERGING_CLUSTER = "domclust_overlapMergingCluster";
    static final String FILEKEY_COVERAGE_ABSORBING_CLUSTER = "domclust_coverageAbsorbingCluster";
    static final String FILEKEY_USE_DOMCLUST_DUMP = "domclust_use_dump";
    static final String FILEKEY_HORIZWEIGHT = "domclust_horizweight";
    static final String FILEKEY_OTHER_OPTIONS = "other_options";
    static final String ITEM_SIMILARITY_ORTHOLOGY_SOCRE = "score";
    static final String ITEM_SIMILARITY_ORTHOLOGY_PAM = "pam";
    static final String ITEM_SIMILARITY_ORTHOLOGY_IDENTITY = "identity";
    static final String ITEM_BEST_HIT_CRITERION_NONE = "none";
    static final String ITEM_BEST_HIT_CRITERION_BIDIREC = "bidirec";
    static final String ITEM_BEST_HIT_CRITERION_UNIDIREC = "unidirec";
    static final String ITEM_CLUSTERING_MODE_COMBINED = "combined";
    static final String ITEM_CLUSTERING_MODE_ORTHOLOGY = "orthology";
    static final String ITEM_CLUSTERING_MODE_HOMOLOGY = "homology";
    static final String ITEM_PHYLOG_ORGANISM_NONE = "none";
    static final String ITEM_PHYLOG_ORGANISM_SPICIES = "species";
    static final String ITEM_PHYLOG_ORGANISM_GENUS = "genus";
    static final String ITEM_PHYLOG_ORGANISM_FAMILY = "family";
    static final String ITEM_PHYLOG_ORGANISM_ORDER = "order";
    private static final double DEFAULT_CUTOFF_EVALUE = 0.001;
    private static final double DEFAULT_CUTOFF_DP = 60.0;
    private static final double DEFAULT_CUTOFF_PAM = -2.147483648E9;
    private static final double DEFAULT_CUTOFF_IDENTITY = -2.147483648E9;
    private static final double DEFAULT_CUTOFF_INGROUP = -2.147483648E9;
    private static final double DEFAULT_ALIGN_COVERAGE = -2.147483648E9;
    private static final double DEFAULT_ALIGN_COVERAGE_DOMAIN = 0.6;
    private static final double DEFAULT_SCORE_CUTOFF_DOMAIN = 80.0;
    private static final String DEFAULT_SIMILARITY_ORTHOLOGY = "score";
    private static final String DEFAULT_BEST_HIT_CRITERION = "none";
    private static final double DEFAULT_CUTOFF_SCORE_BEST = -2.147483648E9;
    private static final double DEFAULT_SCORE_MiSSING_RELATIONSHIP = -2.147483648E9;
    private static final String DEFAULT_CLUSTERING_MODE = "combined";
    private static final double DEFAULT_CUTOFF_PARALOG_TREE_SPLIT = 0.5;
    private static final String DEFAULT_PHYLOG_ORGANISM = "none";
    private static final double DEFAULT_OVERLAP_MERGING_CLUSTER = 0.8;
    private static final double DEFAULT_COVERAGE_ABSORBING_CLUSTER = 0.95;
    private static final boolean DEFAULT_USE_DUMP = true;
    private static final double DEFAULT_HORIZWEIGHT = 0.0;
    private static final boolean DEFAULT_NO_EXEC = false;
    private String domClustName;
    private Set ingroupOrganismCodeSet = new HashSet();
    private Set outgroupOrganismCodeSet = new HashSet();
    private double cutoffEvalue = 0.001;
    private double cutoffDp = 60.0;
    private double cutoffPam = -2.147483648E9;
    private double cutoffIdentity = -2.147483648E9;
    private double cutoffIngroup = -2.147483648E9;
    private double alignCoverage = -2.147483648E9;
    private double alignCoverageDomain = 0.6;
    private double scoreCutoffForDomain = 80.0;
    private String similarityOrthology = "score";
    private String bestHitCriterion = "none";
    private double cutoffSocreBest = -2.147483648E9;
    private double scoreMissingRelationship = -2.147483648E9;
    private String clusteringMode = "combined";
    private double cutoffParalogTreeSplit = 0.5;
    private String phylogOrganism = "none";
    private double overlapMergingCluster = 0.8;
    private double coverageAbsorbingCluster = 0.95;
    private boolean useDump = true;
    private double horizweight = 0.0;
    private String otherOptions = "";
    private boolean noexec = false;
    private Set taxMapOrganismCodeSet = new HashSet();
    private String conditionName;
    private boolean mutable = true;
    private String filename;
    private String domClustId;
    private String baseDomClustId;
    private String domClustViewId;

    public String getDomClustName() {
        return this.domClustName;
    }

    public void setDomClustName(String string) {
        this.domClustName = string;
    }

    public String getConditionName() {
        return this.conditionName;
    }

    public void setConditionName(String string) {
        this.conditionName = string;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean bl) {
        this.mutable = bl;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public Set getIngroupOrganismCodeSet() {
        return this.ingroupOrganismCodeSet;
    }

    public void setIngroupOrganismCodeSet(Set set) {
        this.ingroupOrganismCodeSet = set;
    }

    public Set getOutgroupOrganismCodeSet() {
        return this.outgroupOrganismCodeSet;
    }

    public void setOutgroupOrganismCodeSet(Set set) {
        this.outgroupOrganismCodeSet = set;
    }

    public boolean isExistOutgroup() {
        return this.outgroupOrganismCodeSet != null && this.outgroupOrganismCodeSet.size() > 0;
    }

    public Set getOrganismCodeSet() {
        HashSet hashSet = new HashSet(this.getIngroupOrganismCodeSet());
        hashSet.addAll(this.getOutgroupOrganismCodeSet());
        return hashSet;
    }

    public double getCutoffEvalue() {
        return this.cutoffEvalue;
    }

    public void setCutoffEvalue(double d) {
        this.cutoffEvalue = d;
    }

    public double getCutoffDp() {
        return this.cutoffDp;
    }

    public void setCutoffDp(double d) {
        this.cutoffDp = d;
    }

    public double getCutoffPam() {
        return this.cutoffPam;
    }

    public void setCutoffPam(double d) {
        this.cutoffPam = d;
    }

    public double getCutoffIdentity() {
        return this.cutoffIdentity;
    }

    public void setCutoffIdentity(double d) {
        this.cutoffIdentity = d;
    }

    public double getCutoffIngroup() {
        return this.cutoffIngroup;
    }

    public void setCutoffIngroup(double d) {
        this.cutoffIngroup = d;
    }

    public double getAlignCoverage() {
        return this.alignCoverage;
    }

    public void setAlignCoverage(double d) {
        this.alignCoverage = d;
    }

    public double getAlignCoverageDomain() {
        return this.alignCoverageDomain;
    }

    public void setAlignCoverageDomain(double d) {
        this.alignCoverageDomain = d;
    }

    public double getScoreCutoffForDomain() {
        return this.scoreCutoffForDomain;
    }

    public void setScoreCutoffForDomain(double d) {
        this.scoreCutoffForDomain = d;
    }

    public String getSimilarityOrthology() {
        return this.similarityOrthology;
    }

    public boolean isSimilarityOrthologyScore() {
        return this.getSimilarityOrthology().equals("score");
    }

    public boolean isSimilarityOrthologyPam() {
        return this.getSimilarityOrthology().equals(ITEM_SIMILARITY_ORTHOLOGY_PAM);
    }

    public boolean isSimilarytiOrthologyIdentity() {
        return this.getSimilarityOrthology().equals(ITEM_SIMILARITY_ORTHOLOGY_IDENTITY);
    }

    public void setSimilarityOrthology(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.similarityOrthology = string;
    }

    public String getBestHitCriterion() {
        return this.bestHitCriterion;
    }

    public boolean isBestHitCriterionNone() {
        return DomClustCondition.isBestHitCriterionNone(this.getBestHitCriterion());
    }

    public boolean isBestHitCriterionBidirec() {
        return DomClustCondition.isBestHitCriterionBidirec(this.getBestHitCriterion());
    }

    public boolean isBestHitCriterionUnidirec() {
        return DomClustCondition.isBestHitCriterionUnidirec(this.getBestHitCriterion());
    }

    public static boolean isBestHitCriterionNone(String string) {
        return string.equals("none");
    }

    static boolean isBestHitCriterionBidirec(String string) {
        return string.equals(ITEM_BEST_HIT_CRITERION_BIDIREC);
    }

    static boolean isBestHitCriterionUnidirec(String string) {
        return string.equals(ITEM_BEST_HIT_CRITERION_UNIDIREC);
    }

    void setBestHitCriterion(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.bestHitCriterion = string;
    }

    public double getCutoffSocreBest() {
        return this.cutoffSocreBest;
    }

    public void setCutoffSocreBest(double d) {
        this.cutoffSocreBest = d;
    }

    public double getScoreMissingRelationship() {
        return this.scoreMissingRelationship;
    }

    public void setScoreMissingRelationship(double d) {
        this.scoreMissingRelationship = d;
    }

    public String getClusteringMode() {
        return this.clusteringMode;
    }

    public boolean isClusteringModeCombined() {
        return this.getClusteringMode().equals("combined");
    }

    public boolean isClusteringModeOrthology() {
        return this.getClusteringMode().equals(ITEM_CLUSTERING_MODE_ORTHOLOGY);
    }

    public boolean isClusteringModeHomology() {
        return this.getClusteringMode().equals(ITEM_CLUSTERING_MODE_HOMOLOGY);
    }

    public void setClusteringMode(String string) {
        if (StringTool.isNull(string)) {
            return;
        }
        this.clusteringMode = string;
    }

    public double getCutoffParalogTreeSplit() {
        return this.cutoffParalogTreeSplit;
    }

    public void setCutoffParalogTreeSplit(double d) {
        this.cutoffParalogTreeSplit = d;
    }

    public String getPhylogOrganism() {
        return this.phylogOrganism;
    }

    public void setPhylogOrganism(String string) {
        this.phylogOrganism = string;
    }

    public double getOverlapMergingCluster() {
        return this.overlapMergingCluster;
    }

    public void setOverlapMergingCluster(double d) {
        this.overlapMergingCluster = d;
    }

    public double getCoverageAbsorbingCluster() {
        return this.coverageAbsorbingCluster;
    }

    public void setCoverageAbsorbingCluster(double d) {
        this.coverageAbsorbingCluster = d;
    }

    public boolean isUseDump() {
        return this.useDump;
    }

    public void setUseDump(boolean bl) {
        this.useDump = bl;
    }

    public double getHorizweight() {
        return this.horizweight;
    }

    public void setHorizweight(double d) {
        this.horizweight = d;
    }

    public String getOtherOptions() {
        return this.otherOptions;
    }

    public void setOtherOptions(String string) {
        this.otherOptions = string;
    }

    public Set getTaxMapOrganismCodeSet() {
        return this.taxMapOrganismCodeSet;
    }

    public void setTaxMapOrganismCodeSet(Set set) {
        this.taxMapOrganismCodeSet = set;
    }

    public boolean isExistTaxMapOrganismCode() {
        return !CollectionUtil.isNull(this.getTaxMapOrganismCodeSet());
    }

    public boolean isNoexec() {
        return this.noexec;
    }

    public void setNoexec(boolean bl) {
        this.noexec = bl;
    }

    public static boolean isNoValue(double d) {
        return new Double(d).equals(new Double(-2.147483648E9));
    }

    public static boolean isNoValue(int n) {
        return new Double(n).equals(new Double(-2.147483648E9));
    }

    public static boolean isNoValue(String string) {
        return StringTool.isNull(string);
    }

    public boolean isSaved() {
        return !StringTool.isNull(this.getFilename());
    }

    public static DomClustCondition createNewLastCondition() {
        DomClustCondition domClustCondition = new DomClustCondition();
        domClustCondition.setConditionName(LAST_CONDITION_NAME);
        domClustCondition.setMutable(false);
        domClustCondition.setFilename(DomClustCondition.getLastConditionFilepath());
        return domClustCondition;
    }

    public static String getLastConditionFilepath() {
        return Const.USER_DOMCLUST_CONDITION_DIR + "domclust_condition" + "_last";
    }

    public boolean isLastCondition() {
        return DomClustCondition.isLastCondition(this);
    }

    public static boolean isLastCondition(DomClustCondition domClustCondition) {
        return domClustCondition != null && !StringTool.isNull(domClustCondition.getConditionName()) && domClustCondition.getConditionName().equals(LAST_CONDITION_NAME);
    }

    public void setDomClustViewId(String string) {
        this.domClustViewId = string;
    }

    public String getDomClustViewId() {
        return this.domClustViewId;
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public String getBaseDomClustId() {
        return this.baseDomClustId;
    }

    public void setBaseDomClustId(String string) {
        this.baseDomClustId = string;
    }

    public boolean isDefault() {
        return this.getConditionName().equals(DEFAULT_CONDITION_NAME);
    }

    public void clearParameter() {
        this.setCutoffEvalue(-2.147483648E9);
        this.setCutoffDp(-2.147483648E9);
        this.setCutoffPam(-2.147483648E9);
        this.setCutoffIdentity(-2.147483648E9);
        this.setCutoffIngroup(-2.147483648E9);
        this.setAlignCoverage(-2.147483648E9);
        this.setAlignCoverageDomain(-2.147483648E9);
        this.setScoreCutoffForDomain(-2.147483648E9);
        this.setCoverageAbsorbingCluster(-2.147483648E9);
        this.setCutoffParalogTreeSplit(-2.147483648E9);
        this.setHorizweight(-2.147483648E9);
    }

    protected Object clone() {
        try {
            DomClustCondition domClustCondition = (DomClustCondition)super.clone();
            domClustCondition.setConditionName(null);
            domClustCondition.setFilename(null);
            return domClustCondition;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

