/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.access.AbstractImporter;
import cgdp.recog.auth.AuthFacade;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterTblCreater;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustAnalysis;
import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.domclust.DomClustExecuter;
import cgdp.recog.domclust.DomClustFileUtil;
import cgdp.recog.domclust.DomClustKeyGenerator;
import cgdp.recog.domclust.DomClustPropertyDownloader;
import cgdp.recog.domclust.DomClustPropertyParser;
import cgdp.recog.info.InfoUtil;
import cgdp.recog.info.cluster.ClusterInfoDownloadExecuter;
import cgdp.recog.info.cluster.ClusterInfoTitleListDownloader;
import cgdp.recog.info.gene.GeneInfoDownloadExecuter;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.project.ServerAnalysis;
import cgdp.recog.set.SetConditionGroup;
import cgdp.recog.set.cluster.ClusterSetDownloadExecuter;
import cgdp.recog.set.cluster.ClusterSetFacade;
import cgdp.recog.set.gene.GeneSet;
import cgdp.recog.set.gene.GeneSetDownloadExecuter;
import cgdp.recog.system.property.ApplicationPropertyConf;
import cgdp.recog.system.property.ApplicationPropertyFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.DateUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.ProgressServerConnection;
import cgdp.recog.util.SimpleServerConnection;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DomClustDownloadExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustDownloadExecuter.class);
    private Component parent;
    private Project project;
    private ServerAnalysis analysis;
    private boolean viewParameters = false;
    private Set unableDownloadGeneInfoTitleSet = new HashSet();
    private Set unableDownloadClusterInfoTitleSet = new HashSet();
    private Set unableDownloadGeneSetSet = new HashSet();
    private Set unableDownloadClusterSetSet = new HashSet();

    public DomClustDownloadExecuter(Component component, Project project, DomClustAnalysis domClustAnalysis, boolean bl) {
        this.parent = component;
        this.project = project;
        this.analysis = domClustAnalysis;
        this.viewParameters = bl;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        progressImpl.setTotal(9);
        try {
            Object object;
            Object object2;
            File file = DomClustFileUtil.findDomClustFile(this.analysis.getDomClustId(), this.project);
            if (file == null) {
                object2 = this.createDomClustCondition();
                object = new DomClustExecuter((DomClustCondition)object2, (ProgressImpl)new DummyProgressComponent(), this.createDomClustQuery());
                ((DomClustExecuter)object).setProject(this.project);
                ((ProgressServerConnection)object).execute();
                file = new File(((DomClustExecuter)object).getFilepath());
            }
            progressImpl.increment();
            if (this.viewParameters) {
                object2 = AbstractDomClustImporter.createDomClustImporter(file.getAbsolutePath());
                ((AbstractImporter)object2).execute();
                progressImpl.increment();
                object = ((AbstractDomClustImporter)object2).getOrganismCodeSet();
                String string = ((AbstractDomClustImporter)object2).getClusterViewId();
                ClusterTbl clusterTbl = ClusterTblCreater.createTmpClusterTbl(file.getAbsolutePath(), this.analysis.getDomClustId(), string, ((AbstractDomClustImporter)object2).getIngroupOrganismCodeList(), ((AbstractDomClustImporter)object2).getOutgroupOrganismCodeList(), ((AbstractDomClustImporter)object2).getClusterList(), ((AbstractDomClustImporter)object2).isExistHomCluster());
                progressImpl.increment();
                ApplicationPropertyConf applicationPropertyConf = this.createApplicationPropertyCond();
                applicationPropertyConf.setDomClustViewId(string);
                progressImpl.increment();
                ApplicationPropertyFacade.removeConf(applicationPropertyConf.getConfName());
                String string2 = ApplicationPropertyFacade.getApplicationPropertyDirpath(this.project, applicationPropertyConf);
                FileUtil.createDirectory(string2);
                DomClustPropertyDownloader domClustPropertyDownloader = new DomClustPropertyDownloader(this.project, this.analysis.getDomClustId(), this.analysis.getName());
                domClustPropertyDownloader.execute();
                if (!StringTool.isNull(domClustPropertyDownloader.getContents())) {
                    DomClustPropertyParser domClustPropertyParser = new DomClustPropertyParser(string2, domClustPropertyDownloader.getContents());
                    domClustPropertyParser.execute();
                }
                ApplicationPropertyFacade.registerConf(this.project, applicationPropertyConf);
                progressImpl.increment();
                this.unableDownloadGeneInfoTitleSet = this.downloadGeneInfo(string2, (Collection)object);
                progressImpl.increment();
                this.unableDownloadClusterInfoTitleSet = this.downloadClusterInfo();
                progressImpl.increment();
                this.unableDownloadGeneSetSet = this.downloadGeneSet(string2);
                progressImpl.increment();
                this.unableDownloadClusterSetSet = this.downloadClusterSet(clusterTbl);
                progressImpl.increment();
            }
            progressImpl.setCount(8);
            progressImpl.increment();
        }
        catch (Exception exception) {
            String string = "Fail to download domclust result.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private ApplicationPropertyConf createApplicationPropertyCond() {
        ApplicationPropertyConf applicationPropertyConf = ApplicationPropertyFacade.getConf(this.analysis.getProject(), this.analysis.getName());
        if (applicationPropertyConf != null) {
            applicationPropertyConf.setComment(this.analysis.getDescription());
            applicationPropertyConf.setCreateDate(this.analysis.getCreateOn());
        } else {
            applicationPropertyConf = ApplicationPropertyConf.createServerConf(this.analysis.getName(), this.analysis.getDomClustId(), DomClustKeyGenerator.createKey(), this.analysis.getDescription());
        }
        return applicationPropertyConf;
    }

    private DomClustCondition createDomClustCondition() {
        DomClustCondition domClustCondition = new DomClustCondition();
        domClustCondition.setDomClustName(this.analysis.getName());
        return domClustCondition;
    }

    private Set downloadGeneInfo(String string, Collection collection) {
        Set set = null;
        try {
            set = ApplicationPropertyFacade.getGeneInfoTitleSetFromConfFile(string, new HashSet(collection));
        }
        catch (IOException iOException) {
            String string2 = "Fail to download gene property list.";
            logger.warn(string2, iOException);
            return new HashSet();
        }
        GeneInfoDownloadExecuter geneInfoDownloadExecuter = new GeneInfoDownloadExecuter(this.parent, set, collection, this.analysis.getProject());
        geneInfoDownloadExecuter.setLocation(this.analysis.getProjectName());
        geneInfoDownloadExecuter.setErrorHandling(false);
        geneInfoDownloadExecuter.setOverwriteCheck(true);
        geneInfoDownloadExecuter.execute(new DummyProgressComponent());
        geneInfoDownloadExecuter.done();
        return geneInfoDownloadExecuter.getUnableDownloadInfoTitleSet();
    }

    private Set downloadClusterInfo() {
        Object object;
        List list = null;
        try {
            object = new ClusterInfoTitleListDownloader(this.analysis.getDomClustId(), this.analysis.getProject());
            ((SimpleServerConnection)object).execute();
            list = ((ClusterInfoTitleListDownloader)object).getClusterInfoTitleList();
        }
        catch (Exception exception) {
            String string = "Fail to download cluster property list.";
            logger.warn(string, exception);
            return new HashSet();
        }
        object = new ClusterInfoDownloadExecuter(this.parent, list, this.analysis.getDomClustId(), this.analysis.getProject());
        ((ClusterInfoDownloadExecuter)object).setErrorHandling(false);
        ((ClusterInfoDownloadExecuter)object).setOverwriteCheck(true);
        ((ClusterInfoDownloadExecuter)object).execute(new DummyProgressComponent());
        ((ClusterInfoDownloadExecuter)object).done();
        return ((ClusterInfoDownloadExecuter)object).getUnableDownloadInfoTitleSet();
    }

    private Set downloadGeneSet(String string) {
        SetConditionGroup setConditionGroup = new SetConditionGroup();
        String string2 = SetConditionGroup.getPropertyFilepath(string);
        setConditionGroup.updateProperty(string2);
        Set set = setConditionGroup.getElementSetSet(1);
        if (CollectionUtil.isNull(set)) {
            return new HashSet();
        }
        for (GeneSet geneSet : set) {
            geneSet.setLocation(this.project.getProjectName());
        }
        GeneSetDownloadExecuter geneSetDownloadExecuter = new GeneSetDownloadExecuter(this.parent, set, this.analysis.getProject());
        geneSetDownloadExecuter.setErrorHandling(false);
        geneSetDownloadExecuter.setOverwriteCheck(true);
        geneSetDownloadExecuter.execute(new DummyProgressComponent());
        geneSetDownloadExecuter.done();
        return geneSetDownloadExecuter.getUnableDeleteSetSet();
    }

    private Set downloadClusterSet(ClusterTbl clusterTbl) {
        List list = null;
        try {
            list = ClusterSetFacade.downloadClusterSetList(clusterTbl, this.analysis.getProject());
        }
        catch (Exception exception) {
            String string = "Fail to download cluster set list.";
            logger.warn(string, exception);
            return new HashSet();
        }
        if (CollectionUtil.isNull(list)) {
            return new HashSet();
        }
        ClusterSetDownloadExecuter clusterSetDownloadExecuter = new ClusterSetDownloadExecuter(this.parent, list, clusterTbl, this.analysis.getProject());
        clusterSetDownloadExecuter.setErrorHandling(false);
        clusterSetDownloadExecuter.setOverwriteCheck(true);
        clusterSetDownloadExecuter.execute(new DummyProgressComponent());
        clusterSetDownloadExecuter.done();
        return clusterSetDownloadExecuter.getUnableDeleteSetSet();
    }

    private String createDomClustQuery() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("clusterID=");
        stringBuffer.append(this.analysis.getDomClustId());
        stringBuffer.append("&output_format=list");
        stringBuffer.append("&output_type=complete");
        return stringBuffer.toString();
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!(CollectionUtil.isNull(this.unableDownloadGeneInfoTitleSet) && CollectionUtil.isNull(this.unableDownloadClusterInfoTitleSet) && CollectionUtil.isNull(this.unableDownloadGeneSetSet) && CollectionUtil.isNull(this.unableDownloadClusterSetSet))) {
            HashSet hashSet = new HashSet(this.unableDownloadGeneInfoTitleSet);
            hashSet.addAll(this.unableDownloadClusterInfoTitleSet);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!CollectionUtil.isNull(this.unableDownloadGeneInfoTitleSet) || !CollectionUtil.isNull(this.unableDownloadClusterInfoTitleSet)) {
                arrayList.add("The following property was not able to be downloaded.");
                if (!CollectionUtil.isNull(this.unableDownloadGeneInfoTitleSet)) {
                    arrayList.add("Gene:" + InfoUtil.createInfoTitleNameString(this.unableDownloadGeneInfoTitleSet));
                }
                if (!CollectionUtil.isNull(this.unableDownloadClusterInfoTitleSet)) {
                    arrayList.add("Cluster:" + InfoUtil.createInfoTitleNameString(this.unableDownloadClusterInfoTitleSet));
                }
            }
            if (!CollectionUtil.isNull(this.unableDownloadGeneSetSet) || !CollectionUtil.isNull(this.unableDownloadClusterSetSet)) {
                if (!arrayList.isEmpty()) {
                    arrayList.add("");
                }
                arrayList.add("The following set was not able to be downloaded.");
                if (!CollectionUtil.isNull(this.unableDownloadGeneSetSet)) {
                    arrayList.add("Gene:" + InfoUtil.createInfoTitleNameString(this.unableDownloadGeneInfoTitleSet));
                }
                if (!CollectionUtil.isNull(this.unableDownloadClusterSetSet)) {
                    arrayList.add("Cluster:" + InfoUtil.createInfoTitleNameString(this.unableDownloadClusterInfoTitleSet));
                }
            }
            String[] stringArray = new String[arrayList.size()];
            int n = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string;
                stringArray[n] = string = (String)iterator.next();
                ++n;
            }
            MessageManager.showErrorMessage(this.parent, stringArray);
            return;
        }
        Runnable runnable = this.getAfterRunnable();
        if (runnable != null) {
            runnable.run();
        }
    }

    public static void main(String[] stringArray) {
        AuthFacade.setAuthenticator();
        Project project = ProjectAccesser.getProject("proj_c");
        DomClustAnalysis domClustAnalysis = new DomClustAnalysis();
        domClustAnalysis.setDomClustId("1268880478_21229");
        domClustAnalysis.setName("cluster_20100318_2");
        domClustAnalysis.setProject(project);
        domClustAnalysis.setCreateOn(DateUtil.formatServerDate(new Date()));
        DomClustDownloadExecuter domClustDownloadExecuter = new DomClustDownloadExecuter(null, project, domClustAnalysis, true);
        domClustDownloadExecuter.execute(new DummyProgressComponent());
    }
}

