/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.update.SysInfoDownloader;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DomClustExecuteValidator {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustExecuteValidator.class);
    private static final String MAX_SPECIES_DOMCLUST = "max-species-domclust";
    private static final String MAX_SPECIES_DOMCLUST_BIDIREC = "max-species-domclust-bidirec";
    private static final String MAX_SPECIES_DOMCLUST_UNIDIREC = "max-species-domclust-unidirec";
    private static final String ERRNO_NO_SPEC = "D0102";
    private Frame parent;
    private Map disableBestHitMap = new LinkedHashMap();
    private Set enableBestHitCriterion;

    public DomClustExecuteValidator(Frame frame) {
        this.parent = frame;
    }

    public boolean isEnableDomClust(int n, int n2) {
        if (!this.isExistIngroup(n)) {
            MessageManager.showErrorMessage((Component)this.parent, "Set ingroup organisms from Taxonomy Tree.");
            return false;
        }
        int n3 = n + n2;
        this.enableBestHitCriterion = this.getEnableBestHitCriterion(n3);
        if (this.enableBestHitCriterion == null) {
            MessageManager.showErrorMessage((Component)this.parent, "Fail to access server.");
            return false;
        }
        if (this.enableBestHitCriterion.isEmpty()) {
            String string = this.createBestHitCriterionWarningMessage();
            MessageManager.showErrorMessage((Component)this.parent, string);
            return false;
        }
        if (this.enableBestHitCriterion.size() < 3) {
            String string = this.createBestHitCriterionWarningMessage();
            MessageManager.showWarningMessage((Component)this.parent, string);
            return true;
        }
        return true;
    }

    public Set getEnableBestHitCriterion() {
        return this.enableBestHitCriterion;
    }

    private String createBestHitCriterionWarningMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML><BODY>Because many genomes are specified, The following options of Best Hit Criterion cannot be specified.<BR><BR>");
        for (String string : this.disableBestHitMap.keySet()) {
            int n = (Integer)this.disableBestHitMap.get(string);
            stringBuffer.append("  - " + string + " : " + n + " or less<BR>");
        }
        stringBuffer.append("</BODY></HTML>");
        return stringBuffer.toString();
    }

    private boolean isExistIngroup(int n) {
        return n > 0;
    }

    public Set getEnableBestHitCriterion(int n) {
        Properties properties = this.downloadSysInfo();
        if (properties == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = this.getLimitCountByBestHitCriterion(properties, MAX_SPECIES_DOMCLUST);
        if (n <= n2) {
            hashSet.add("none");
        } else {
            this.disableBestHitMap.put("none", new Integer(n2));
        }
        n2 = this.getLimitCountByBestHitCriterion(properties, MAX_SPECIES_DOMCLUST_BIDIREC);
        if (n <= n2) {
            hashSet.add("bidirec");
        } else {
            this.disableBestHitMap.put("bidirec", new Integer(n2));
        }
        n2 = this.getLimitCountByBestHitCriterion(properties, MAX_SPECIES_DOMCLUST_UNIDIREC);
        if (n <= n2) {
            hashSet.add("unidirec");
        } else {
            this.disableBestHitMap.put("unidirec", new Integer(n2));
        }
        return hashSet;
    }

    private Properties downloadSysInfo() {
        return SysInfoDownloader.downloadSysInfo();
    }

    private int getLimitCountByBestHitCriterion(Properties properties, String string) {
        int n = Integer.parseInt(properties.getProperty(string));
        return n;
    }

    public static boolean isErrorNoSpec(String string) {
        return string.equals(ERRNO_NO_SPEC);
    }
}

