/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustKeyGenerator;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerTbl;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;

public class DomClustFileOpenHelper {
    private MediatorImpl mediator;
    private String domClustFilepath;
    private AbstractDomClustImporter paramDomClustImporter;
    private Component parent;

    public DomClustFileOpenHelper(Component component, MediatorImpl mediatorImpl, String string) throws IOException {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.domClustFilepath = string;
        this.init();
    }

    private void init() throws IOException {
        this.paramDomClustImporter = AbstractDomClustImporter.createDomClustImporter(this.domClustFilepath);
        this.paramDomClustImporter.setParameterOnly(true);
        this.paramDomClustImporter.execute();
    }

    static String getNewDomClustFilepath(String string) {
        File file = new File(string);
        File file2 = new File(ProjectAccesser.getSelectedProject().getDirectoryPath());
        File file3 = new File(file2, file.getName());
        return file3.getAbsolutePath();
    }

    boolean copyDomClustFileToProjectDir() throws Exception {
        File file = new File(this.domClustFilepath);
        File file2 = new File(ProjectAccesser.getSelectedProject().getDirectoryPath());
        if (file2.equals(file.getParentFile())) {
            return true;
        }
        File file3 = new File(DomClustFileOpenHelper.getNewDomClustFilepath(this.domClustFilepath));
        String string = "Overwrite domclust file [" + file.getName() + "]?";
        if (file3.isFile() && !MessageManager.showConfirmMessage(this.parent, string)) {
            return false;
        }
        this.adjustParameter(file, file3);
        return true;
    }

    public boolean changeAccessServer() throws Exception {
        boolean bl;
        boolean bl2;
        String string = this.paramDomClustImporter.getServerUrl();
        AccessServer accessServer = AccessServer.getInstance();
        boolean bl3 = bl2 = !accessServer.equalsServerUrl(string);
        if (bl2 && (bl = MessageManager.showConfirmMessage(this.parent, "Change access server [" + string + "] ?"))) {
            accessServer.setServerUrl(string);
            this.mediator.registerServerUrl(string);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DomClustFileOpenHelper.this.mediator.updateTaxonomyTree();
                }
            });
            return true;
        }
        return false;
    }

    public Set getOrganismCodeSet() {
        return this.paramDomClustImporter.getOrganismCodeSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeServerUrl(String string, String string2, int n) throws IOException {
        Object object;
        String string3 = string + ".tmp";
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            String string4;
            fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            fileOutputStream = new FileOutputStream(string3);
            printWriter = new PrintWriter(fileOutputStream);
            object = "";
            int n2 = 80;
            String string5 = "";
            int n3 = 80;
            while ((string4 = bufferedReader.readLine()) != null) {
                if (ServerStatus.isExecServer(string4)) {
                    object = ServerStatus.getExecServer(string4);
                    continue;
                }
                if (ServerStatus.isExecPort(string4)) {
                    n2 = ServerStatus.getExecPort(string4);
                    continue;
                }
                if (ServerStatus.isOrigExecServer(string4)) {
                    string5 = ServerStatus.getOrigExecServer(string4);
                    continue;
                }
                if (ServerStatus.isOrigExecPort(string4)) {
                    n3 = ServerStatus.getOrigExecPort(string4);
                    continue;
                }
                if (ServerStatus.isStartData(string4)) {
                    printWriter.write(ServerStatus.createExecServer(string2));
                    printWriter.write(FileUtil.LINE_SEPARETOR);
                    printWriter.write(ServerStatus.createExecPort(n));
                    printWriter.write(FileUtil.LINE_SEPARETOR);
                    if (!ServerTbl.equalsServerUrl(string2, n, string5, n3)) {
                        if (!StringTool.isNull(string5)) {
                            printWriter.write(ServerStatus.createOrigExecServer(string5));
                            printWriter.write(FileUtil.LINE_SEPARETOR);
                            printWriter.write(ServerStatus.createOrigExecPort(n3));
                            printWriter.write(FileUtil.LINE_SEPARETOR);
                        } else {
                            printWriter.write(ServerStatus.createOrigExecServer((String)object));
                            printWriter.write(FileUtil.LINE_SEPARETOR);
                            printWriter.write(ServerStatus.createOrigExecPort(n2));
                            printWriter.write(FileUtil.LINE_SEPARETOR);
                        }
                    }
                    printWriter.write(string4);
                    printWriter.write(FileUtil.LINE_SEPARETOR);
                    continue;
                }
                printWriter.write(string4);
                printWriter.write(FileUtil.LINE_SEPARETOR);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        object = new File(string);
        File file = new File(string3);
        ((File)object).delete();
        file.renameTo((File)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustParameter(File file, File file2) throws Exception {
        String string;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.paramDomClustImporter.getIngroupOrganismCodeList();
        if (CollectionUtil.isNull(list)) {
            list = this.paramDomClustImporter.getSpeciesOrganismCodeList();
            arrayList.add(ServerStatus.createIngroup(list));
        }
        if (StringTool.isNull(string2 = this.paramDomClustImporter.getExecServer())) {
            arrayList.add(ServerStatus.createExecServer(ServerTbl.getDefaultServerHostWithoutHttp()));
            arrayList.add(ServerStatus.createExecPort(80));
        }
        if (StringTool.isNull(string = this.paramDomClustImporter.getClusterViewId())) {
            arrayList.add(ServerStatus.createClusterViewIdMessage(DomClustKeyGenerator.createKey()));
        }
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        try {
            String string3;
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            fileOutputStream = new FileOutputStream(file2);
            printWriter = new PrintWriter(fileOutputStream);
            while ((string3 = bufferedReader.readLine()) != null) {
                if (ServerStatus.isStartData(string3)) {
                    for (String string4 : arrayList) {
                        printWriter.write(string4);
                        printWriter.write(FileUtil.LINE_SEPARETOR);
                    }
                }
                printWriter.write(string3);
                printWriter.write(FileUtil.LINE_SEPARETOR);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        if (!CollectionUtil.isNull(arrayList)) {
            this.paramDomClustImporter = AbstractDomClustImporter.createDomClustImporter(file2.getAbsolutePath());
            this.paramDomClustImporter.setParameterOnly(true);
            this.paramDomClustImporter.execute();
        }
    }
}

