/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.DomClustFilenameFilter;
import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DomClustFileUtil {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustFileUtil.class);
    private static final String PREFIX = "cluster_";
    private static final DateFormat DATEFORMATTER = new SimpleDateFormat("yyyyMMdd");

    private DomClustFileUtil() {
    }

    static String getDefaultDomClustName() {
        Set set = DomClustFileUtil.getDomClustFilenameSet();
        String string = "";
        String string2 = "";
        int n = 0;
        Date date = new Date();
        String string3 = DATEFORMATTER.format(date);
        while (true) {
            string = PREFIX + string3;
            if (!string2.equals("")) {
                string = string + "_" + string2;
            }
            if (!set.contains(string)) break;
            string2 = String.valueOf(++n);
        }
        return string;
    }

    private static Set getDomClustFilenameSet() {
        File file = ProjectAccesser.getProjectDir();
        File[] fileArray = file.listFiles(new DomClustFilenameFilter());
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            hashSet.add(FileUtil.removeExtension(fileArray[i].getName()));
        }
        return hashSet;
    }

    public static File findDomClustFile(String string, Project project) {
        File file = new File(project.getDirectoryPath());
        File[] fileArray = file.listFiles(FileFilterFactory.createDomClustIOFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(fileArray[i].getAbsolutePath());
                abstractDomClustImporter.setParameterOnly(true);
                abstractDomClustImporter.execute();
                String string2 = abstractDomClustImporter.getDomClustId();
                if (StringTool.isNull(string2) || !string2.equals(string)) continue;
                return fileArray[i];
            }
            catch (IOException iOException) {
                logger.warn("Fail to load domclust file. " + fileArray[i].getName(), iOException);
            }
        }
        return null;
    }

    public static File findDomClustFileByViewId(String string, Project project) {
        File file = new File(project.getDirectoryPath());
        File[] fileArray = file.listFiles(FileFilterFactory.createDomClustIOFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(fileArray[i].getAbsolutePath());
                abstractDomClustImporter.setParameterOnly(true);
                abstractDomClustImporter.execute();
                String string2 = abstractDomClustImporter.getClusterViewId();
                if (StringTool.isNull(string2) || !string2.equals(string)) continue;
                return fileArray[i];
            }
            catch (IOException iOException) {
                logger.warn("Fail to load domclust file. " + fileArray[i].getName(), iOException);
            }
        }
        return null;
    }

    public static File findDomClustFileByName(String string, Project project) {
        String string2 = string + ".dclst";
        File file = new File(project.getDirectoryPath());
        File[] fileArray = file.listFiles(FileFilterFactory.createDomClustIOFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().equals(string2)) continue;
            return fileArray[i];
        }
        return null;
    }

    public static String getDomClustViewId(String string, Project project) {
        File file = new File(project.getDirectoryPath());
        File[] fileArray = file.listFiles(FileFilterFactory.createDomClustIOFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(fileArray[i].getAbsolutePath());
                abstractDomClustImporter.setParameterOnly(true);
                abstractDomClustImporter.execute();
                String string2 = abstractDomClustImporter.getDomClustId();
                if (!string2.equals(string)) continue;
                return abstractDomClustImporter.getClusterViewId();
            }
            catch (IOException iOException) {
                logger.warn("Fail to load domclust file. " + fileArray[i].getName(), iOException);
            }
        }
        return null;
    }

    public static String createDomClustFilepath(Project project, String string) {
        String string2 = string;
        if (!string.endsWith(".dclst")) {
            string2 = string2 + ".dclst";
        }
        return new File(project.getDirectoryPath(), string2).getAbsolutePath();
    }

    public static String getDomClustId(File file) {
        return DomClustFileUtil.getDomClustId(file.getAbsolutePath());
    }

    public static String getDomClustId(String string) {
        try {
            if (!string.endsWith(".dclst")) {
                logger.fatal("Failed to load domclust file " + string);
                return null;
            }
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(string);
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            return abstractDomClustImporter.getDomClustId();
        }
        catch (IOException iOException) {
            logger.fatal("Failed to load domclust file. " + string, iOException);
            return null;
        }
    }

    public static String getDomClustViewId(File file) {
        return DomClustFileUtil.getDomClustId(file.getAbsolutePath());
    }

    public static String getDomClustViewId(String string) {
        try {
            if (!string.endsWith(".dclst")) {
                logger.fatal("Failed to load domclust file " + string);
                return null;
            }
            AbstractDomClustImporter abstractDomClustImporter = AbstractDomClustImporter.createDomClustImporter(string);
            abstractDomClustImporter.setParameterOnly(true);
            abstractDomClustImporter.execute();
            return abstractDomClustImporter.getClusterViewId();
        }
        catch (IOException iOException) {
            logger.fatal("Failed to load domclust file. " + string, iOException);
            return null;
        }
    }

    public static void deleteFiles(Project project, String string) {
        File file = new File(project.getDirectoryPath());
        File[] fileArray = file.listFiles(FileFilterFactory.createDomClustIOFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                String string2 = DomClustFileUtil.getDomClustId(fileArray[i].getAbsolutePath());
                if (string != null && string.compareTo(string2) != 0) continue;
                logger.warn("Failed to delete a domclust file " + fileArray[i].getAbsolutePath());
                continue;
            }
            catch (Exception exception) {
                logger.fatal("Failed to load domain clustering file " + fileArray[i].getAbsolutePath());
            }
        }
    }
}

