/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.GeneInformation;
import cgdp.recog.domclust.AbstractDomClustImporter;
import cgdp.recog.domclust.CluserInfoAdjuster;
import cgdp.recog.domclust.DomClustListStatus;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.GeneUtil;
import cgdp.recog.util.StringTool;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class DomClustListImporter
extends AbstractDomClustImporter {
    private static final ApplicationLogger logger = new ApplicationLogger(DomClustListImporter.class);
    private static final String SUBCLUTER_TERMINATER = "//";
    private static final String CLUTER_TERMINATER = "////";
    private static final String HOMCLUTER_TERMINATER = "//////";
    private static final String CLUSTER_INFO_DELIMITER = "\t";
    private static final String GENE_INFO_DELIMITER = "\t";
    private static final String ORGANIAM_DELIMITER = ":";
    private static final String KEY_HOMCLUSTER = "HomCluster";
    private static final String KEY_CLUSTER = "Cluster";
    private static final String KEY_SUBCLUSTER = "SubCluster";
    private static final String KEY_OUTGROUP = "OutGroup";
    private static final String KEY_OUTERGROUP = "OuterGroup";
    private boolean startDataFlag = false;

    DomClustListImporter(String string) {
        this.filepath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(this.filepath);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            Cluster cluster = null;
            Cluster cluster2 = null;
            Cluster cluster3 = null;
            ClusterInfo clusterInfo = null;
            ClusterInfo clusterInfo2 = null;
            ClusterInfo clusterInfo3 = null;
            Cluster cluster4 = null;
            ClusterInfo clusterInfo4 = null;
            ArrayList arrayList = new ArrayList();
            ArrayList<Cluster> arrayList2 = new ArrayList<Cluster>();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = true;
            boolean bl5 = true;
            while ((string = bufferedReader.readLine()) != null && !this.progressImpl.isCanceled()) {
                if (this.setParameter(string) && !this.isStartDataFlag()) continue;
                if (this.parameterOnly) {
                    return;
                }
                if (!this.isStartDataFlag()) {
                    this.progressImpl.setTotal((int)((double)this.getNClusters() * 1.2));
                    this.progressImpl.setCount(0);
                    this.setStartDataFlag(true);
                    if (!this.isHomCluster(string) && !this.isSubCluster(string) && !this.isCluster(string)) continue;
                }
                if (this.isHomCluster(string)) {
                    cluster = new Cluster();
                    clusterInfo = new ClusterInfo();
                    clusterInfo.putInfo(ClusterInfoTitle.getHomClusterIdTitle(), this.getHomClusterId(string));
                    cluster.setHomClusterInfo(clusterInfo);
                    cluster4 = cluster;
                    clusterInfo4 = clusterInfo;
                    bl = true;
                    this.existHomCluster = true;
                    continue;
                }
                if (this.isCluster(string)) {
                    cluster2 = new Cluster();
                    clusterInfo2 = new ClusterInfo();
                    clusterInfo2.putInfo(ClusterInfoTitle.getClusterIdTitle(), this.getClusterId(string));
                    cluster2.setClusterInfo(clusterInfo2);
                    cluster4 = cluster2;
                    clusterInfo4 = clusterInfo2;
                    bl4 = false;
                    continue;
                }
                if (this.isSubCluster(string)) {
                    cluster3 = new Cluster();
                    clusterInfo3 = new ClusterInfo();
                    clusterInfo3.putInfo(ClusterInfoTitle.getSubClusterIdTitle(), this.getSubClusterId(string));
                    cluster3.setSubClusterInfo(clusterInfo3);
                    cluster4 = cluster3;
                    clusterInfo4 = clusterInfo3;
                    bl5 = false;
                    continue;
                }
                if (this.isOutgroup(string)) {
                    bl2 = true;
                    bl3 = false;
                    continue;
                }
                if (this.isOutergroup(string)) {
                    bl2 = true;
                    bl3 = true;
                    continue;
                }
                if (bl2 && !string.equals(CLUTER_TERMINATER) && !string.equals(HOMCLUTER_TERMINATER)) {
                    if (cluster3 == null) {
                        cluster3 = new Cluster();
                        cluster3.setSubClusterId(0);
                        bl5 = false;
                    }
                    this.setGeneInformation(cluster2, string, false, bl3);
                    continue;
                }
                if (string.equals(HOMCLUTER_TERMINATER)) {
                    if (!bl5) {
                        this.adjustSubClusterScoreDist(cluster3, clusterInfo3);
                        arrayList2.add(cluster3);
                        bl5 = true;
                    }
                    if (!bl4) {
                        if (this.isOutgroup()) {
                            this.adjustClusterScoreDist(arrayList2, clusterInfo2);
                            this.setClusterInfoToSubCluster(cluster2, arrayList2);
                            arrayList.addAll(arrayList2);
                            arrayList2.clear();
                        } else {
                            this.adjustClusterScoreDist(cluster2, clusterInfo2);
                            arrayList.add(cluster2);
                        }
                        bl4 = true;
                    }
                    this.adjustHomClusterScoreDist(arrayList, clusterInfo);
                    this.setHomClusterInfoToSubCluster(cluster, arrayList);
                    this.clusterList.addAll(arrayList);
                    arrayList.clear();
                    cluster3 = null;
                    bl2 = false;
                    continue;
                }
                if (string.equals(CLUTER_TERMINATER)) {
                    if (!bl5) {
                        this.adjustSubClusterScoreDist(cluster3, clusterInfo3);
                        arrayList2.add(cluster3);
                        bl5 = true;
                    }
                    if (this.isOutgroup()) {
                        this.setClusterInfoToSubCluster(cluster2, arrayList2);
                    }
                    List list = bl ? arrayList : this.clusterList;
                    if (this.isOutgroup()) {
                        this.adjustClusterScoreDist(arrayList2, clusterInfo2);
                        list.addAll(arrayList2);
                        arrayList2.clear();
                    } else {
                        this.adjustClusterScoreDist(cluster2, clusterInfo2);
                        list.add(cluster2);
                    }
                    cluster3 = null;
                    bl4 = true;
                    bl2 = false;
                    this.progressImpl.increment();
                    continue;
                }
                if (string.equals(SUBCLUTER_TERMINATER)) {
                    this.adjustSubClusterScoreDist(cluster3, clusterInfo3);
                    arrayList2.add(cluster3);
                    bl5 = true;
                    bl2 = false;
                    continue;
                }
                if (this.setClusterParameter(clusterInfo4, string)) continue;
                this.setGeneInformation(cluster4, string, true, false);
            }
            this.progressImpl.increment();
            CluserInfoAdjuster.addDomainInfo(this.clusterList);
            this.progressImpl.setCount((int)((double)this.nClusters * 1.2) - 1);
            this.progressImpl.increment();
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void adjustSubClusterScoreDist(Cluster cluster, ClusterInfo clusterInfo) {
        if (cluster.getGeneCount() <= 1) {
            clusterInfo.removeInfo(ClusterInfoFacade.getInfoTitle("SCScore"));
            clusterInfo.removeInfo(ClusterInfoFacade.getInfoTitle("SCDist"));
        }
    }

    private void adjustClusterScoreDist(Cluster cluster, ClusterInfo clusterInfo) {
        if (cluster.getGeneCount() <= 1) {
            clusterInfo.removeInfo(ClusterInfoFacade.getInfoTitle("CScore"));
            clusterInfo.removeInfo(ClusterInfoFacade.getInfoTitle("CDist"));
        }
    }

    private void adjustClusterScoreDist(List list, ClusterInfo clusterInfo) {
        if (list.size() == 1) {
            Cluster cluster = (Cluster)list.get(0);
            this.adjustClusterScoreDist(cluster, clusterInfo);
        }
    }

    private void adjustHomClusterScoreDist(List list, ClusterInfo clusterInfo) {
        Cluster cluster;
        if (!CollectionUtil.isNull(list) && list.size() == 1 && (cluster = (Cluster)list.get(0)).getGeneCount() <= 1) {
            clusterInfo.removeInfo(ClusterInfoFacade.getInfoTitle("HCScore"));
            clusterInfo.removeInfo(ClusterInfoFacade.getInfoTitle("HCDist"));
        }
    }

    private void setHomClusterInfoToSubCluster(Cluster cluster, List list) {
        for (Cluster cluster2 : list) {
            cluster2.setHomClusterInfo(cluster.getHomClusterInfo());
        }
    }

    private void setClusterInfoToSubCluster(Cluster cluster, List list) {
        for (Cluster cluster2 : list) {
            cluster2.setClusterInfo(cluster.getClusterInfo());
            for (String string : this.getOutgroupOrganismCodeList()) {
                List list2 = cluster.getGeneInformationList(string);
                if (list2 == null) continue;
                for (GeneInformation geneInformation : list2) {
                    cluster2.addGeneInfo(string, geneInformation);
                }
            }
        }
    }

    private boolean isStartDataFlag() {
        return this.startDataFlag;
    }

    private void setStartDataFlag(boolean bl) {
        this.startDataFlag = bl;
    }

    private boolean isHomCluster(String string) {
        return string.startsWith(KEY_HOMCLUSTER);
    }

    private Object getHomClusterId(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoTitle.getHomClusterIdTitle();
        String string2 = string.substring(KEY_HOMCLUSTER.length(), string.length()).trim();
        return clusterInfoTitle.getValueAsType(string2);
    }

    private boolean isCluster(String string) {
        return string.startsWith(KEY_CLUSTER);
    }

    private Object getClusterId(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoTitle.getClusterIdTitle();
        String string2 = string.substring(KEY_CLUSTER.length(), string.length()).trim();
        return clusterInfoTitle.getValueAsType(string2);
    }

    private boolean isSubCluster(String string) {
        return string.startsWith(KEY_SUBCLUSTER);
    }

    private Object getSubClusterId(String string) {
        ClusterInfoTitle clusterInfoTitle = ClusterInfoTitle.getSubClusterIdTitle();
        String string2 = string.substring(KEY_SUBCLUSTER.length(), string.length()).trim();
        return clusterInfoTitle.getValueAsType(string2);
    }

    private boolean isOutgroup(String string) {
        return string.startsWith(KEY_OUTGROUP);
    }

    private boolean isOutergroup(String string) {
        return string.startsWith(KEY_OUTERGROUP);
    }

    private boolean setClusterParameter(ClusterInfo clusterInfo, String string) {
        Object object;
        if (!DomClustListStatus.isParameter(string)) {
            return false;
        }
        Vector vector = StringTool.splitString(string, "\t");
        String string2 = ((String)vector.get(0)).substring(1);
        ClusterInfoTitle clusterInfoTitle = ClusterInfoFacade.getInfoTitle(string2);
        if (clusterInfoTitle == null) {
            return true;
        }
        String string3 = null;
        if (vector.size() >= 2) {
            object = new StringBuffer();
            int n = 0;
            for (int i = 1; i < vector.size(); ++i) {
                String string4 = (String)vector.get(i);
                ((StringBuffer)object).append(string4);
                if (i != vector.size() - 1) {
                    ((StringBuffer)object).append("\t");
                }
                ++n;
            }
            string3 = ((StringBuffer)object).toString();
        }
        object = clusterInfoTitle.getValueAsType(string3);
        clusterInfo.putInfo(clusterInfoTitle, object);
        return true;
    }

    private void setGeneInformation(Cluster cluster, String string, boolean bl, boolean bl2) {
        boolean bl3;
        Vector vector = StringTool.splitString(string, "\t");
        Vector vector2 = StringTool.splitString((String)vector.get(0), ORGANIAM_DELIMITER);
        String string2 = (String)vector2.get(0);
        String string3 = (String)vector2.get(1);
        int n = Integer.parseInt((String)vector.get(1));
        int n2 = GeneUtil.convertDNAFrom(Integer.parseInt((String)vector.get(2)));
        int n3 = GeneUtil.convertDNATo(Integer.parseInt((String)vector.get(3)));
        boolean bl4 = bl3 = bl && this.containsOutgroup(string2);
        if (vector.size() >= 5) {
            boolean bl5 = bl2 = Integer.parseInt((String)vector.get(4)) != 0;
            if (bl2) {
                System.out.println("outgroupFlag=" + bl2 + " " + string2 + ORGANIAM_DELIMITER + string3);
            }
        }
        cluster.addGeneInfo(string2, string3, n, n2, n3, bl3, bl2);
    }
}

