/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.domclust;

import cgdp.recog.domclust.DomClustCondition;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class DomClustQuery {
    private static final String NAME_CUTOFF_EVALUE = "Cutoff BLAST E-value";
    private static final String NAME_CUTOFF_DP = "Cutoff DP score";
    private static final String NAME_CUTOFF_PAM = "Cutoff PAM distance";
    private static final String NAME_CUTOFF_IDENTITY = "Cutoff percent identity";
    private static final String NAME_CUTOFF_INGROUP = "Cutoff DP score / PAM distance / percent identity for ingroup";
    private static final String NAME_ALIGN_COVERAGE = "Alignment coverage";
    private static final String NAME_ALIGN_COVERAGE_DOMAIN = "Alignment coverage for domain splitting";
    private static final String NAME_SCORE_CUTOFF_DOMAIN = "Score cutoff for domain splitting";
    private static final String NAME_SIMILARITY_ORTHOLOGY = "Similarity measure for orthology";
    private static final String NAME_BEST_HIT_CRITERION = "Best hit criterion";
    private static final String NAME_CUTOFF_SCORE_BEST = "Cutoff ratio of the score against the best";
    private static final String NAME_SCORE_MISSING_RELATIONSHIP = "Score for missing relationships";
    private static final String NAME_CLUSTERING_MODE = "Clustering Mode";
    private static final String NAME_CUTOFF_PARALOG_TREE_SPLIT = "Cutoff ratio of paralogs for tree splitting";
    private static final String NAME_PHYLOG_ORGANISM = "Phylogenetically related organisms";
    private static final String NAME_OVERLAP_MERGING_CLUSTER = "Overlap ratio (radj1) for merging adjacent clusters";
    private static final String NAME_COVERAGE_ABSORBING_CLUSTER = "Coverage ratio (radj2) for absorbing adjacent small clusters";
    private static final String NAME_USE_DUMP = "Use dump";
    private static final String NAME_HORIZWEIGHT = "Horizweight";
    private static final String KEY_INGROUP = "ingroup";
    private static final String KEY_OUTGROUP = "outgroup";
    private static final String KEY_CUTOFF_EVALUE = "eval";
    private static final String KEY_CUTOFF_DP = "score";
    private static final String KEY_CUTOFF_PAM = "pam";
    private static final String KEY_CUTOFF_IDENTITY = "ident";
    private static final String KEY_CUTOFF_INGROUP = "cutoff_ingroup";
    private static final String KEY_ALIGN_COVERAGE = "coverage";
    private static final String KEY_ALIGN_COVERAGE_DOMAIN = "coverage2";
    private static final String KEY_SCORE_CUTOFF_DOMAIN = "cutoff2";
    private static final String KEY_SIMILARITY_ORTHOLOGY = "sim_measure";
    private static final String KEY_BEST_HIT_CRITERION = "besthit";
    private static final String KEY_CUTOFF_SCORE_BEST = "ratiocut";
    private static final String KEY_SCORE_MISSING_RELATIONSHIP = "missdist";
    private static final String KEY_CLUSTERING_MODE = "clustmode";
    private static final String KEY_CUTOFF_PARALOG_TREE_SPLIT = "phylocut";
    private static final String KEY_PHYLOG_ORGANISM = "taxonlevel";
    private static final String KEY_OVERLAP_MERGING_CLUSTER = "adjovlp";
    private static final String KEY_COVERAGE_ABSORBING_CLUSTER = "adjincl";
    private static final String KEY_USE_DUMP = "USE_DOMCLUST_DUMP";
    private static final String KEY_OUT_FORMAT = "output_format";
    private static final String KEY_HORIZWEIGHT = "horizweight";
    private static final String KEY_TAXMAPSPEC = "taxMapSpec";
    private static final String KEY_NO_EXEC = "NO_EXEC";
    private static final String KEY_CLUSTID = "clusterID";
    private static final String KEY_OTHER_OPTIONS = "otherOptions";
    private static final String KEY_BASECLUSTID = "baseClusterID";

    public static String getQueryOption(DomClustCondition domClustCondition) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append("ingroup=");
        for (String string : domClustCondition.getIngroupOrganismCodeSet()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            ++n;
        }
        if (domClustCondition.isExistOutgroup()) {
            stringBuffer.append("&outgroup=");
            n = 0;
            for (String string : domClustCondition.getOutgroupOrganismCodeSet()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string);
                ++n;
            }
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffEvalue())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_CUTOFF_EVALUE, domClustCondition.getCutoffEvalue()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffDp())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_CUTOFF_DP, domClustCondition.getCutoffDp()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffPam())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_CUTOFF_PAM, domClustCondition.getCutoffPam()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffIdentity())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_CUTOFF_IDENTITY, domClustCondition.getCutoffIdentity()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffIngroup())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_CUTOFF_INGROUP, domClustCondition.getCutoffIngroup()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getAlignCoverage())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_ALIGN_COVERAGE, domClustCondition.getAlignCoverage()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getAlignCoverageDomain())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_ALIGN_COVERAGE_DOMAIN, domClustCondition.getAlignCoverageDomain()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getScoreCutoffForDomain())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_SCORE_CUTOFF_DOMAIN, domClustCondition.getScoreCutoffForDomain()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getSimilarityOrthology())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_SIMILARITY_ORTHOLOGY, domClustCondition.getSimilarityOrthology()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getBestHitCriterion())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_BEST_HIT_CRITERION, domClustCondition.getBestHitCriterion()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffSocreBest())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_CUTOFF_SCORE_BEST, domClustCondition.getCutoffSocreBest()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getScoreMissingRelationship())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_SCORE_MISSING_RELATIONSHIP, domClustCondition.getScoreMissingRelationship()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getClusteringMode())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_CLUSTERING_MODE, domClustCondition.getClusteringMode()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffParalogTreeSplit())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_CUTOFF_PARALOG_TREE_SPLIT, domClustCondition.getCutoffParalogTreeSplit()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getPhylogOrganism())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_PHYLOG_ORGANISM, domClustCondition.getPhylogOrganism()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getOverlapMergingCluster())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_OVERLAP_MERGING_CLUSTER, domClustCondition.getOverlapMergingCluster()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCoverageAbsorbingCluster())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_COVERAGE_ABSORBING_CLUSTER, domClustCondition.getCoverageAbsorbingCluster()));
        }
        stringBuffer.append(DomClustQuery.getQueryParameter(KEY_USE_DUMP, DomClustQuery.convertUseDump(domClustCondition.isUseDump())));
        if (!DomClustCondition.isNoValue(domClustCondition.getHorizweight())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_HORIZWEIGHT, domClustCondition.getHorizweight()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getOtherOptions())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_OTHER_OPTIONS, domClustCondition.getOtherOptions()));
        }
        if (domClustCondition.isExistTaxMapOrganismCode()) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_TAXMAPSPEC, StringTool.conbineStrList(domClustCondition.getTaxMapOrganismCodeSet(), ",")));
        }
        if (domClustCondition.isNoexec()) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_NO_EXEC, 1));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getBaseDomClustId())) {
            stringBuffer.append(DomClustQuery.getQueryParameter(KEY_BASECLUSTID, domClustCondition.getBaseDomClustId()));
        }
        stringBuffer.append(DomClustQuery.getQueryParameter(KEY_OUT_FORMAT, "list"));
        stringBuffer.append("&output_type=complete");
        return stringBuffer.toString();
    }

    public static String getTaxMapQueryOption(DomClustCondition domClustCondition) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("clusterID=" + domClustCondition.getDomClustId());
        stringBuffer.append(DomClustQuery.getQueryParameter(KEY_TAXMAPSPEC, StringTool.conbineStrList(domClustCondition.getTaxMapOrganismCodeSet(), ",")));
        stringBuffer.append(DomClustQuery.getQueryParameter(KEY_USE_DUMP, "1"));
        stringBuffer.append("&GET_STATUS_ONLY=1");
        return stringBuffer.toString();
    }

    private static String getQueryParameter(String string) {
        return "&" + string;
    }

    private static String getQueryParameter(String string, String string2) {
        return "&" + string + "=" + string2;
    }

    private static String getQueryParameter(String string, double d) {
        return "&" + string + "=" + d;
    }

    private static String getQueryParameter(String string, int n) {
        return "&" + string + "=" + n;
    }

    public static boolean isNoValue(String string) {
        return StringTool.isNull(string);
    }

    public static DomClustCondition createDomClustCondition(String string) {
        DomClustCondition domClustCondition = new DomClustCondition();
        domClustCondition.clearParameter();
        Vector vector = StringTool.splitString(string, "&");
        for (String string2 : vector) {
            HashSet hashSet;
            if (DomClustQuery.isMatchParameter(KEY_INGROUP, string2)) {
                String string3 = DomClustQuery.extractValue(KEY_INGROUP, string2);
                hashSet = new HashSet(StringTool.splitString(string3, ","));
                domClustCondition.setIngroupOrganismCodeSet(hashSet);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_OUTGROUP, string2)) {
                String string4 = DomClustQuery.extractValue(KEY_OUTGROUP, string2);
                hashSet = new HashSet(StringTool.splitString(string4, ","));
                domClustCondition.setOutgroupOrganismCodeSet(hashSet);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_CUTOFF_EVALUE, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_CUTOFF_EVALUE, string2);
                domClustCondition.setCutoffEvalue(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_CUTOFF_DP, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_CUTOFF_DP, string2);
                domClustCondition.setCutoffDp(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_CUTOFF_PAM, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_CUTOFF_PAM, string2);
                domClustCondition.setCutoffPam(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_CUTOFF_IDENTITY, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_CUTOFF_IDENTITY, string2);
                domClustCondition.setCutoffIdentity(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_CUTOFF_INGROUP, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_CUTOFF_INGROUP, string2);
                domClustCondition.setCutoffIngroup(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_ALIGN_COVERAGE, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_ALIGN_COVERAGE, string2);
                domClustCondition.setAlignCoverage(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_ALIGN_COVERAGE_DOMAIN, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_ALIGN_COVERAGE_DOMAIN, string2);
                domClustCondition.setAlignCoverageDomain(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_SCORE_CUTOFF_DOMAIN, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_SCORE_CUTOFF_DOMAIN, string2);
                domClustCondition.setScoreCutoffForDomain(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_SIMILARITY_ORTHOLOGY, string2)) {
                String string5 = DomClustQuery.extractValue(KEY_SIMILARITY_ORTHOLOGY, string2);
                domClustCondition.setSimilarityOrthology(string5);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_BEST_HIT_CRITERION, string2)) {
                String string6 = DomClustQuery.extractValue(KEY_BEST_HIT_CRITERION, string2);
                domClustCondition.setBestHitCriterion(string6);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_CUTOFF_SCORE_BEST, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_CUTOFF_SCORE_BEST, string2);
                domClustCondition.setCutoffSocreBest(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_SCORE_MISSING_RELATIONSHIP, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_SCORE_MISSING_RELATIONSHIP, string2);
                domClustCondition.setScoreMissingRelationship(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_CLUSTERING_MODE, string2)) {
                String string7 = DomClustQuery.extractValue(KEY_CLUSTERING_MODE, string2);
                domClustCondition.setClusteringMode(string7);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_CUTOFF_PARALOG_TREE_SPLIT, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_CUTOFF_PARALOG_TREE_SPLIT, string2);
                domClustCondition.setCutoffParalogTreeSplit(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_PHYLOG_ORGANISM, string2)) {
                String string8 = DomClustQuery.extractValue(KEY_PHYLOG_ORGANISM, string2);
                domClustCondition.setPhylogOrganism(string8);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_OVERLAP_MERGING_CLUSTER, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_OVERLAP_MERGING_CLUSTER, string2);
                domClustCondition.setOverlapMergingCluster(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_COVERAGE_ABSORBING_CLUSTER, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_COVERAGE_ABSORBING_CLUSTER, string2);
                domClustCondition.setCoverageAbsorbingCluster(d);
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_USE_DUMP, string2)) {
                int n = (int)DomClustQuery.extractValueDouble(KEY_USE_DUMP, string2);
                domClustCondition.setUseDump(DomClustQuery.convertUseDump(n));
                continue;
            }
            if (DomClustQuery.isMatchParameter(KEY_HORIZWEIGHT, string2)) {
                double d = DomClustQuery.extractValueDouble(KEY_HORIZWEIGHT, string2);
                domClustCondition.setHorizweight(d);
                continue;
            }
            if (!DomClustQuery.isMatchParameter(KEY_OTHER_OPTIONS, string2)) continue;
            String string9 = DomClustQuery.extractValue(KEY_OTHER_OPTIONS, string2);
            domClustCondition.setOtherOptions(string9);
        }
        return domClustCondition;
    }

    private static boolean isMatchParameter(String string, String string2) {
        return ServerStatus.isIncludeString(string2, string + "=");
    }

    private static String extractValue(String string, String string2) {
        return ServerStatus.extractValue(string, string2);
    }

    private static double extractValueDouble(String string, String string2) {
        String string3 = ServerStatus.extractValue(string, string2);
        double d = -2.147483648E9;
        try {
            d = Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    private static boolean convertUseDump(int n) {
        return n == 1;
    }

    private static int convertUseDump(boolean bl) {
        return bl ? 1 : 0;
    }

    public static String createDisplayOptions(String string) {
        DomClustCondition domClustCondition = DomClustQuery.createDomClustCondition(string);
        StringBuffer stringBuffer = new StringBuffer();
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffEvalue())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_CUTOFF_EVALUE, domClustCondition.getCutoffEvalue()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffDp())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_CUTOFF_DP, domClustCondition.getCutoffDp()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffPam())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_CUTOFF_PAM, domClustCondition.getCutoffPam()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffIdentity())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_CUTOFF_IDENTITY, domClustCondition.getCutoffIdentity()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffIdentity())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_CUTOFF_IDENTITY, domClustCondition.getCutoffIdentity()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getAlignCoverage())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_ALIGN_COVERAGE, domClustCondition.getAlignCoverage()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getAlignCoverageDomain())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_ALIGN_COVERAGE_DOMAIN, domClustCondition.getAlignCoverageDomain()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getScoreCutoffForDomain())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_SCORE_CUTOFF_DOMAIN, domClustCondition.getScoreCutoffForDomain()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getSimilarityOrthology())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_SIMILARITY_ORTHOLOGY, domClustCondition.getSimilarityOrthology()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getBestHitCriterion())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_BEST_HIT_CRITERION, domClustCondition.getBestHitCriterion()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffSocreBest())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_CUTOFF_SCORE_BEST, domClustCondition.getCutoffSocreBest()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getScoreMissingRelationship())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_SCORE_MISSING_RELATIONSHIP, domClustCondition.getScoreMissingRelationship()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getClusteringMode())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_CLUSTERING_MODE, domClustCondition.getClusteringMode()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffParalogTreeSplit())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_CUTOFF_PARALOG_TREE_SPLIT, domClustCondition.getCutoffParalogTreeSplit()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getPhylogOrganism())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_PHYLOG_ORGANISM, domClustCondition.getPhylogOrganism()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getOverlapMergingCluster())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_OVERLAP_MERGING_CLUSTER, domClustCondition.getOverlapMergingCluster()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCoverageAbsorbingCluster())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_COVERAGE_ABSORBING_CLUSTER, domClustCondition.getCoverageAbsorbingCluster()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (domClustCondition.isUseDump()) {
            stringBuffer.append(DomClustQuery.getDisplayParameter("Use Dump"));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        if (domClustCondition.getHorizweight() != 0.0 && !DomClustCondition.isNoValue(domClustCondition.getHorizweight())) {
            stringBuffer.append(DomClustQuery.getDisplayParameter(KEY_HORIZWEIGHT, domClustCondition.getHorizweight()));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    public static String createDisplayOptionsGeneric(String string) {
        Vector vector = StringTool.splitString(string, "&");
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : vector) {
            String[] stringArray = string2.split("=", 2);
            stringBuffer.append(DomClustQuery.getDisplayParameter(stringArray[0], stringArray[1]));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    public static Map createDisplayOptionMap(String string) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        DomClustCondition domClustCondition = DomClustQuery.createDomClustCondition(string);
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffEvalue())) {
            linkedHashMap.put(NAME_CUTOFF_EVALUE, new Double(domClustCondition.getCutoffEvalue()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffDp())) {
            linkedHashMap.put(NAME_CUTOFF_DP, new Double(domClustCondition.getCutoffDp()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffPam())) {
            linkedHashMap.put(NAME_CUTOFF_PAM, new Double(domClustCondition.getCutoffPam()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffIdentity())) {
            linkedHashMap.put(NAME_CUTOFF_IDENTITY, new Double(domClustCondition.getCutoffIdentity()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffIngroup())) {
            linkedHashMap.put(NAME_CUTOFF_INGROUP, new Double(domClustCondition.getCutoffIngroup()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getAlignCoverage())) {
            linkedHashMap.put(NAME_ALIGN_COVERAGE, new Double(domClustCondition.getAlignCoverage()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getAlignCoverageDomain())) {
            linkedHashMap.put(NAME_ALIGN_COVERAGE_DOMAIN, new Double(domClustCondition.getAlignCoverageDomain()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getScoreCutoffForDomain())) {
            linkedHashMap.put(NAME_SCORE_CUTOFF_DOMAIN, new Double(domClustCondition.getScoreCutoffForDomain()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getSimilarityOrthology())) {
            linkedHashMap.put(NAME_SIMILARITY_ORTHOLOGY, domClustCondition.getSimilarityOrthology());
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getBestHitCriterion())) {
            linkedHashMap.put(NAME_BEST_HIT_CRITERION, domClustCondition.getBestHitCriterion());
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffSocreBest())) {
            linkedHashMap.put(NAME_CUTOFF_SCORE_BEST, new Double(domClustCondition.getCutoffSocreBest()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getScoreMissingRelationship())) {
            linkedHashMap.put(NAME_SCORE_MISSING_RELATIONSHIP, new Double(domClustCondition.getScoreMissingRelationship()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getClusteringMode())) {
            linkedHashMap.put(NAME_CLUSTERING_MODE, domClustCondition.getClusteringMode());
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCutoffParalogTreeSplit())) {
            linkedHashMap.put(NAME_CUTOFF_PARALOG_TREE_SPLIT, new Double(domClustCondition.getCutoffParalogTreeSplit()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getPhylogOrganism())) {
            linkedHashMap.put(NAME_PHYLOG_ORGANISM, domClustCondition.getPhylogOrganism());
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getOverlapMergingCluster())) {
            linkedHashMap.put(NAME_OVERLAP_MERGING_CLUSTER, new Double(domClustCondition.getOverlapMergingCluster()));
        }
        if (!DomClustCondition.isNoValue(domClustCondition.getCoverageAbsorbingCluster())) {
            linkedHashMap.put(NAME_COVERAGE_ABSORBING_CLUSTER, new Double(domClustCondition.getCoverageAbsorbingCluster()));
        }
        if (domClustCondition.isUseDump()) {
            linkedHashMap.put(NAME_USE_DUMP, new Double(domClustCondition.getCoverageAbsorbingCluster()));
        }
        if (domClustCondition.getHorizweight() != 0.0 && !DomClustCondition.isNoValue(domClustCondition.getHorizweight())) {
            linkedHashMap.put(NAME_HORIZWEIGHT, new Double(domClustCondition.getHorizweight()));
        }
        return linkedHashMap;
    }

    private static String getDisplayParameter(String string, String string2) {
        return " - " + string + " : " + string2;
    }

    private static String getDisplayParameter(String string, double d) {
        return " - " + string + " : " + d;
    }

    private static String getDisplayParameter(String string) {
        return " - " + string;
    }
}

