/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.filter.TaxFilterCondition;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FilterNameDialog
extends AbstractApplyDialog {
    private static final Dimension DIALOG_SIZE = new Dimension(300, 100);
    private static final String TITLE = "Rename Any Filter Condition";
    private MediatorImpl mediator;
    private TaxFilterCondition filterCondition;
    private FocusTextField filterNameTextField;

    public FilterNameDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
    }

    @Override
    protected void init() {
        super.init();
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(DIALOG_SIZE);
        JLabel jLabel = new JLabel("Name :");
        this.filterNameTextField = new FocusTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.filterNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.setLocationRelativeTo(this.getParent());
    }

    public void setFilterCondition(TaxFilterCondition taxFilterCondition) {
        this.filterCondition = taxFilterCondition;
        this.filterNameTextField.setText(taxFilterCondition.getName());
    }

    @Override
    protected boolean check() {
        if (this.filterNameTextField.getText().equals("")) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            this.filterNameTextField.setText(this.filterCondition.getName());
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        this.filterCondition.setName(this.filterNameTextField.getText());
        this.mediator.updateForFilter(false);
        return true;
    }
}

