/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.filter.TaxFilterCondition;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.FocusTextField;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.SliderTextPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FilterThresholdDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Any Threshold";
    private static final int PERCENT_INTERVAL = 20;
    private static final int PERCENT_MIN_VALUE = 0;
    private static final int PERCENT_MAX_VALUE = 100;
    private static String[] taxRankList = new String[]{"genome", "species", "genus", "family", "order"};
    private MediatorImpl mediator;
    private FocusTextField nameTextField;
    private boolean displayNameFlag = false;
    private JRadioButton countRadioButton;
    private JRadioButton percentRadioButton;
    private JCheckBox percentLessCheckBox;
    private JCheckBox percentMoreCheckBox;
    private JCheckBox countLessCheckBox;
    private JCheckBox countMoreCheckBox;
    private SliderTextPanel lessCountSliderTextPanel;
    private SliderTextPanel moreCountSliderTextPanel;
    private SliderTextPanel lessPercentSliderTextPanel;
    private SliderTextPanel morePercentSliderTextPanel;
    private DefaultComboBoxModel countUnitComboBoxModel;
    private JComboBox countUnitComboBox;
    private List filterConditionList;
    private boolean updateMainFlag = true;
    private JCheckBox registerOrganismSetCheckBox;

    public FilterThresholdDialog(Frame frame, MediatorImpl mediatorImpl) {
        this(frame, mediatorImpl, false);
    }

    public FilterThresholdDialog(Frame frame, MediatorImpl mediatorImpl, boolean bl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.displayNameFlag = bl;
        this.createComponent();
    }

    private void createComponent() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        if (this.isDisplayNameFlag()) {
            this.getContentPane().add((Component)this.createNamePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        }
        this.getContentPane().add((Component)this.createConditionPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.createUnitPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        if (this.isDisplayNameFlag()) {
            this.getContentPane().add((Component)this.createOptionPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        }
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private JPanel createNamePanel() {
        JLabel jLabel = new JLabel("Name");
        this.nameTextField = new FocusTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        jPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createConditionPanel() {
        this.countRadioButton = new JRadioButton("Count: ");
        this.countRadioButton.addActionListener(this);
        this.countLessCheckBox = new JCheckBox("# or less");
        this.countMoreCheckBox = new JCheckBox("# or more");
        this.lessCountSliderTextPanel = new SliderTextPanel();
        this.lessCountSliderTextPanel.setPaintLabels(true);
        this.lessCountSliderTextPanel.setSnapToTicks(true);
        this.moreCountSliderTextPanel = new SliderTextPanel();
        this.moreCountSliderTextPanel.setPaintLabels(true);
        this.moreCountSliderTextPanel.setSnapToTicks(true);
        this.percentRadioButton = new JRadioButton("Percent: ");
        this.percentRadioButton.addActionListener(this);
        this.percentLessCheckBox = new JCheckBox("#% or less");
        this.percentMoreCheckBox = new JCheckBox("#% or more");
        this.lessPercentSliderTextPanel = SliderTextPanel.createRatioSliderTextPanel();
        this.morePercentSliderTextPanel = SliderTextPanel.createRatioSliderTextPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.countRadioButton);
        buttonGroup.add(this.percentRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.countRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.countLessCheckBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.countMoreCheckBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.lessCountSliderTextPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.moreCountSliderTextPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.percentRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.percentLessCheckBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.percentMoreCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.lessPercentSliderTextPanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.morePercentSliderTextPanel, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel createUnitPanel() {
        JPanel jPanel = new JPanel();
        this.countUnitComboBoxModel = new DefaultComboBoxModel<String>(taxRankList);
        this.countUnitComboBox = new JComboBox(this.countUnitComboBoxModel);
        JLabel jLabel = new JLabel("Taxonomic Unit:");
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jLabel);
        jPanel.add(this.countUnitComboBox);
        this.countUnitComboBox.addActionListener(this);
        return jPanel;
    }

    private JPanel createOptionPanel() {
        this.registerOrganismSetCheckBox = new JCheckBox("Register as Organism Set");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        jPanel.add(this.registerOrganismSetCheckBox);
        return jPanel;
    }

    private boolean isDisplayNameFlag() {
        return this.displayNameFlag;
    }

    public void setFilterCondition(TaxFilterCondition taxFilterCondition) {
        ArrayList<TaxFilterCondition> arrayList = new ArrayList<TaxFilterCondition>();
        arrayList.add(taxFilterCondition);
        this.setFilterConditionList(arrayList);
    }

    public void setFilterConditionList(List list) {
        this.filterConditionList = list;
        TaxFilterCondition taxFilterCondition = (TaxFilterCondition)list.get(0);
        if (this.isDisplayNameFlag()) {
            this.nameTextField.setText(taxFilterCondition.getName());
        }
        this.countLessCheckBox.setSelected(taxFilterCondition.isLessCount());
        this.countMoreCheckBox.setSelected(taxFilterCondition.isMoreCount());
        this.percentLessCheckBox.setSelected(taxFilterCondition.isLessPercent());
        this.percentMoreCheckBox.setSelected(taxFilterCondition.isMorePercent());
        this.lessCountSliderTextPanel.setValue(taxFilterCondition.getLessThresholdCount());
        this.moreCountSliderTextPanel.setValue(taxFilterCondition.getMoreThresholdCount());
        this.lessPercentSliderTextPanel.setValue((int)(taxFilterCondition.getLessThresholdPercent() * 100.0));
        this.morePercentSliderTextPanel.setValue((int)(taxFilterCondition.getMoreThresholdPercent() * 100.0));
        String string = taxFilterCondition.getTaxUnit();
        if (string == null) {
            string = "genome";
        }
        this.countUnitComboBox.setSelectedItem(string);
        this.updateComponents(taxFilterCondition.isCountFlag());
    }

    public boolean isRegisterOrganismSet() {
        return this.registerOrganismSetCheckBox.isSelected();
    }

    private void updateComponents(boolean bl) {
        if (bl) {
            this.countRadioButton.setSelected(true);
            this.percentLessCheckBox.setEnabled(false);
            this.percentMoreCheckBox.setEnabled(false);
            this.lessPercentSliderTextPanel.setEnabledComponents(false);
            this.morePercentSliderTextPanel.setEnabledComponents(false);
            this.countLessCheckBox.setEnabled(true);
            this.countMoreCheckBox.setEnabled(true);
            this.lessCountSliderTextPanel.setEnabled(true);
            this.moreCountSliderTextPanel.setEnabledComponents(true);
        } else {
            this.percentRadioButton.setSelected(true);
            this.percentLessCheckBox.setEnabled(true);
            this.percentMoreCheckBox.setEnabled(true);
            this.lessPercentSliderTextPanel.setEnabledComponents(true);
            this.morePercentSliderTextPanel.setEnabledComponents(true);
            this.countLessCheckBox.setEnabled(false);
            this.countMoreCheckBox.setEnabled(false);
            this.lessCountSliderTextPanel.setEnabled(false);
            this.moreCountSliderTextPanel.setEnabledComponents(false);
        }
        String string = (String)this.countUnitComboBoxModel.getSelectedItem();
        int n = this.getMaxSpSize(string);
        this.lessCountSliderTextPanel.setMinimum(0);
        this.lessCountSliderTextPanel.setMaximum(n);
        this.lessCountSliderTextPanel.setAutoLabelTable();
        this.moreCountSliderTextPanel.setMinimum(0);
        this.moreCountSliderTextPanel.setMaximum(n);
        this.moreCountSliderTextPanel.setAutoLabelTable();
        int n2 = String.valueOf(n).length();
        int n3 = String.valueOf(100).length();
        int n4 = n2 < n3 ? n3 : n2;
        this.lessCountSliderTextPanel.setTextColumns(n4);
        this.lessPercentSliderTextPanel.setTextColumns(n4);
        this.moreCountSliderTextPanel.setTextColumns(n4);
        this.morePercentSliderTextPanel.setTextColumns(n4);
        this.countUnitComboBoxModel.removeAllElements();
        for (int i = 0; i < taxRankList.length; ++i) {
            if (this.getMaxSpSize(taxRankList[i]) <= 1) continue;
            this.countUnitComboBoxModel.addElement(taxRankList[i]);
        }
        this.countUnitComboBoxModel.setSelectedItem(string);
        this.pack();
    }

    private int getMaxSpSize() {
        return this.getMaxSpSize(null);
    }

    private int getMaxSpSize(String string) {
        int n = -1;
        for (TaxFilterCondition taxFilterCondition : this.filterConditionList) {
            n = Math.max(taxFilterCondition.getTargetSpSize(string), n);
        }
        return n;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.countRadioButton) {
            this.updateComponents(true);
        } else if (actionEvent.getSource() == this.percentRadioButton) {
            this.updateComponents(false);
        } else {
            this.updateComponents(this.countRadioButton.isSelected());
        }
    }

    private boolean isUpdateMainFlag() {
        return this.updateMainFlag;
    }

    public void setUpdateMainFlag(boolean bl) {
        this.updateMainFlag = bl;
    }

    @Override
    protected boolean check() {
        if (this.isDisplayNameFlag() && this.nameTextField.getText().equals("")) {
            MessageManager.showErrorMessage((Component)this, "Input name.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean apply() {
        for (TaxFilterCondition taxFilterCondition : this.filterConditionList) {
            this.updateFilterCondition(taxFilterCondition);
        }
        if (this.isUpdateMainFlag()) {
            this.mediator.updateForFilter(true);
        }
        return true;
    }

    private void updateFilterCondition(TaxFilterCondition taxFilterCondition) {
        if (this.isDisplayNameFlag()) {
            taxFilterCondition.setName(this.nameTextField.getText());
        }
        taxFilterCondition.setCountFlag(this.countRadioButton.isSelected());
        taxFilterCondition.setLessCount(this.isLessCount());
        taxFilterCondition.setMoreCount(this.isMoreCount());
        taxFilterCondition.setLessPercent(this.isLessPercent());
        taxFilterCondition.setMorePercent(this.isMorePercent());
        taxFilterCondition.setLessThreshold(this.countRadioButton.isSelected(), this.getLessThreshold(taxFilterCondition));
        taxFilterCondition.setMoreThreshold(this.countRadioButton.isSelected(), this.getMoreThreshold(taxFilterCondition));
        String string = (String)this.countUnitComboBox.getSelectedItem();
        if (string.equals("genome")) {
            taxFilterCondition.unsetTaxUnit();
        } else {
            taxFilterCondition.setTaxUnit(string);
        }
    }

    private boolean isLessCount() {
        return this.countLessCheckBox.isSelected();
    }

    private boolean isMoreCount() {
        return this.countMoreCheckBox.isSelected();
    }

    private boolean isLessPercent() {
        return this.percentLessCheckBox.isSelected();
    }

    private boolean isMorePercent() {
        return this.percentMoreCheckBox.isSelected();
    }

    private double getLessThreshold(TaxFilterCondition taxFilterCondition) {
        double d = -1.0;
        d = this.countRadioButton.isSelected() ? this.adjustCountThreshold(this.lessCountSliderTextPanel.getValue(), taxFilterCondition.getSpSize()) : this.lessPercentSliderTextPanel.getValue() / 100.0;
        return d;
    }

    private double getMoreThreshold(TaxFilterCondition taxFilterCondition) {
        double d = -1.0;
        d = this.countRadioButton.isSelected() ? this.adjustCountThreshold(this.moreCountSliderTextPanel.getValue(), taxFilterCondition.getSpSize()) : this.morePercentSliderTextPanel.getValue() / 100.0;
        return d;
    }

    private double adjustCountThreshold(double d, int n) {
        double d2 = d;
        if (d > (double)n) {
            d2 = n;
        }
        return d2;
    }
}

