/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.data.Cluster;
import cgdp.recog.filter.CountFilterCondition;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.util.Converter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OrganismCountFilterCondition
extends CountFilterCondition {
    @Override
    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountOrganismLessFlag", String.valueOf(this.isLessFilter())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountOrganismMoreFlag", String.valueOf(this.isMoreFilter())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountOrganismLessCount", String.valueOf(this.getLessThreshold())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountOrganismMoreCount", String.valueOf(this.getMoreThreshold())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterCountOrganismEnable", String.valueOf(this.isFilterActive())));
        return arrayList;
    }

    @Override
    public void updateProperty(Map map, Project project, String string) {
        Object v = map.get("FilterCountOrganismLessFlag");
        if (v != null) {
            this.setLessFilter(Converter.convertBool(v));
        }
        if ((v = map.get("FilterCountOrganismMoreFlag")) != null) {
            this.setMoreFilter(Converter.convertBool(v));
        }
        if ((v = map.get("FilterCountOrganismLessCount")) != null) {
            this.setLessThreshold(Converter.convertInt(v));
        }
        if ((v = map.get("FilterCountOrganismMoreCount")) != null) {
            this.setMoreThreshold(Converter.convertInt(v));
        }
        if ((v = map.get("FilterCountOrganismEnable")) != null) {
            this.setFilterActive(Converter.convertBool(v));
        }
    }

    @Override
    public boolean isMatchCount(Cluster cluster) {
        return OrganismCountFilterCondition.isMatchCount(cluster.getSpCount(), this.getLessThreshold(), this.getMoreThreshold(), this.isLessFilter(), this.isMoreFilter());
    }

    @Override
    public boolean isSyncEnable() {
        return false;
    }
}

