/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.filter;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.filter.FilterConditionLabel;
import cgdp.recog.filter.FilterConditionParser;
import cgdp.recog.filter.TaxFilterCondition;
import cgdp.recog.project.Project;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.util.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaxFilterConditionGroup
implements ApplicationPropertyAccessable {
    private static final String NAME_ALL = "All";
    private static final String NAME_NONE = "None";
    private List filterConditionList = new ArrayList();
    private Map filterConditionSpMap = new HashMap();

    private TaxFilterConditionGroup() {
    }

    public static TaxFilterConditionGroup getInstance() {
        return new TaxFilterConditionGroup();
    }

    public boolean isMatch(Collection collection, Collection collection2) {
        for (TaxFilterCondition taxFilterCondition : this.filterConditionList) {
            if (!taxFilterCondition.isFilterActive() || taxFilterCondition.isMatchCondition(collection, collection2)) continue;
            return false;
        }
        return true;
    }

    public boolean setFilterCondition(long l, String string, int n, Map map) {
        return this.setFilterCondition(l, string, n, map, 0, 1, 0.0, 0.5, false, false, true, false, true, "genome");
    }

    public boolean setFilterCondition(long l, String string, int n, Map map, TaxFilterCondition taxFilterCondition) {
        return this.setFilterCondition(l, string, n, map, taxFilterCondition.getLessThresholdCount(), taxFilterCondition.getMoreThresholdCount(), taxFilterCondition.getLessThresholdPercent(), taxFilterCondition.getMoreThresholdPercent(), taxFilterCondition.isCountFlag(), taxFilterCondition.isLessCount(), taxFilterCondition.isMoreCount(), taxFilterCondition.isLessPercent(), taxFilterCondition.isMorePercent(), taxFilterCondition.getTaxUnit());
    }

    boolean setFilterCondition(long l, String string, int n, Map map, int n2, int n3, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string2) {
        boolean bl6 = false;
        if (TaxFilterCondition.isAll(n)) {
            bl6 |= this.removeAllNoneCondition(map.keySet());
            bl6 |= this.setAllCondition(map);
        } else if (TaxFilterCondition.isNone(n)) {
            bl6 |= this.removeAllNoneCondition(map.keySet());
            bl6 |= this.setNoneCondition(map);
        } else if (TaxFilterCondition.isAnyNew(n, l)) {
            bl6 |= this.createAnyCondition(string, map, n2, n3, d, d2, bl, bl2, bl3, bl4, bl5, string2);
        } else if (TaxFilterCondition.isAnyAdd(n, l)) {
            bl6 |= this.removeCondition(map.keySet());
            bl6 |= this.addAnyCondition(l, map);
        } else if (TaxFilterCondition.isExclude(n)) {
            bl6 |= this.removeCondition(map.keySet());
        }
        if (bl6) {
            this.updateFilterConditionSpMap();
        }
        return bl6;
    }

    private void updateFilterConditionSpMap() {
        this.filterConditionSpMap.clear();
        for (TaxFilterCondition taxFilterCondition : this.filterConditionList) {
            int n = taxFilterCondition.getCondition();
            HashSet hashSet = (HashSet)this.filterConditionSpMap.get(new Integer(n));
            if (hashSet == null) {
                hashSet = new HashSet();
                this.filterConditionSpMap.put(new Integer(n), hashSet);
            }
            hashSet.addAll(taxFilterCondition.getSpSet());
        }
    }

    public TaxFilterCondition getAllCondition() {
        TaxFilterCondition taxFilterCondition = null;
        for (TaxFilterCondition taxFilterCondition2 : this.filterConditionList) {
            if (!taxFilterCondition2.isAll()) continue;
            taxFilterCondition = taxFilterCondition2;
            break;
        }
        return taxFilterCondition;
    }

    private boolean setAllCondition(Map map) {
        boolean bl = false;
        TaxFilterCondition taxFilterCondition = this.getAllCondition();
        if (taxFilterCondition != null) {
            bl |= taxFilterCondition.addSpList(map);
        } else {
            taxFilterCondition = new TaxFilterCondition(NAME_ALL, 1, map);
            this.filterConditionList.add(taxFilterCondition);
            bl = true;
        }
        return bl;
    }

    public TaxFilterCondition getNoneCondition() {
        TaxFilterCondition taxFilterCondition = null;
        for (TaxFilterCondition taxFilterCondition2 : this.filterConditionList) {
            if (!taxFilterCondition2.isNone()) continue;
            taxFilterCondition = taxFilterCondition2;
            break;
        }
        return taxFilterCondition;
    }

    private boolean setNoneCondition(Map map) {
        boolean bl = false;
        TaxFilterCondition taxFilterCondition = this.getNoneCondition();
        if (taxFilterCondition != null) {
            bl |= taxFilterCondition.addSpList(map);
        } else {
            taxFilterCondition = new TaxFilterCondition(NAME_NONE, 3, map);
            this.filterConditionList.add(taxFilterCondition);
            bl = true;
        }
        return bl;
    }

    public List getAnyConditionList() {
        ArrayList<TaxFilterCondition> arrayList = new ArrayList<TaxFilterCondition>();
        for (TaxFilterCondition taxFilterCondition : this.filterConditionList) {
            if (!taxFilterCondition.isAny()) continue;
            arrayList.add(taxFilterCondition);
        }
        return arrayList;
    }

    private TaxFilterCondition getAnyCondition(long l) {
        TaxFilterCondition taxFilterCondition = null;
        for (TaxFilterCondition taxFilterCondition2 : this.filterConditionList) {
            if (taxFilterCondition2.getId() != l) continue;
            taxFilterCondition = taxFilterCondition2;
            break;
        }
        return taxFilterCondition;
    }

    private boolean addAnyCondition(long l, Map map) {
        boolean bl = false;
        TaxFilterCondition taxFilterCondition = this.getAnyCondition(l);
        if (taxFilterCondition == null) {
            return false;
        }
        return bl |= taxFilterCondition.addSpList(map);
    }

    private boolean isSameSpListAnyCondition(Collection collection) {
        List list = this.getAnyConditionList();
        for (TaxFilterCondition taxFilterCondition : list) {
            if (!taxFilterCondition.equalsSpList(collection)) continue;
            return true;
        }
        return false;
    }

    private String createFilterConditionName(String string) {
        String string2 = string;
        HashSet<String> hashSet = new HashSet<String>();
        List list = this.getAnyConditionList();
        for (TaxFilterCondition taxFilterCondition : list) {
            if (!taxFilterCondition.getName().startsWith(string)) continue;
            hashSet.add(taxFilterCondition.getName());
        }
        int n = 1;
        while (hashSet.contains(string2)) {
            string2 = string + " " + n;
            ++n;
        }
        return string2;
    }

    private boolean createAnyCondition(String string, Map map) {
        return this.createAnyCondition(string, map, 0, 1, 0.0, 0.5, false, false, true, false, true, "genome");
    }

    private boolean createAnyCondition(String string, Map map, int n, int n2, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string2) {
        if (this.isSameSpListAnyCondition(map.keySet())) {
            return false;
        }
        String string3 = this.createFilterConditionName(string);
        TaxFilterCondition taxFilterCondition = new TaxFilterCondition(string3, 2, map);
        taxFilterCondition.setLessThresholdCount(n);
        taxFilterCondition.setMoreThresholdCount(n2);
        taxFilterCondition.setLessThresholdPercent(d);
        taxFilterCondition.setMoreThresholdPercent(d2);
        taxFilterCondition.setCountFlag(bl);
        taxFilterCondition.setLessCount(bl2);
        taxFilterCondition.setMoreCount(bl3);
        taxFilterCondition.setLessPercent(bl4);
        taxFilterCondition.setMorePercent(bl5);
        taxFilterCondition.setTaxUnit(string2);
        this.filterConditionList.add(taxFilterCondition);
        return true;
    }

    private boolean removeCondition(Collection collection) {
        boolean bl = false;
        HashSet<TaxFilterCondition> hashSet = new HashSet<TaxFilterCondition>();
        for (TaxFilterCondition taxFilterCondition : this.filterConditionList) {
            bl |= taxFilterCondition.removeSp(collection);
            if (!taxFilterCondition.isEmptySp()) continue;
            hashSet.add(taxFilterCondition);
        }
        if (bl |= this.filterConditionList.removeAll(hashSet)) {
            this.updateFilterConditionSpMap();
        }
        return bl;
    }

    private boolean removeCondition(int n, Collection collection) {
        boolean bl = false;
        HashSet<TaxFilterCondition> hashSet = new HashSet<TaxFilterCondition>();
        for (TaxFilterCondition taxFilterCondition : this.filterConditionList) {
            if (!taxFilterCondition.equalsCondition(n)) continue;
            bl |= taxFilterCondition.removeSp(collection);
            if (!taxFilterCondition.isEmptySp()) continue;
            hashSet.add(taxFilterCondition);
        }
        if (bl |= this.filterConditionList.removeAll(hashSet)) {
            this.updateFilterConditionSpMap();
        }
        return bl;
    }

    private boolean removeAllNoneCondition(Collection collection) {
        boolean bl = false;
        HashSet<TaxFilterCondition> hashSet = new HashSet<TaxFilterCondition>();
        for (TaxFilterCondition taxFilterCondition : this.filterConditionList) {
            if (taxFilterCondition.isAny()) continue;
            bl |= taxFilterCondition.removeSp(collection);
            if (!taxFilterCondition.isEmptySp()) continue;
            hashSet.add(taxFilterCondition);
        }
        if (bl |= this.filterConditionList.removeAll(hashSet)) {
            this.updateFilterConditionSpMap();
        }
        return bl;
    }

    public List getSpListForAll() {
        TaxFilterCondition taxFilterCondition = this.getAllCondition();
        return this.getSpList(taxFilterCondition);
    }

    public List getSpListForNone() {
        TaxFilterCondition taxFilterCondition = this.getNoneCondition();
        return this.getSpList(taxFilterCondition);
    }

    private List getSpList(TaxFilterCondition taxFilterCondition) {
        if (taxFilterCondition == null) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList(taxFilterCondition.getSpSet());
        Collections.sort(arrayList);
        return arrayList;
    }

    private void clear() {
        this.filterConditionList.clear();
        this.filterConditionSpMap.clear();
    }

    public boolean isAll(String string) {
        Set set = (Set)this.filterConditionSpMap.get(new Integer(1));
        if (set == null) {
            return false;
        }
        return set.contains(string);
    }

    public boolean isNone(String string) {
        Set set = (Set)this.filterConditionSpMap.get(new Integer(3));
        if (set == null) {
            return false;
        }
        return set.contains(string);
    }

    public boolean isAny(String string) {
        Set set = (Set)this.filterConditionSpMap.get(new Integer(2));
        if (set == null) {
            return false;
        }
        return set.contains(string);
    }

    public void setAnyThresholdByMenu(boolean bl, boolean bl2, double d, List list) {
        this.setMoreLessFlag(bl, bl2, list);
        this.setAnyThreshold(bl, bl2, d, list);
    }

    private void setAnyThreshold(boolean bl, boolean bl2, double d, List list) {
        if (list == null) {
            list = this.filterConditionList;
        }
        for (TaxFilterCondition taxFilterCondition : list) {
            if (!taxFilterCondition.isAny()) continue;
            if (bl2) {
                taxFilterCondition.setMoreThreshold(bl, d);
                continue;
            }
            taxFilterCondition.setLessThreshold(bl, d);
        }
    }

    private void setMoreLessFlag(boolean bl, boolean bl2, List list) {
        if (list == null) {
            list = this.filterConditionList;
        }
        for (TaxFilterCondition taxFilterCondition : list) {
            if (!taxFilterCondition.isAny()) continue;
            if (bl) {
                taxFilterCondition.setLessCount(!bl2);
                taxFilterCondition.setMoreCount(bl2);
                continue;
            }
            taxFilterCondition.setLessPercent(!bl2);
            taxFilterCondition.setMorePercent(bl2);
        }
    }

    public double getAnyThreshold() {
        if (this.filterConditionList.isEmpty()) {
            return 0.5;
        }
        TaxFilterCondition taxFilterCondition = (TaxFilterCondition)this.filterConditionList.get(0);
        if (taxFilterCondition.isCountFlag()) {
            return -1.0;
        }
        return taxFilterCondition.getMaxThreshold();
    }

    public boolean isExistCondition() {
        return !this.filterConditionList.isEmpty();
    }

    private TaxFilterCondition getFilterCondition(long l) {
        TaxFilterCondition taxFilterCondition = null;
        for (TaxFilterCondition taxFilterCondition2 : this.filterConditionList) {
            if (!taxFilterCondition2.equalsId(l)) continue;
            taxFilterCondition = taxFilterCondition2;
            break;
        }
        return taxFilterCondition;
    }

    List getFilterConditionList() {
        ArrayList<TaxFilterCondition> arrayList = new ArrayList<TaxFilterCondition>();
        TaxFilterCondition taxFilterCondition = this.getAllCondition();
        if (taxFilterCondition != null) {
            arrayList.add(taxFilterCondition);
        }
        if ((taxFilterCondition = this.getNoneCondition()) != null) {
            arrayList.add(taxFilterCondition);
        }
        arrayList.addAll(this.getAnyConditionList());
        return arrayList;
    }

    TaxFilterCondition getFilterCondition(int n, long l) {
        TaxFilterCondition taxFilterCondition = null;
        if (TaxFilterCondition.isAll(n)) {
            taxFilterCondition = this.getAllCondition();
        } else if (TaxFilterCondition.isNone(n)) {
            taxFilterCondition = this.getNoneCondition();
        } else if (TaxFilterCondition.isAny(n) && (taxFilterCondition = this.getAnyCondition(l)) == null && !(taxFilterCondition = this.getMaxIdFilterCondition()).isAny()) {
            taxFilterCondition = null;
        }
        return taxFilterCondition;
    }

    TaxFilterCondition getMaxIdFilterCondition() {
        TaxFilterCondition taxFilterCondition = null;
        for (TaxFilterCondition taxFilterCondition2 : this.filterConditionList) {
            if (taxFilterCondition == null) {
                taxFilterCondition = taxFilterCondition2;
                continue;
            }
            if (taxFilterCondition.getId() >= taxFilterCondition2.getId()) continue;
            taxFilterCondition = taxFilterCondition2;
        }
        return taxFilterCondition;
    }

    public boolean removeFilterConditions(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            bl |= this.removeFilterCondition(l);
        }
        if (bl) {
            this.updateFilterConditionSpMap();
        }
        return bl;
    }

    private boolean removeFilterCondition(long l) {
        boolean bl = false;
        TaxFilterCondition taxFilterCondition = this.getFilterCondition(l);
        if (taxFilterCondition != null) {
            bl = this.filterConditionList.remove(taxFilterCondition);
        }
        return bl;
    }

    public boolean removeSpFromCondition(long l, Collection collection) {
        boolean bl = false;
        TaxFilterCondition taxFilterCondition = this.getFilterCondition(l);
        if (taxFilterCondition != null) {
            bl = taxFilterCondition.removeSp(collection);
            if (taxFilterCondition.isEmptySp()) {
                bl = this.filterConditionList.remove(taxFilterCondition);
            }
            if (bl) {
                this.updateFilterConditionSpMap();
            }
        }
        return bl;
    }

    public Map createDisplayOptionMap(ClusterTbl clusterTbl) {
        List list;
        TaxFilterCondition taxFilterCondition;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        TaxFilterCondition taxFilterCondition2 = this.getAllCondition();
        if (taxFilterCondition2 != null) {
            linkedHashMap.put(FilterConditionLabel.getNodeLabel(taxFilterCondition2, clusterTbl), StringTool.conbineStrList(taxFilterCondition2.getSpList(), ","));
        }
        if ((taxFilterCondition = this.getNoneCondition()) != null) {
            linkedHashMap.put(FilterConditionLabel.getNodeLabel(taxFilterCondition, clusterTbl), StringTool.conbineStrList(taxFilterCondition.getSpList(), ","));
        }
        if (!(list = this.getAnyConditionList()).isEmpty()) {
            for (TaxFilterCondition taxFilterCondition3 : list) {
                linkedHashMap.put(FilterConditionLabel.getNodeLabel(taxFilterCondition3, clusterTbl), StringTool.conbineStrList(taxFilterCondition3.getSpList(), ","));
            }
        }
        return linkedHashMap;
    }

    @Override
    public String getCategory() {
        return "FilterTaxonomy";
    }

    @Override
    public List getPropertyList(Project project, String string) {
        String string2 = FilterConditionParser.condition2Str(this);
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "FilterTaxonomyCondition", string2));
        return arrayList;
    }

    @Override
    public int getPropertyType() {
        return 2;
    }

    @Override
    public void updateProperty(Map map, Project project, String string) {
        String string2 = (String)map.get("FilterTaxonomyCondition");
        if (StringTool.isNull(string2)) {
            return;
        }
        FilterConditionParser.str2Condition(this, string2);
    }
}

