/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.funccat;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.ApplicationLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;

class FuncCatMenuManager
implements ActionListener {
    private static final ApplicationLogger logger = new ApplicationLogger(FuncCatMenuManager.class);
    private MediatorImpl mediator;

    FuncCatMenuManager(MediatorImpl mediatorImpl) {
        this.mediator = mediatorImpl;
    }

    List getMenuList() {
        FuncCatSubItem funcCatSubItem = new FuncCatSubItem(this, this.mediator, "MBGD", "mbgd");
        FuncCatSubItem funcCatSubItem2 = new FuncCatSubItem(this, this.mediator, "COG", "cog");
        FuncCatSubItem funcCatSubItem3 = new FuncCatSubItem(this, this.mediator, "KEGG", "kegg");
        FuncCatSubItem funcCatSubItem4 = new FuncCatSubItem(this, this.mediator, "TIGR", "tigr");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(funcCatSubItem);
        buttonGroup.add(funcCatSubItem2);
        buttonGroup.add(funcCatSubItem3);
        buttonGroup.add(funcCatSubItem4);
        String string = OptionTbl.getInstance().getOptionValues().getFunctionCategoryType();
        funcCatSubItem.setSelectedFuncCat(string);
        funcCatSubItem2.setSelectedFuncCat(string);
        funcCatSubItem3.setSelectedFuncCat(string);
        funcCatSubItem4.setSelectedFuncCat(string);
        ArrayList<FuncCatSubItem> arrayList = new ArrayList<FuncCatSubItem>();
        arrayList.add(funcCatSubItem);
        arrayList.add(funcCatSubItem2);
        arrayList.add(funcCatSubItem3);
        arrayList.add(funcCatSubItem4);
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FuncCatSubItem funcCatSubItem = (FuncCatSubItem)actionEvent.getSource();
        funcCatSubItem.execute();
    }

    class FuncCatSubItem
    extends JRadioButtonMenuItem
    implements CommandImpl {
        private MediatorImpl mediator;
        private String funcCatName;
        private String funcCatType;

        FuncCatSubItem(ActionListener actionListener, MediatorImpl mediatorImpl, String string, String string2) {
            super(string);
            this.mediator = mediatorImpl;
            this.funcCatName = string;
            this.funcCatType = string2;
            this.addActionListener(actionListener);
        }

        void setSelectedFuncCat(String string) {
            this.setSelected(string.equals(this.funcCatType));
        }

        @Override
        public void execute() {
            try {
                FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
                funcCatTbl.setFunctionCategoryType(this.funcCatType);
                funcCatTbl.readFuncCat(this.funcCatType);
                this.mediator.applyFunctionCategoryColor(this.funcCatType, funcCatTbl.getCopyFuncCatList());
            }
            catch (IOException iOException) {
                String string = "Fail to load the function category list";
                logger.warn(string, iOException);
            }
        }
    }
}

