/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.funccat;

import cgdp.recog.data.DataManager;
import cgdp.recog.funccat.FuncCat;
import cgdp.recog.funccat.FunctionCategoryDownloader;
import cgdp.recog.funccat.FunctionCategoryExporter;
import cgdp.recog.funccat.FunctionCategoryImporter;
import cgdp.recog.funccat.FunctionCategoryNoComparator;
import cgdp.recog.funccat.FunctionCategoryType;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FuncCatTbl
extends TreeMap {
    private static final ApplicationLogger logger = new ApplicationLogger(FuncCatTbl.class);
    private static FuncCatTbl funcCatTbl = new FuncCatTbl();
    private String functionCategoryType;
    private Map defaultFuncCatMap = new HashMap();

    private FuncCatTbl() {
        super(new FunctionCategoryNoComparator());
        try {
            OptionTbl optionTbl = OptionTbl.getInstance();
            this.setFunctionCategoryType(optionTbl.getOptionValues().getFunctionCategoryType());
            this.readFuncCat(this.functionCategoryType);
        }
        catch (IOException iOException) {
            String string = "Fail to load function category file.";
            MessageManager.showErrorMessage(null, string);
            logger.warn(string, iOException);
            System.exit(0);
        }
    }

    public void updateDefaultFuncCat() {
        ArrayList arrayList = new ArrayList(this.values());
        FuncCat funcCat = FuncCatTbl.getDefaultFuncCat(arrayList);
        this.defaultFuncCatMap.put(this.functionCategoryType, funcCat);
    }

    public void readFuncCat(String string) throws IOException {
        FunctionCategoryImporter functionCategoryImporter = new FunctionCategoryImporter(string);
        functionCategoryImporter.execute();
        this.clear();
        this.putAll(functionCategoryImporter.getFunctionCategoryMap());
        this.setFunctionCategoryType(string);
        this.updateDefaultFuncCat();
    }

    public void writeFuncCat(String string) throws IOException {
        ArrayList arrayList = new ArrayList(this.values());
        FunctionCategoryExporter functionCategoryExporter = new FunctionCategoryExporter(string, arrayList);
        functionCategoryExporter.execute();
    }

    public void restoreAll(boolean bl) throws Exception {
        this.restore(null, bl);
    }

    public void restore(String string, boolean bl) throws Exception {
        if (!bl) {
            boolean bl2 = false;
            for (int i = 0; i < FunctionCategoryType.FUNCTION_CATEGORY_TYPES.length; ++i) {
                String string2 = this.getFunctionCategoryFilepath(FunctionCategoryType.FUNCTION_CATEGORY_TYPES[i]);
                if (new File(string2).isFile()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return;
            }
        }
        FunctionCategoryDownloader functionCategoryDownloader = new FunctionCategoryDownloader();
        functionCategoryDownloader.execute();
        if (functionCategoryDownloader.isError()) {
            logger.warn(functionCategoryDownloader.getErrorMessage());
        }
        Map map = functionCategoryDownloader.getFunctionCategoryMap();
        for (String string3 : map.keySet()) {
            String string4 = this.getFunctionCategoryFilepath(string3);
            if (new File(string4).isFile() && !bl || !StringTool.isNull(string) && !string3.equals(string)) continue;
            List list = (List)map.get(string3);
            FunctionCategoryExporter functionCategoryExporter = new FunctionCategoryExporter(string3, list);
            functionCategoryExporter.execute();
        }
        if (!StringTool.isNull(string)) {
            this.readFuncCat(string);
        }
    }

    public void downloadDefualtFunctionCategory(String string) throws Exception {
        FunctionCategoryDownloader functionCategoryDownloader = new FunctionCategoryDownloader();
        functionCategoryDownloader.execute();
        if (functionCategoryDownloader.isError()) {
            logger.warn(functionCategoryDownloader.getErrorMessage());
        }
        Map map = functionCategoryDownloader.getFunctionCategoryMap();
        List list = (List)map.get(string);
        this.clear();
        for (FuncCat funcCat : list) {
            this.put(funcCat.getFunctionCategoryNo(), funcCat);
        }
    }

    private String getFunctionCategoryFilepath(String string) {
        return DataManager.getFunctionCategoryFilepath(string);
    }

    public void restore(String string) throws Exception {
        this.restore(string, true);
    }

    public static FuncCatTbl getInstance() {
        return funcCatTbl;
    }

    public FuncCat getFuncCat(String string) {
        FuncCat funcCat = (FuncCat)this.get(string);
        if (funcCat == null) {
            funcCat = this.getDefaultFuncCat();
        }
        return funcCat;
    }

    public FuncCat getDefaultFuncCat() {
        return (FuncCat)this.defaultFuncCatMap.get(this.functionCategoryType);
    }

    public static FuncCat getDefaultFuncCat(Collection collection) {
        FuncCat funcCat = null;
        for (FuncCat funcCat2 : collection) {
            if (!funcCat2.isDefaultFlag()) continue;
            funcCat = funcCat2;
            break;
        }
        if (funcCat == null) {
            for (FuncCat funcCat2 : collection) {
                if (StringTool.isNull(funcCat2.getColor())) continue;
                funcCat = funcCat2;
                break;
            }
        }
        return funcCat;
    }

    public List getCopyFuncCatList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (FuncCat funcCat : this.values()) {
            arrayList.add(funcCat.clone());
        }
        return arrayList;
    }

    public String getFunctionCategoryType() {
        return this.functionCategoryType;
    }

    public void setFunctionCategoryType(String string) {
        this.functionCategoryType = string;
    }

    public String getFuctionCategoryName() {
        return FunctionCategoryType.getType2Display(this.getFunctionCategoryType());
    }
}

