/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.funccat;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.funccat.FuncCatTable;
import cgdp.recog.funccat.FuncCatTbl;
import cgdp.recog.server.AccessServer;
import cgdp.recog.server.ServerAccessCheckTask;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

public class FunctionCategoryDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Function Category";
    private static FunctionCategoryDialog singleInstance = null;
    private MediatorImpl mediator;
    private FuncCatTable funcCatTable;
    private JButton restoreButton;

    public FunctionCategoryDialog(Frame frame, MediatorImpl mediatorImpl) {
        super(frame);
        this.mediator = mediatorImpl;
        this.createComponents();
    }

    public static FunctionCategoryDialog createFunctionCategoryDialog(Frame frame, MediatorImpl mediatorImpl) {
        if (singleInstance == null) {
            singleInstance = new FunctionCategoryDialog(frame, mediatorImpl);
        }
        return singleInstance;
    }

    private void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        this.funcCatTable = new FuncCatTable(this.mediator);
        this.funcCatTable.setTableHeight(280);
        this.restoreButton = new JButton("Restore");
        this.restoreButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.restoreButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        jPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.funcCatTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 10, 15, 15), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setApplyClose(false);
        this.setModal(false);
    }

    private void restore() {
        block4: {
            if (!AccessServer.getInstance().isEnableAccess()) {
                boolean bl;
                while (bl = AccessServer.showAccessErrorMessageRetry(this)) {
                    ServerAccessCheckTask.getInstance().checkAccessServer(AccessServer.getInstance().getServerUrl());
                    if (!AccessServer.getInstance().isEnableAccess()) continue;
                    break block4;
                }
                return;
            }
        }
        try {
            FuncCatTbl funcCatTbl = FuncCatTbl.getInstance();
            funcCatTbl.downloadDefualtFunctionCategory(this.getFunctionCategoryType());
            this.funcCatTable.restoreFuncCatColor();
        }
        catch (Exception exception) {
            MessageManager.showErrorMessage((Component)this, "Fail to download function category file.");
        }
    }

    public String getFunctionCategoryType() {
        return this.funcCatTable.getSelectedFunctionCategoryType();
    }

    public List getFunctionCategoryList() {
        return this.funcCatTable.getFunctionCategoryList();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.restoreButton) {
            this.restore();
        } else if (actionEvent.getSource() == this.applyButton) {
            this.mediator.applyFunctionCategoryColor(this.getFunctionCategoryType(), this.getFunctionCategoryList());
        } else if (actionEvent.getSource() == this.closeButton) {
            return;
        }
        this.funcCatTable.updateFuncCatFilter();
    }

    @Override
    protected boolean apply() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        singleInstance = null;
        System.gc();
    }
}

