/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import java.util.LinkedList;

public class BinQueue {
    int minValue;
    int maxValue;
    int scale;
    int minIdx;
    int maxIdx;
    LinkedList[] data;
    LinkedList data_overflow;
    LinkedList data_underflow;
    boolean logscale;
    int indexSize;
    int order;
    public static final int GETMAX = 0;
    public static final int GETMIN = 1;

    public BinQueue(int n, int n2, int n3) throws IllegalArgumentException {
        this(n, n2, n3, 0, false);
    }

    public BinQueue(int n, int n2, int n3, int n4) throws IllegalArgumentException {
        this(n, n2, n3, n4, false);
    }

    public BinQueue(int n, int n2, int n3, int n4, boolean bl) throws IllegalArgumentException {
        if (n > n2) {
            throw new IllegalArgumentException("[min>max]: min=" + n + "; max= " + n2);
        }
        this.minValue = n;
        this.maxValue = n2;
        this.scale = n3;
        this.logscale = bl;
        this.minIdx = 0;
        this.order = n4;
        if (!this.logscale) {
            this.indexSize = (n2 - n + 1) * this.scale;
            this.maxIdx = (n2 - n + 1) * this.scale;
        }
        this.indexSize = this.maxIdx + 1;
        this.data = new LinkedList[this.indexSize];
    }

    public void add(double d, Object object) {
        int n = this.calcIndex(d);
        if (n >= this.indexSize) {
            System.err.println("BinQueue: index underflow");
            if (this.data_overflow == null) {
                this.data_overflow = new LinkedList();
            }
            this.data_overflow.add(object);
        } else if (n < 0) {
            System.err.println("BinQueue: index underflow");
            if (this.data_underflow == null) {
                this.data_underflow = new LinkedList();
            }
            this.data_underflow.add(object);
        }
        if (this.data[n] == null) {
            this.data[n] = new LinkedList();
        }
        this.data[n].add(object);
    }

    Object getBestData() {
        if (this.order == 0) {
            return this.getMaxData();
        }
        return this.getMinData();
    }

    Object getMaxData() {
        while (this.maxIdx >= 0 && (this.data[this.maxIdx] == null || this.data[this.maxIdx].size() == 0)) {
            --this.maxIdx;
        }
        if (this.maxIdx < 0) {
            return null;
        }
        return this.data[this.maxIdx].removeLast();
    }

    Object getMinData() {
        while (this.minIdx < this.data.length && (this.data[this.minIdx] == null || this.data[this.minIdx].size() == 0)) {
            ++this.minIdx;
        }
        if (this.minIdx >= this.data.length) {
            return null;
        }
        return this.data[this.minIdx].removeFirst();
    }

    int calcIndex(double d) {
        int n = this.logscale ? (int)(Math.log(d / (double)this.minValue) * (double)this.scale) : (int)((d - (double)this.minValue) * (double)this.scale);
        return n;
    }

    public static void main(String[] stringArray) {
        BinQueue binQueue = new BinQueue(0, 250, 100, 1);
        binQueue.add(10.0, "val=10");
        binQueue.add(50.0, "val=50");
        binQueue.add(0.5, "val=0.5");
        binQueue.add(0.0, "val=0");
        binQueue.add(40.0, "val=40");
        binQueue.add(100.11, "val=100.11");
        binQueue.add(100.12, "val=100.12");
        binQueue.add(100.0, "val=100");
        System.out.println(binQueue.getBestData());
        System.out.println(binQueue.getMaxData());
        System.out.println(binQueue.getMaxData());
        System.out.println(binQueue.getMinData());
        System.out.println(binQueue.getMinData());
        System.out.println(binQueue.indexSize);
    }
}

