/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.hcluster.BinQueue;
import cgdp.recog.hcluster.ClusterNode;
import cgdp.recog.hcluster.HClustException;
import cgdp.recog.hcluster.NodeIndex;
import cgdp.recog.hcluster.NodeNbrList;
import cgdp.recog.hcluster.PairDist;
import java.util.ArrayList;
import java.util.HashMap;

public class DistMatrix {
    HashMap nodehash = new HashMap();
    ArrayList distdata = new ArrayList();
    static double minCut;
    static double maxCut;
    double minDist = 9.9999999E7;
    double maxDist = -9.9999999E7;
    static final int BIG_VALUE = 99999999;
    static final int SMALL_VALUE = -99999999;
    NodeIndex nodeIndex;
    BinQueue binq;

    public DistMatrix() {
        minCut = -9.9999999E7;
        maxCut = 9.9999999E7;
        this.nodeIndex = new NodeIndex();
    }

    static void setDistCutoff(double d, double d2) {
        minCut = d;
        maxCut = d2;
    }

    public void add(String string, String string2, double d) throws HClustException {
        if (string.compareTo(string2) == 0) {
            return;
        }
        if (this.definedDist(minCut) && d < minCut) {
            return;
        }
        if (this.definedDist(maxCut) && d > maxCut) {
            return;
        }
        ClusterNode clusterNode = ClusterNode.createLeafNode(string);
        this.nodeIndex.addNode(clusterNode.id);
        ClusterNode clusterNode2 = ClusterNode.createLeafNode(string2);
        this.nodeIndex.addNode(clusterNode2.id);
        if (d < this.minDist) {
            this.minDist = d;
        }
        if (d > this.maxDist) {
            this.maxDist = d;
        }
        PairDist pairDist = PairDist.newInstance(clusterNode, clusterNode2, d);
        this.add(pairDist);
    }

    private boolean definedDist(double d) {
        return d > -9.9999999E7 && d < 9.9999999E7;
    }

    public void add(PairDist pairDist) {
        this.distdata.add(pairDist);
        this.nodeIndex.addData(pairDist);
        if (this.binq != null) {
            this.binq.add(pairDist.dist, pairDist);
        }
    }

    public void createIndex(int n) {
        this.nodeIndex.convert();
        this.createBinQueue(n);
    }

    void createBinQueue() {
        this.createBinQueue(1);
    }

    void createBinQueue(int n) {
        double d;
        int n2;
        int n3 = n2 = PairDist.best == 0 ? 1 : 0;
        double d2 = this.definedDist(minCut) ? minCut : (d = this.definedDist(this.minDist) ? this.minDist : 0.0);
        double d3 = this.definedDist(maxCut) ? maxCut : (this.definedDist(this.maxDist) ? this.maxDist : 100.0);
        this.binq = new BinQueue((int)Math.floor(d), (int)Math.ceil(d3), n, n2);
        PairDist pairDist = null;
        for (int i = 0; i < this.distdata.size(); ++i) {
            pairDist = (PairDist)this.distdata.get(i);
            this.binq.add(pairDist.dist, pairDist);
        }
    }

    NodeNbrList findNeighbors(ClusterNode clusterNode) {
        return this.nodeIndex.get(clusterNode.id);
    }

    public PairDist getBestData() {
        return (PairDist)this.binq.getBestData();
    }

    public double getMinDist() {
        return this.minDist;
    }

    public double getMaxDist() {
        return this.maxDist;
    }

    public int getNodeNum() {
        return this.nodehash.size();
    }

    public int getDistNum() {
        return this.distdata.size();
    }
}

