/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.calc.AbstractCalcCondition;
import cgdp.recog.calc.CoefType;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.InfoClass;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoCalcCondition;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.project.Project;
import cgdp.recog.server.EnvType;
import cgdp.recog.sort.GeneInfoSortConditionGroup;
import cgdp.recog.sort.InfoSortCondition;
import cgdp.recog.sort.SortCondition;
import cgdp.recog.sort.SortConditionFactory;
import cgdp.recog.system.property.ApplicationProperty;
import cgdp.recog.system.property.ApplicationPropertyAccessable;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.Digest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HClustCondition
extends AbstractCalcCondition
implements InfoSortCondition,
ApplicationPropertyAccessable {
    private static final ApplicationLogger logger = new ApplicationLogger(HClustCondition.class);
    static final String NO_PHPAT_CLUSTER_PREFIX = "N";
    static final String EXEC_SERVER_LOCAL = "Local";
    static final int EXEC_SERVER_PORT_LOCAL = 0;
    private static final String NAME_NAME = "Name";
    private static final String NAME_EXECUTE = "Execute";
    private static final String NAME_TARGET = "Target";
    private static final String NAME_MIN_EXIST = "Minimum number of organisms";
    private static final String NAME_CUTOFF = "Cut off(%)";
    private static final String NAME_MISS_DIST_RATIO = "Miss Dist Ratio(%)";
    private static final String NAME_PROBCUT = "Probability Cutoff(%)";
    private static final String NAME_DISTTYPE = "Type of Distance";
    private static final String NAME_PROFILE = "Profile";
    private static final String NAME_PROPERTY = "Property";
    private static final String MODE_CLUSTER_CLUSTER = "cluster";
    private static final String MODE_CLUSTER_SUBCLUSTER = "subcluster";
    private static final int DEFAULT_MIN_EXIST = 3;
    public static final double DEFAULT_CUTOFF = 1.0;
    public static final double DEFAULT_MISS_DIST_RATIO = 0.9;
    public static final double DEFAULT_PROBABILITY_CUTOFF = 1.0;
    public static final String TYPE_DISTANCE = "N";
    private static final String DEFAULT_MODE_CLUSTER = "subcluster";
    private static final boolean DEFAULT_DO_COMPRESS = true;
    private static final int DEFAULT_SCALE = 10000;
    private String domClustId;
    private String execServer;
    private int execPort;
    private String domClustName;
    private int minExist = 3;
    private double cutoff = 1.0;
    private double missDistRatio = 0.9;
    private double probabilityCutoff = 1.0;
    private String modeCluster = "subcluster";
    private int execEnv;
    private boolean targetFilteredClusterList = false;
    private boolean useCache = true;
    private boolean doCompress = true;
    private int scale = 10000;
    private boolean restruct = true;

    public void setExecEnvServer() {
        this.execEnv = 2;
    }

    public void setExecEnvLocal() {
        this.execEnv = 1;
    }

    public void setExecEnv(int n) {
        this.execEnv = n;
    }

    public int getExecEnv() {
        return this.execEnv;
    }

    public boolean isServer() {
        return HClustCondition.isServer(this.execEnv);
    }

    public boolean isLocal() {
        return HClustCondition.isLocal(this.execEnv);
    }

    public static boolean isServer(int n) {
        return EnvType.isServer(n);
    }

    public static boolean isLocal(int n) {
        return EnvType.isLocal(n);
    }

    public static boolean isLocal(String string) {
        return string.equals(EXEC_SERVER_LOCAL);
    }

    public String getDomClustId() {
        return this.domClustId;
    }

    public void setDomClustId(String string) {
        this.domClustId = string;
    }

    public String getExecServer() {
        return this.execServer;
    }

    public void setExecServer(String string) {
        this.execServer = string;
    }

    public int getExecPort() {
        return this.execPort;
    }

    public void setExecPort(int n) {
        this.execPort = n;
    }

    public String getDomClustName() {
        return this.domClustName;
    }

    public void setDomClustName(String string) {
        this.domClustName = string;
    }

    public int getMinExist() {
        return this.minExist;
    }

    public void setMinExist(int n) {
        this.minExist = n;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(double d) {
        this.cutoff = d;
    }

    public double getMissDistRatio() {
        return this.missDistRatio;
    }

    public double calcMissDist() {
        double d = this.getCutoff() / this.getMissDistRatio();
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    public void setMissDistRatio(double d) {
        this.missDistRatio = d;
    }

    public String getModeCluster() {
        return this.modeCluster;
    }

    public void setModeCluster(String string) {
        this.modeCluster = string;
    }

    public void setModeCluster() {
        this.modeCluster = MODE_CLUSTER_CLUSTER;
    }

    public void setModeSubCluster() {
        this.modeCluster = "subcluster";
    }

    public boolean isModeCluster() {
        return this.modeCluster == MODE_CLUSTER_CLUSTER;
    }

    public boolean isModeSubCluster() {
        return this.modeCluster == "subcluster";
    }

    @Override
    public int getInoutType() {
        int n = this.isModeCluster() ? 2 : 1;
        return n;
    }

    public double getProbabilityCutoff() {
        return this.probabilityCutoff;
    }

    public void setProbabilityCutoff(double d) {
        this.probabilityCutoff = d;
    }

    public String getTypeDistance() {
        return CoefType.getTypeDistanceKey2TypeForHClust(this.getDistType());
    }

    public int getTypeDistanceForHClust() {
        return this.getDistType();
    }

    public void setTypeDistance(String string) {
        int n = CoefType.getTypeDistanceForHClust(string);
        this.setDistType(n);
    }

    String getTypeDistanceName() {
        return CoefType.getTypeDistanceKey2NameForHClust(this.getDistType());
    }

    private String getProfileName() {
        if (this.isPattern()) {
            return "Phylogenetic pattern";
        }
        return NAME_PROPERTY;
    }

    private String getExecEnvName() {
        if (this.isLocal()) {
            return "local";
        }
        return "server";
    }

    private String getClusterModeName() {
        if (this.isModeCluster()) {
            return "Cluster";
        }
        return "Sub Cluster";
    }

    public boolean isTargetFilteredClusterList() {
        return this.targetFilteredClusterList;
    }

    void setTargetFilteredClusterList(boolean bl) {
        this.targetFilteredClusterList = bl;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean bl) {
        this.useCache = bl;
    }

    @Override
    public Map createDisplayOptionMap() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put(NAME_NAME, this.getLabel());
        linkedHashMap.put(NAME_EXECUTE, this.getExecEnvName());
        linkedHashMap.put(NAME_TARGET, this.getClusterModeName());
        linkedHashMap.put(NAME_MIN_EXIST, new Double(this.getMinExist()));
        linkedHashMap.put(NAME_CUTOFF, new Double(this.getCutoff()));
        linkedHashMap.put(NAME_MISS_DIST_RATIO, new Double(this.getMissDistRatio()));
        linkedHashMap.put(NAME_PROBCUT, new Double(this.getProbabilityCutoff()));
        linkedHashMap.put(NAME_PROFILE, this.getProfileName());
        if (this.isGeneProperty()) {
            linkedHashMap.put(NAME_PROPERTY, this.getInfoTitle().getName());
        }
        linkedHashMap.put(NAME_DISTTYPE, this.getTypeDistanceName());
        return linkedHashMap;
    }

    public boolean isDoCompress() {
        return this.doCompress;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isRestruct() {
        return this.restruct;
    }

    public void setRestruct(boolean bl) {
        this.restruct = bl;
    }

    public String getQuery() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SRC_CLUST_TAB_ID=");
        stringBuffer.append(this.getDomClustId());
        stringBuffer.append("&min_exist=");
        stringBuffer.append(this.getMinExist());
        stringBuffer.append("&cutoff=");
        stringBuffer.append(this.getCutoff());
        stringBuffer.append("&missdist_ratio=");
        stringBuffer.append(this.getMissDistRatio());
        stringBuffer.append("&mode_cluster=");
        stringBuffer.append(this.getModeCluster());
        stringBuffer.append("&probcut=");
        stringBuffer.append(this.getProbabilityCutoff());
        stringBuffer.append("&disttype=");
        stringBuffer.append(this.getTypeDistance());
        if (this.isGeneProperty()) {
            stringBuffer.append("&property=");
            stringBuffer.append(this.getInfoTitle().getKey());
            stringBuffer.append("&property_class=");
            stringBuffer.append(this.getInfoTitle().getCls());
        }
        return stringBuffer.toString();
    }

    public String getQueryHash() {
        return HClustCondition.getQueryHash(this.getQuery(), this.getExecServer(), this.getExecPort(), this.isLocal(), this.isTargetFilteredClusterList());
    }

    public static String getQueryHash(String string, String string2, int n, boolean bl, boolean bl2) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(n);
            if (bl) {
                stringBuffer.append(bl2);
            }
            return Digest.createMD5Hash(stringBuffer.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.warn("Fail to create phylopad query hash.", noSuchAlgorithmException);
            return null;
        }
    }

    @Override
    public String getLabel() {
        return "Phylogenetic pattern clustering (PhyloPatClust)";
    }

    @Override
    public boolean containsInfo(AbstractInfoTitle abstractInfoTitle) {
        return false;
    }

    @Override
    public boolean equalsSortCondition(SortCondition sortCondition) {
        if (sortCondition == null || sortCondition instanceof HClustCondition) {
            return false;
        }
        HClustCondition hClustCondition = (HClustCondition)sortCondition;
        return this.getDomClustId().equals(hClustCondition.getDomClustId()) && this.getMinExist() == hClustCondition.getMinExist() && this.getCutoff() == hClustCondition.getCutoff() && this.getMissDistRatio() == hClustCondition.getMissDistRatio() && this.getProbabilityCutoff() == hClustCondition.getProbabilityCutoff() && this.getTypeDistance().equals(hClustCondition.getTypeDistance()) && this.getModeCluster().equals(hClustCondition.getModeCluster()) && this.getExecEnv() == hClustCondition.getExecEnv();
    }

    @Override
    public int getHashCode() {
        int n = 1;
        n = n * 31 + this.getDomClustId().hashCode();
        n = n * 31 + new Integer(this.getMinExist()).hashCode();
        n = n * 31 + new Double(this.getCutoff()).hashCode();
        n = n * 31 + new Double(this.getMissDistRatio()).hashCode();
        n = n * 31 + new Double(this.getProbabilityCutoff()).hashCode();
        n = n * 31 + new Integer(this.getTypeDistance()).hashCode();
        n = n * 31 + this.getModeCluster().hashCode();
        n = n * 31 + new Integer(this.getExecEnv()).hashCode();
        return n;
    }

    @Override
    public int indexOfElement(Object object) {
        if (this.isGeneProperty()) {
            return this.getInfoTitle().indexOfElement(object);
        }
        return 0;
    }

    @Override
    public boolean isAsc() {
        return true;
    }

    @Override
    public ClusterInfoCalcCondition getClusterInfoCalcCondition() {
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = SortConditionFactory.createTemplatePhpatCondition(this.getInoutType());
        return geneInfoSortConditionGroup.getClusterInfoCalcCondition();
    }

    @Override
    public List getGeneInfoSortConditionList() {
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = SortConditionFactory.createTemplatePhpatCondition(this.getInoutType());
        return geneInfoSortConditionGroup.getGeneInfoSortConditionList();
    }

    @Override
    public String getOrganismCode() {
        return null;
    }

    @Override
    public List getSortKeyList() {
        GeneInfoSortConditionGroup geneInfoSortConditionGroup = SortConditionFactory.createTemplatePhpatCondition(this.getInoutType());
        return geneInfoSortConditionGroup.getSortKeyList();
    }

    @Override
    public boolean isNeededLoadCellInfo() {
        return false;
    }

    @Override
    public boolean isNeededLoadClusterInfo() {
        return true;
    }

    @Override
    public boolean isNeededLoadGeneInfo() {
        return false;
    }

    @Override
    public int getSortType() {
        return 6;
    }

    @Override
    public String getSortName() {
        return "Phylogenetic pattern clustering (PhyloPatClust)";
    }

    @Override
    public String getCategory() {
        return "HClust";
    }

    @Override
    public List getPropertyList(Project project, String string) {
        ArrayList<ApplicationProperty> arrayList = new ArrayList<ApplicationProperty>();
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustExecEnv", String.valueOf(this.getExecEnv())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustClusterMode", String.valueOf(this.getInoutType())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustMinExist", String.valueOf(this.getMinExist())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustCutOff", String.valueOf(this.getCutoff())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustMissDistRatio", String.valueOf(this.getMissDistRatio())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustProbCutOff", String.valueOf(this.getProbabilityCutoff())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustProfile", String.valueOf(this.getProfile())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustDist", String.valueOf(this.getDistType())));
        AbstractInfoTitle abstractInfoTitle = this.getInfoTitle();
        if (abstractInfoTitle != null) {
            arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustInfoTitleKey", abstractInfoTitle.getKey()));
            arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustInfoCls", String.valueOf(abstractInfoTitle.getCls())));
        }
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustFilterClusterOnly", String.valueOf(this.isTargetFilteredClusterList())));
        arrayList.add(ApplicationProperty.createProjectProperty(this.getCategory(), "HClustUseCache", String.valueOf(this.isUseCache())));
        return arrayList;
    }

    @Override
    public int getPropertyType() {
        return 2;
    }

    @Override
    public void updateProperty(Map map, Project project, String string) {
        String string2;
        if (map.containsKey("HClustExecEnv")) {
            try {
                string2 = (String)map.get("HClustExecEnv");
                this.setExecEnv(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("HClustClusterMode")) {
            try {
                string2 = (String)map.get("HClustClusterMode");
                int n = Integer.parseInt(string2);
                if (ClusterMode.isBaseCluster(n)) {
                    this.setModeCluster();
                } else {
                    this.setModeSubCluster();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("HClustMinExist")) {
            try {
                string2 = (String)map.get("HClustMinExist");
                this.setMinExist(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("HClustCutOff")) {
            try {
                string2 = (String)map.get("HClustCutOff");
                this.setCutoff(Double.parseDouble(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("HClustMissDistRatio")) {
            try {
                string2 = (String)map.get("HClustMissDistRatio");
                this.setMissDistRatio(Double.parseDouble(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("HClustProbCutOff")) {
            try {
                string2 = (String)map.get("HClustProbCutOff");
                this.setProbabilityCutoff(Double.parseDouble(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("HClustProfile")) {
            try {
                string2 = (String)map.get("HClustProfile");
                this.setProfile(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("HClustDist")) {
            try {
                string2 = (String)map.get("HClustDist");
                this.setDistType(Integer.parseInt(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("HClustInfoTitleKey") && map.containsKey("HClustInfoCls") && this.isGeneProperty()) {
            try {
                string2 = (String)map.get("HClustInfoTitleKey");
                String string3 = (String)map.get("HClustInfoCls");
                int n = Integer.parseInt(string3);
                AbstractInfoTitle abstractInfoTitle = null;
                if (InfoClass.isGene(n)) {
                    abstractInfoTitle = GeneInfoFacade.getGeneInfoTitle(string2);
                } else if (InfoClass.isCell(n)) {
                    abstractInfoTitle = CellInfoFacade.getCellInfoTitle(string2);
                }
                if (abstractInfoTitle != null) {
                    this.setInfoTitle(abstractInfoTitle);
                }
            }
            catch (Exception exception) {
                this.setProfile(1);
            }
        }
        if (map.containsKey("HClustFilterClusterOnly")) {
            try {
                string2 = (String)map.get("HClustFilterClusterOnly");
                this.setTargetFilteredClusterList(new Boolean(string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("HClustUseCache")) {
            string2 = (String)map.get("HClustUseCache");
            this.setUseCache(new Boolean(string2));
        }
    }
}

