/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.HClustExecutable;
import cgdp.recog.hcluster.HClustFileSearchExecuter;
import cgdp.recog.hcluster.LocalHClustExecuter;
import cgdp.recog.hcluster.NewHClustImporter;
import cgdp.recog.hcluster.OldHClustImporter;
import cgdp.recog.hcluster.ServerHClustExecuter;
import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.cluster.ClusterInfoType;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.sort.SortConditionFactory;
import cgdp.recog.tree.NodeUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.StringTool;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HClustExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(HClustExecuter.class);
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private HClustCondition condition;
    private boolean existResult = false;

    public HClustExecuter(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, HClustCondition hClustCondition) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.condition = hClustCondition;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        try {
            Object object3;
            Object object2;
            String string = null;
            if (this.condition.isUseCache() && !this.clusterTbl.isExistModifiedCluster()) {
                object2 = new HClustFileSearchExecuter(this.condition);
                ((HClustFileSearchExecuter)object2).execute(new DummyProgressComponent());
                string = ((HClustFileSearchExecuter)object2).getFilepath();
            }
            if (StringTool.isNull(string)) {
                object2 = this.createHClustExecutable();
                object2.setProgressImpl(progressImpl);
                object2.execute();
                if (progressImpl != null && progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                if (!object2.isExistResult()) {
                    this.existResult = false;
                    return;
                }
                this.existResult = true;
                if (object2.isError()) {
                    this.setError(true);
                    this.setErrorMessage(object2.getMessage());
                    return;
                }
                string = object2.getFilepath();
            } else {
                this.existResult = true;
                if (this.condition.isLocal()) {
                    progressImpl.nextProc();
                    progressImpl.increment();
                }
            }
            progressImpl.nextProc();
            progressImpl.setTotal(4);
            progressImpl.setCount(-1);
            progressImpl.increment();
            if (this.condition.isServer()) {
                object2 = new OldHClustImporter(string);
                object2.execute();
                ((OldHClustImporter)object2).aggregateSamePattern(this.clusterTbl, this.condition);
            } else {
                object2 = new NewHClustImporter(string);
                object2.execute();
            }
            progressImpl.increment();
            Map map = this.createPatternMapMap();
            for (Object object3 : object2.getLeafNodeList()) {
                String string2 = (String)((ClusterNode)object3).getClusterIdSet().iterator().next();
                ((ClusterNode)object3).setPatternMap(this.getPatternMap(string2, map));
            }
            progressImpl.increment();
            ClusterInfoTitle clusterInfoTitle = (ClusterInfoTitle)SortConditionFactory.getPhpatOrderTitle(this.condition.getInoutType());
            object3 = this.createPhpatGroupMap(object2.getLeafNodeList());
            progressImpl.increment();
            ClusterInfoFacade.addClusterInfo((Map)object3, clusterInfoTitle, clusterInfoTitle.getInfoType());
            this.clusterTbl.setHClustResult(object2.getRootNodeList(), this.condition, (Map)object3);
            this.clusterTbl.updateForHClust();
            progressImpl.increment();
            progressImpl.setEnabledCancelButton(false);
            this.mediator.updateForPhylopat();
        }
        catch (Exception exception) {
            String string = "Fail to execute phylopat clustering.";
            this.setError(true);
            this.setErrorMessage(string);
            logger.warn(string, exception);
        }
    }

    private Map createPatternMapMap() {
        List list = this.clusterTbl.getClusterList();
        if (this.condition.isModeCluster()) {
            list = ClusterTbl.createSuperClusterListByCluster(list);
        }
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        for (Cluster cluster : list) {
            Map map = cluster.getPatternMap();
            if (this.condition.isModeCluster()) {
                hashMap.put(String.valueOf(cluster.getClusterId()), map);
                continue;
            }
            hashMap.put(cluster.getConbinedClusterId("_"), map);
        }
        return hashMap;
    }

    private Map getPatternMap(String string, Map map) {
        return (Map)map.get(string);
    }

    private HClustExecutable createHClustExecutable() {
        HClustExecutable hClustExecutable = null;
        hClustExecutable = this.condition.isServer() ? new ServerHClustExecuter(this.clusterTbl, this.condition) : new LocalHClustExecuter(this.condition, this.clusterTbl.getViewOrganismCodeList(), this.clusterTbl);
        return hClustExecutable;
    }

    private Map createPhpatGroupMap(List list) {
        HashMap<String, ClusterInfo> hashMap = new HashMap<String, ClusterInfo>();
        int n = 0;
        ClusterInfoTitle clusterInfoTitle = (ClusterInfoTitle)SortConditionFactory.getPhpatOrderTitle(this.condition.getInoutType());
        for (ClusterNode clusterNode : list) {
            for (String string : clusterNode.getClusterIdSet()) {
                if (ClusterInfoType.isSubCluster(clusterInfoTitle.getInfoType())) {
                    string = string.replaceFirst("_", ".");
                }
                ClusterInfo clusterInfo = new ClusterInfo();
                clusterInfo.putInfo(clusterInfoTitle, new Double(n));
                hashMap.put(string, clusterInfo);
            }
            ++n;
        }
        return hashMap;
    }

    public List getResultViewOrderList(List list) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        List list2 = NodeUtil.getLeafNodeList(list);
        for (ClusterNode clusterNode : list2) {
            Map map = clusterNode.getPatternMap();
            arrayList.add(map);
        }
        return arrayList;
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            MessageManager.showMessage(this.parent, "PhyloPatClust is canceled.");
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!this.isExistResult()) {
            MessageManager.showMessage(this.parent, "No cluster created by PhyloPatClust.");
            return;
        }
    }

    public void setExistResult(boolean bl) {
        this.existResult = bl;
    }

    public boolean isExistResult() {
        return this.existResult;
    }
}

