/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.HClustUtil;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.StringTool;
import java.io.File;

class HClustFileSearchExecuter
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(HClustFileSearchExecuter.class);
    private HClustCondition hClustCondition;
    private String filepath;

    HClustFileSearchExecuter(HClustCondition hClustCondition) {
        this.hClustCondition = hClustCondition;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        Project project = ProjectAccesser.getSelectedProject();
        File file = new File(project.getDirectoryPath());
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(FileFilterFactory.createPhpatIOFileFilter());
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        String string = this.hClustCondition.getQueryHash();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            try {
                String string2 = HClustUtil.getQueryHash(file2.getAbsolutePath());
                if (StringTool.isNull(string2) || HClustUtil.isForModifiedCluster(file2.getAbsolutePath()) || !string2.equals(string)) continue;
                this.filepath = file2.getAbsolutePath();
                break;
            }
            catch (Exception exception) {
                logger.warn("Fail to load phylogenetic pattern clustering's result file. " + file2.getAbsolutePath(), exception);
            }
        }
    }

    public String getFilepath() {
        return this.filepath;
    }

    @Override
    public void done() {
    }
}

