/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.hcluster.HClustAdjuster;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.tree.ClusterNode;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.patch.ClusterInfoConfModPatch2;
import cgdp.recog.tree.NodeUtil;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HClustResult {
    private static final ApplicationLogger logger = new ApplicationLogger(HClustResult.class);
    private List rootNodeList = new ArrayList();
    private List viewRootNodeList = new ArrayList();
    private List orderListByUpgma = new ArrayList();
    private Map phpatGroupMap = new HashMap();
    private HClustCondition hclustCondition = new HClustCondition();
    private List viewRootNodeList4release = new ArrayList();

    public void setResult(List list, HClustCondition hClustCondition, Map map, ClusterTbl clusterTbl) {
        this.rootNodeList = list;
        this.hclustCondition = hClustCondition;
        this.phpatGroupMap = map;
        this.updateResult(clusterTbl);
    }

    public void updateResult(ClusterTbl clusterTbl) {
        this.viewRootNodeList = this.filterRootNode(clusterTbl);
        this.orderListByUpgma = this.getResultViewOrderList(this.viewRootNodeList);
    }

    private List filterRootNode(ClusterTbl clusterTbl) {
        HClustAdjuster hClustAdjuster = new HClustAdjuster(this.getUpgmaCondition(), clusterTbl, this.getRootNodeList());
        hClustAdjuster.execute();
        return hClustAdjuster.getResultRootNodeList();
    }

    public boolean isExistResult() {
        return !CollectionUtil.isNull(this.rootNodeList);
    }

    public boolean isExistMergedResult() {
        return !CollectionUtil.isNull(this.viewRootNodeList4release);
    }

    public void clear() {
        this.clearMergedRootNodeList();
        this.rootNodeList.clear();
        this.orderListByUpgma.clear();
        this.viewRootNodeList.clear();
        this.hclustCondition = new HClustCondition();
        try {
            ClusterInfoFacade.removeClusterInfo(ClusterInfoFacade.getInfoTitle("SCPhpatOrder"));
        }
        catch (Exception exception) {
            logger.warn("Fail to clear cluster property cache. SCPhpatOrder", exception);
            ClusterInfoConfModPatch2 clusterInfoConfModPatch2 = new ClusterInfoConfModPatch2();
            clusterInfoConfModPatch2.execute();
        }
    }

    public List getRootNodeList() {
        return this.rootNodeList;
    }

    public void setRootNodeList(List list) {
        this.rootNodeList = list;
    }

    public List getOrderListByUpgma() {
        return this.orderListByUpgma;
    }

    public List getOrderListWithoutDuplicate() {
        List list = this.getOrderListByUpgma();
        ArrayList<Map> arrayList = new ArrayList<Map>();
        for (Map map : list) {
            if (arrayList.contains(map)) continue;
            arrayList.add(map);
        }
        return arrayList;
    }

    public void setOrderListByUpgma(List list) {
        this.orderListByUpgma = list;
    }

    public HClustCondition getUpgmaCondition() {
        return this.hclustCondition;
    }

    public void setUpgmaCondition(HClustCondition hClustCondition) {
        this.hclustCondition = hClustCondition;
    }

    public List getViewRootNodeList() {
        return this.viewRootNodeList;
    }

    private List getResultViewOrderList(List list) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        List list2 = NodeUtil.getLeafNodeList(list);
        for (ClusterNode clusterNode : list2) {
            arrayList.add(clusterNode.getPatternMap());
        }
        return arrayList;
    }

    public Map getPhpatGroupMap() {
        return this.phpatGroupMap;
    }

    public HClustCondition getHclustCondition() {
        return this.hclustCondition;
    }

    public double getMaxDist() {
        double d = NodeUtil.calcMaxDist(this.rootNodeList);
        return d;
    }

    public void setMergedRootNodeList(List list) {
        this.viewRootNodeList4release = this.viewRootNodeList;
        this.viewRootNodeList = list;
    }

    public void clearMergedRootNodeList() {
        if (this.isExistMergedResult()) {
            this.viewRootNodeList = HClustAdjuster.createCopyRootNodeList(this.viewRootNodeList4release);
            this.viewRootNodeList4release.clear();
        }
    }
}

