/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.process.CommandImpl;
import cgdp.recog.util.JLicenserTool;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class HClustTool
extends JButton
implements CommandImpl {
    private MediatorImpl mediator;
    private int clusterMode = -1;

    public HClustTool(ActionListener actionListener, MediatorImpl mediatorImpl) {
        this(actionListener, mediatorImpl, -1);
    }

    public HClustTool(ActionListener actionListener, MediatorImpl mediatorImpl, int n) {
        this.setToolTipText("Phylogenetic pattern clustering (PhyloPatClust)");
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setEnabled(false);
        try {
            this.setIcon(new ImageIcon(JLicenserTool.getResource("cgdp.recog.startup.Startup", "images/phylopat.png")));
        }
        catch (Exception exception) {
            this.setText("0");
        }
        this.clusterMode = n;
        this.addActionListener(actionListener);
        this.mediator = mediatorImpl;
        this.mediator.register(this);
    }

    @Override
    public void execute() {
        int n = this.clusterMode;
        if (n == -1) {
            n = ClusterMode.getClusterMode();
        }
        this.mediator.upgma(n);
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return new Point(mouseEvent.getX(), this.getSize().height);
    }
}

