/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.filefilter.FileFilterFactory;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.HClustFilenameFilter;
import cgdp.recog.hcluster.NewHClustImporter;
import cgdp.recog.hcluster.OldHClustImporter;
import cgdp.recog.project.Project;
import cgdp.recog.project.ProjectAccesser;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class HClustUtil {
    private static final ApplicationLogger logger = new ApplicationLogger(HClustUtil.class);

    public static String getHClustFilepath(String string, String string2) {
        String string3 = HClustUtil.getOriginalHClustFilepath(string);
        if (!StringTool.isNull(string3)) {
            return string3;
        }
        Set set = HClustUtil.getHClustFilenameSet();
        String string4 = ProjectAccesser.getProjectDirpath();
        String string5 = "";
        String string6 = "";
        int n = 0;
        while (true) {
            string5 = string2;
            if (!string6.equals("")) {
                string5 = string5 + "_" + string6;
            }
            if (!set.contains(string5)) break;
            string6 = String.valueOf(++n);
        }
        return string4 + File.separator + string5 + ".phpat";
    }

    private static Set getHClustFilenameSet() {
        File file = ProjectAccesser.getProjectDir();
        File[] fileArray = file.listFiles(new HClustFilenameFilter());
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            hashSet.add(FileUtil.removeExtension(fileArray[i].getName()));
        }
        return hashSet;
    }

    private static String getOriginalHClustFilepath(String string) {
        File file = ProjectAccesser.getProjectDir();
        File[] fileArray = file.listFiles(new HClustFilenameFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                OldHClustImporter oldHClustImporter = new OldHClustImporter(fileArray[i].getAbsolutePath());
                oldHClustImporter.setParameterOnly(true);
                oldHClustImporter.execute();
                String string2 = oldHClustImporter.getPhpatId();
                if (StringTool.isNull(string2) || !string2.equals(string)) continue;
                return fileArray[i].getAbsolutePath();
            }
            catch (IOException iOException) {
                logger.warn("Fail to read the plylopat file. " + fileArray[i].getAbsolutePath(), iOException);
            }
        }
        return null;
    }

    public static String getQueryHash(String string) throws Exception {
        NewHClustImporter newHClustImporter = new NewHClustImporter(string);
        newHClustImporter.setParameterOnly(true);
        newHClustImporter.execute();
        if (!newHClustImporter.getVersion().equals("3")) {
            return null;
        }
        String string2 = newHClustImporter.getQuery();
        String string3 = newHClustImporter.getExecServer();
        boolean bl = HClustCondition.isLocal(string3);
        int n = newHClustImporter.getExecPort();
        boolean bl2 = false;
        if (bl) {
            bl2 = newHClustImporter.isTargetFilteredClusterList();
        }
        return HClustCondition.getQueryHash(string2, string3, n, bl, bl2);
    }

    public static boolean isForModifiedCluster(String string) throws Exception {
        NewHClustImporter newHClustImporter = new NewHClustImporter(string);
        newHClustImporter.setParameterOnly(true);
        newHClustImporter.execute();
        if (!newHClustImporter.getVersion().equals("3")) {
            return false;
        }
        return newHClustImporter.isForModifiedCluster();
    }

    public static int deleteFilesByClusterId(Project project, String string) {
        File file = new File(project.getDirectoryPath());
        File[] fileArray = file.listFiles(FileFilterFactory.createPhpatIOFileFilter());
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (string != null && !HClustUtil.hasDomClustId(fileArray[i].getAbsolutePath(), string)) continue;
                if (!fileArray[i].delete()) {
                    logger.warn("Failed to delete a phpat file " + fileArray[i].getAbsolutePath());
                    continue;
                }
                logger.info("A phpat file is deleted. " + fileArray[i].getAbsolutePath());
                ++n;
                continue;
            }
            catch (Exception exception) {
                logger.fatal("Failed to load phylogenetic pattern analysis file " + fileArray[i].getAbsolutePath());
            }
        }
        return n;
    }

    public static int deleteFilesByViewId(Project project, String string, String string2) {
        File file = new File(project.getDirectoryPath());
        File[] fileArray = file.listFiles(FileFilterFactory.createPhpatIOFileFilter());
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                if (!HClustUtil.hasDomClustViewId(fileArray[i].getAbsolutePath(), string, string2)) continue;
                if (!fileArray[i].delete()) {
                    logger.warn("Failed to delete a phpat file " + fileArray[i].getAbsolutePath());
                    continue;
                }
                logger.info("A phpat file is deleted. " + fileArray[i].getAbsolutePath());
                ++n;
                continue;
            }
            catch (Exception exception) {
                logger.fatal("Failed to load phylogenetic pattern analysis file " + fileArray[i].getAbsolutePath());
            }
        }
        return n;
    }

    public static boolean hasDomClustViewId(String string, String string2, String string3) throws IOException {
        NewHClustImporter newHClustImporter = new NewHClustImporter(string);
        newHClustImporter.setParameterOnly(true);
        newHClustImporter.execute();
        String string4 = newHClustImporter.getDomClustId();
        if (string4 == null || string4.compareTo(string2) != 0) {
            return false;
        }
        string4 = newHClustImporter.getClusterViewId();
        return string4 != null && string4.compareTo(string3) == 0;
    }

    private static boolean hasDomClustId(String string, String string2) throws IOException {
        NewHClustImporter newHClustImporter = new NewHClustImporter(string);
        newHClustImporter.setParameterOnly(true);
        newHClustImporter.execute();
        String string3 = newHClustImporter.getDomClustId();
        return string3 != null && string3.compareTo(string2) == 0;
    }
}

