/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.data.SuperCluster;
import cgdp.recog.hcluster.ClusterNode;
import cgdp.recog.hcluster.ClusterTree;
import cgdp.recog.hcluster.DistMatrix;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.HClustException;
import cgdp.recog.hcluster.HClustExecutable;
import cgdp.recog.hcluster.HClustUtil;
import cgdp.recog.hcluster.Hcluster;
import cgdp.recog.option.ClusterMode;
import cgdp.recog.pattern.PatternFactory;
import cgdp.recog.pattern.PatternUtil;
import cgdp.recog.process.DummyProgressComponent;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.propvect.CompressedPropVectArray;
import cgdp.recog.propvect.NumVect;
import cgdp.recog.propvect.PhyloPat;
import cgdp.recog.propvect.PropVect;
import cgdp.recog.propvect.PropVectArray;
import cgdp.recog.propvect.PropVectFacade;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.CollectionUtil;
import cgdp.recog.util.DateUtil;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.ServerStatus;
import cgdp.recog.util.StringTool;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalHClustExecuter
implements HClustExecutable {
    private static final ApplicationLogger logger = new ApplicationLogger(LocalHClustExecuter.class);
    private static final String DELIMTER_ID_PATTERN = ":";
    private static final String DELIMTER_PATTERN_ELEMENT = "\t";
    private static final String DELIMTER_ELEMENTS = ",";
    private static final String DELIMTER_TREE_LIST = "===";
    private HClustCondition condition;
    private List organismCodeList;
    private ClusterTbl clusterTbl;
    private boolean error = false;
    private String message;
    private boolean existResult = true;
    private String filepath;
    private ProgressImpl progressImpl = new DummyProgressComponent();

    public LocalHClustExecuter(HClustCondition hClustCondition, List list, ClusterTbl clusterTbl) {
        this.condition = hClustCondition;
        this.organismCodeList = list;
        this.clusterTbl = clusterTbl;
    }

    @Override
    public String getFilepath() {
        return this.filepath;
    }

    private void setFilepath(String string) {
        this.filepath = string;
    }

    private String createUpgmaId() {
        return this.condition.getQueryHash();
    }

    @Override
    public void execute() {
        try {
            Object object;
            Object object2;
            Object object32;
            List list;
            int n = this.clusterTbl.getViewOrganismCount();
            this.progressImpl.setTotal(n);
            ClusterNode.clear();
            if (this.condition.isTargetFilteredClusterList()) {
                this.condition.setRestruct(false);
                list = new ArrayList(this.clusterTbl.getViewClusterList());
            } else {
                list = new ArrayList(this.clusterTbl.getClusterList());
            }
            if (ClusterMode.isBaseCluster(this.condition.getInoutType())) {
                list = ClusterTbl.createSuperClusterListByCluster(list);
            }
            List list2 = this.filterByMinExist(list);
            list.removeAll(list2);
            ArrayList arrayList = new ArrayList(list);
            for (Object object32 : this.organismCodeList) {
                this.condition.loadInfo((String)object32, list2);
                if (this.progressImpl.isCanceled()) {
                    return;
                }
                this.progressImpl.increment();
            }
            if (this.condition.isGeneProperty()) {
                object32 = this.getNoPropertyClusterList(list2);
                arrayList.addAll(object32);
                list2.removeAll((Collection<?>)object32);
                object2 = PropVectFacade.createNumVectArray(this.condition, this.organismCodeList, list2);
                object = null;
                if (this.condition.isDoCompress()) {
                    object = ((PropVectArray)object2).doCompress();
                }
            } else {
                object = PropVectFacade.createPropVectArray(this.organismCodeList, list2);
                if (this.condition.isDoCompress()) {
                    object = ((PropVectArray)object).doCompress();
                }
            }
            this.progressImpl.nextProc();
            this.progressImpl.setTotal(((PropVectArray)object).size() + 4);
            this.progressImpl.setCount(-1);
            this.progressImpl.increment();
            object32 = new DistMatrix();
            ((PropVectArray)object).compareAll(this.condition.getTypeDistanceForHClust(), this.condition.getCutoff(), this.condition.getProbabilityCutoff(), (DistMatrix)object32, false, this.progressImpl);
            if (this.progressImpl.isCanceled()) {
                return;
            }
            this.progressImpl.increment();
            ClusterNode.saveLeafNum();
            ((DistMatrix)object32).createIndex(this.condition.getScale());
            object2 = new Hcluster((DistMatrix)object32, this.condition.getCutoff(), this.condition.calcMissDist());
            ((Hcluster)object2).execute();
            this.progressImpl.increment();
            Map map = PropVectFacade.createEquivMap((CompressedPropVectArray)object);
            Set set = this.getCalcedClusterSet(map, list2);
            ArrayList arrayList2 = new ArrayList(list2);
            arrayList2.removeAll(set);
            arrayList.addAll(arrayList2);
            this.progressImpl.increment();
            Map map2 = ClusterUtil.getPatternMap(arrayList);
            int n2 = this.getRootNodeIncludeClusterNode();
            int n3 = n2 + map2.size();
            if (n2 == 0) {
                this.setExistResult(false);
            } else {
                this.setExistResult(true);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ServerStatus.createFormatVarMessage("3"));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(ServerStatus.createClusterIdMessage(this.createPhpatID()));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(ServerStatus.createDomClustIdMessage(this.clusterTbl.getClusterId()));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(ServerStatus.createSpeciesMessage(this.clusterTbl.getViewOrganismCodeList()));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(ServerStatus.createNClusters(n3));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(ServerStatus.createExecServer("Local"));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(ServerStatus.createExecPort(0));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(ServerStatus.createExecDate(DateUtil.formatServerDate(new Date())));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(ServerStatus.createQuery(this.condition.getQuery()));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                if (this.clusterTbl.isExistModifiedCluster()) {
                    stringBuffer.append(ServerStatus.createModifiedCluster());
                    stringBuffer.append(FileUtil.LINE_SEPARETOR);
                }
                stringBuffer.append(ServerStatus.createClusterViewIdMessage(this.clusterTbl.getClusterViewId()));
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(ServerStatus.createStartData());
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(this.outputClusterTree());
                if (!CollectionUtil.isNull(arrayList)) {
                    this.outputClusterTree(stringBuffer, map2, n2);
                }
                stringBuffer.append(DELIMTER_TREE_LIST);
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer.append(this.outputClusterList(map, list2));
                if (!CollectionUtil.isNull(arrayList)) {
                    this.outputClusterList(stringBuffer, map2);
                }
                String string = HClustUtil.getHClustFilepath(this.createUpgmaId(), this.condition.getDomClustName());
                FileUtil.outputFile(stringBuffer.toString(), string);
                this.setFilepath(string);
            }
            this.progressImpl.increment();
        }
        catch (IOException iOException) {
            String string = "Fail to save the phylogenetic pattern clusering result.";
            this.setError(true);
            this.setMessage(string);
            logger.warn(string, iOException);
        }
        catch (HClustException hClustException) {
            this.setError(true);
            this.setMessage(hClustException.getMessage());
            logger.warn(hClustException.getMessage(), hClustException);
        }
        catch (Exception exception) {
            String string = "Fail to execute phylogenetic pattern clusering result.";
            this.setError(true);
            this.setMessage(string);
            logger.warn(string, exception);
        }
    }

    private List getNoPropertyClusterList(List list) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : list) {
            if (PatternFactory.isExistProperty(this.organismCodeList, cluster, this.condition)) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    private String createPhpatID() {
        long l = System.currentTimeMillis();
        return this.clusterTbl.getClusterId() + "_" + l;
    }

    public void outputClusterTree(StringBuffer stringBuffer, Map map, int n) {
        for (Map map2 : map.keySet()) {
            List list = (List)map.get(map2);
            Cluster cluster = (Cluster)list.get(0);
            String string = "N" + this.getClusterId(cluster);
            stringBuffer.append("UPGMA\t" + ++n);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            stringBuffer.append(string);
            stringBuffer.append(";");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
    }

    public void outputClusterList(StringBuffer stringBuffer, Map map) {
        for (Map map2 : map.keySet()) {
            List list = (List)map.get(map2);
            Cluster cluster = (Cluster)list.get(0);
            String string = "N" + this.getClusterId(cluster);
            stringBuffer.append(string);
            stringBuffer.append(DELIMTER_ID_PATTERN);
            stringBuffer.append(PatternUtil.createPatternString(map2, this.organismCodeList));
            stringBuffer.append(DELIMTER_PATTERN_ELEMENT);
            stringBuffer.append(StringTool.conbineStrList(this.getClusterIdList(list), DELIMTER_ELEMENTS));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
    }

    private List getClusterIdList(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Cluster cluster : list) {
            arrayList.add(this.getClusterId(cluster));
        }
        return arrayList;
    }

    public void outputCluster(StringBuffer stringBuffer, List list, Map map) {
        stringBuffer.append(this.outputClusterTree());
        stringBuffer.append(DELIMTER_TREE_LIST);
        stringBuffer.append(FileUtil.LINE_SEPARETOR);
        stringBuffer.append(this.outputClusterList(map, list));
    }

    private int getRootNodeIncludeClusterNode() {
        int n = 0;
        for (int i = ClusterNode.totalNum() - 1; i >= 0; --i) {
            ClusterNode clusterNode = ClusterNode.get(i);
            if (!clusterNode.isRoot()) continue;
            ++n;
        }
        return n;
    }

    public String outputClusterTree() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = ClusterNode.totalNum() - 1; i >= 0; --i) {
            ClusterNode clusterNode = ClusterNode.get(i);
            if (!clusterNode.isRoot()) continue;
            stringBuffer.append("UPGMA\t" + ++n);
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
            StringBuffer stringBuffer2 = new StringBuffer();
            this.outputNewick_sub(clusterNode, -1.0, 3, stringBuffer, stringBuffer2);
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(";");
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    private String outputClusterList(Map map, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        for (Object e : arrayList) {
            List list2 = (List)map.get(e);
            if (CollectionUtil.isNull(list2)) continue;
            PropVect propVect = (PropVect)list2.get(0);
            String string = PropVectFacade.getPatternFromPropVect(propVect);
            stringBuffer.append(e.toString());
            stringBuffer.append(DELIMTER_ID_PATTERN);
            stringBuffer.append(string);
            stringBuffer.append(DELIMTER_PATTERN_ELEMENT);
            stringBuffer.append(this.getClusterIdStr(list2, list));
            stringBuffer.append(FileUtil.LINE_SEPARETOR);
        }
        return stringBuffer.toString();
    }

    private String getClusterIdStr(List list, List list2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        for (PropVect propVect : list) {
            ArrayList<Object> arrayList;
            int n = Integer.parseInt(propVect.getName());
            object = (Cluster)list2.get(n);
            if (object instanceof SuperCluster) {
                arrayList = ((SuperCluster)object).getSubClusterList();
            } else {
                arrayList = new ArrayList<Object>();
                arrayList.add(object);
            }
            for (Cluster cluster : arrayList) {
                hashSet.add(this.getClusterId(cluster));
            }
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuffer.append((String)object);
            if (n != list.size() - 1) {
                stringBuffer.append(DELIMTER_ELEMENTS);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static void outputTree_sub(ClusterNode clusterNode, int n, int n2, StringBuffer stringBuffer) {
        if (clusterNode.child == null) {
            System.out.println(stringBuffer + "+- " + clusterNode.name);
        } else {
            stringBuffer.setLength(n * 2);
            stringBuffer.append(n > 0 && n2 == -1 ? "| " : "  ");
            LocalHClustExecuter.outputTree_sub(clusterNode.child.node1, n + 1, 1, stringBuffer);
            stringBuffer.setLength(n * 2);
            DecimalFormat decimalFormat = new DecimalFormat(ClusterTree.formatString());
            System.out.println(stringBuffer + "+-| " + decimalFormat.format(clusterNode.child.dist));
            stringBuffer.append(n > 0 && n2 == 1 ? "| " : "  ");
            LocalHClustExecuter.outputTree_sub(clusterNode.child.node2, n + 1, -1, stringBuffer);
        }
    }

    private void outputNewick_sub(ClusterNode clusterNode, double d, int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        if (clusterNode.child == null) {
            stringBuffer2.append(clusterNode.name);
            if (n == 3 && !clusterNode.isRoot) {
                DecimalFormat decimalFormat = new DecimalFormat(ClusterTree.formatString());
                stringBuffer2.append(DELIMTER_ID_PATTERN + decimalFormat.format(d));
            }
        } else {
            double d2 = clusterNode.child.dist;
            stringBuffer2.append("(");
            this.outputNewick_sub(clusterNode.child.node1, d2, n, stringBuffer, stringBuffer2);
            if (stringBuffer2.length() > 80) {
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer2.delete(0, stringBuffer2.length());
            }
            stringBuffer2.append(DELIMTER_ELEMENTS);
            this.outputNewick_sub(clusterNode.child.node2, d2, n, stringBuffer, stringBuffer2);
            stringBuffer2.append(")");
            if (n == 3 && !clusterNode.isRoot) {
                double d3 = d - d2;
                DecimalFormat decimalFormat = new DecimalFormat(ClusterTree.formatString());
                stringBuffer2.append(DELIMTER_ID_PATTERN + decimalFormat.format(d3));
            }
            if (stringBuffer2.length() > 80) {
                stringBuffer.append(stringBuffer2);
                stringBuffer.append(FileUtil.LINE_SEPARETOR);
                stringBuffer2.delete(0, stringBuffer2.length());
            }
        }
    }

    private String getClusterId(Cluster cluster) {
        if (this.condition.isModeCluster()) {
            return String.valueOf(cluster.getClusterId());
        }
        return cluster.getConbinedClusterId("_");
    }

    private List getTargetClusterList() {
        List list;
        if (this.condition.isTargetFilteredClusterList()) {
            this.condition.setRestruct(false);
            list = this.clusterTbl.getViewClusterList();
        } else {
            list = this.clusterTbl.getClusterList();
        }
        List list2 = ClusterMode.isBaseCluster(this.condition.getInoutType()) ? ClusterTbl.createSuperClusterListByCluster(list) : list;
        return list2;
    }

    private List filterByMinExist(List list) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Cluster cluster : list) {
            if (cluster.getSpCount() >= this.condition.getMinExist()) {
                arrayList.add(cluster);
                continue;
            }
            this.condition.setRestruct(false);
        }
        return arrayList;
    }

    private Set getCalcedClusterSet(Map map, List list) {
        Set set = this.getLeafNodeNameSet();
        HashSet<Cluster> hashSet = new HashSet<Cluster>();
        for (String string : set) {
            List list2 = (List)map.get(string);
            for (PropVect propVect : list2) {
                Cluster cluster;
                if (propVect instanceof PhyloPat) {
                    cluster = (Cluster)list.get(Integer.parseInt(((PhyloPat)propVect).getName()));
                    hashSet.add(cluster);
                    continue;
                }
                if (!(propVect instanceof NumVect)) continue;
                cluster = (Cluster)list.get(Integer.parseInt(((NumVect)propVect).getName()));
                hashSet.add(cluster);
            }
        }
        return hashSet;
    }

    private Set getLeafNodeNameSet() {
        HashSet hashSet = new HashSet();
        for (int i = ClusterNode.totalNum() - 1; i >= 0; --i) {
            ClusterNode clusterNode = ClusterNode.get(i);
            if (!clusterNode.isRoot()) continue;
            this.getLeafNodeNameSetCore(clusterNode, hashSet);
        }
        return hashSet;
    }

    private void getLeafNodeNameSetCore(ClusterNode clusterNode, Set set) {
        if (clusterNode.child == null) {
            set.add(clusterNode.name);
        } else {
            this.getLeafNodeNameSetCore(clusterNode.child.node1, set);
            this.getLeafNodeNameSetCore(clusterNode.child.node2, set);
        }
    }

    @Override
    public String getErrorCode() {
        return "None";
    }

    @Override
    public String getErrorNo() {
        return "None";
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setExistResult(boolean bl) {
        this.existResult = bl;
    }

    @Override
    public boolean isExistResult() {
        return this.existResult;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    private void setError(boolean bl) {
        this.error = bl;
    }

    @Override
    public void setProgressImpl(ProgressImpl progressImpl) {
        this.progressImpl = progressImpl;
    }
}

