/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.util.AbstractApplyDialog;
import cgdp.recog.util.MathUtil;
import cgdp.recog.util.MessageManager;
import cgdp.recog.util.RestrictTextField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;

public class MergeAllExecuteDialog
extends AbstractApplyDialog {
    private static final String TITLE = "Merge all clusters";
    private RestrictTextField textField;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private double minVal = 0.0;
    private double maxVal = 1.0;
    private String bounds = "";
    private double threshold;

    public MergeAllExecuteDialog(Frame frame, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, double d, double d2) {
        super(frame);
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.minVal = d;
        this.maxVal = d2;
        this.createComponents();
    }

    protected void createComponents() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(false);
        this.setApplyButtonName("Apply");
        this.setCloseButtonName("Cancel");
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Input distance threshold:");
        this.getContentPane().add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 0, new Insets(20, 20, 20, 20), 0, 0));
        String string = String.valueOf(MathUtil.roundDecimal(this.minVal, 6));
        String string2 = String.valueOf(MathUtil.roundDecimal(this.maxVal, 6));
        this.bounds = "(" + string + " <= x < " + string2 + ")";
        JLabel jLabel2 = new JLabel(this.bounds);
        this.getContentPane().add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.textField = new RestrictTextField(6);
        this.textField.setDecimal(true);
        this.textField.setNegative(false);
        this.getContentPane().add((Component)this.textField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected boolean isInputValue() {
        try {
            Double.parseDouble(this.textField.getText());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected double getValue() {
        double d;
        double d2 = Double.NaN;
        if (this.isInputValue() && this.minVal <= (d = Double.parseDouble(this.textField.getText())) && d < this.maxVal) {
            d2 = d;
        }
        return d2;
    }

    @Override
    protected boolean apply() {
        this.threshold = this.getValue();
        if (Double.isNaN(this.threshold)) {
            MessageManager.showMessage((Component)this, "Please input the value " + this.bounds);
            return false;
        }
        this.setVisible(false);
        return true;
    }

    public double getThreshold() {
        return this.threshold;
    }
}

