/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.hcluster.ClusterNode;
import java.util.LinkedList;

class PairDist {
    ClusterNode node1;
    ClusterNode node2;
    float dist;
    int count;
    boolean deleted;
    byte refcount;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static int best = 0;
    private static LinkedList freeList;

    PairDist(ClusterNode clusterNode, ClusterNode clusterNode2, double d) {
        this.initData(clusterNode, clusterNode2, d);
    }

    static void initFreeList() {
        freeList = new LinkedList();
    }

    static void freeFreeList() {
        freeList = null;
    }

    static PairDist newInstance(ClusterNode clusterNode, ClusterNode clusterNode2, double d) {
        PairDist pairDist;
        if (freeList != null && freeList.size() > 0) {
            pairDist = (PairDist)freeList.removeFirst();
            pairDist.initData(clusterNode, clusterNode2, d);
        } else {
            pairDist = new PairDist(clusterNode, clusterNode2, d);
        }
        return pairDist;
    }

    void initData(ClusterNode clusterNode, ClusterNode clusterNode2, double d) {
        if (clusterNode.id < clusterNode2.id) {
            this.node1 = clusterNode;
            this.node2 = clusterNode2;
        } else {
            this.node1 = clusterNode2;
            this.node2 = clusterNode;
        }
        this.dist = (float)d;
        this.count = 1;
        this.refcount = (byte)3;
        this.deleted = false;
    }

    ClusterNode mergeNodes() {
        return new ClusterNode(this);
    }

    double getDist() {
        return this.dist;
    }

    void delete() {
        this.deleted = true;
    }

    boolean isDeleted() {
        return this.deleted;
    }

    void declRef() {
        this.refcount = (byte)(this.refcount - 1);
        if (this.refcount <= 0 && freeList != null) {
            freeList.add(this);
        }
    }

    public String toString() {
        return this.node1.toString() + " " + this.node2.toString() + " " + this.dist + (this.deleted ? "*" : "");
    }
}

