/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.hcluster;

import cgdp.recog.data.ClusterTbl;
import cgdp.recog.hcluster.HClustCondition;
import cgdp.recog.hcluster.HClustExecutable;
import cgdp.recog.hcluster.HClustUtil;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.FileUtil;
import cgdp.recog.util.ProgressServerConnection;
import cgdp.recog.util.ServerStatus;
import java.io.IOException;

public class ServerHClustExecuter
extends ProgressServerConnection
implements HClustExecutable {
    private static final ApplicationLogger logger = new ApplicationLogger(ServerHClustExecuter.class);
    private HClustCondition condition = new HClustCondition();
    private ClusterTbl clusterTbl;
    private String upgmaId;
    private int nCluster;
    private int nClusterDom = -1;
    private StringBuffer sb = new StringBuffer();

    public ServerHClustExecuter(ClusterTbl clusterTbl, HClustCondition hClustCondition) {
        this.clusterTbl = clusterTbl;
        this.condition = hClustCondition;
        this.setContextPath(OptionTbl.getInstance().getOptionValues().getUpgmaUrl());
        this.setOptions(hClustCondition.getQuery());
    }

    @Override
    public String getFilepath() {
        return HClustUtil.getHClustFilepath(this.getUpgmaId(), this.condition.getDomClustName());
    }

    @Override
    protected void beforeRunning() {
        this.sb = new StringBuffer();
    }

    @Override
    public void parseOutputString(int n, String string) {
        if (ServerStatus.isClusterId(string)) {
            this.setUpgmaId(ServerStatus.getClusterId(string));
        }
        if (ServerStatus.isNClusters(string)) {
            this.setNCluster(ServerStatus.getNClusters(string));
        }
        if (ServerStatus.isNClustersDom(string)) {
            this.setNClusterDom(ServerStatus.getNClustersDom(string));
        }
        if (ServerStatus.isStartData(string)) {
            this.sb.append(ServerStatus.createClusterViewIdMessage(this.clusterTbl.getClusterViewId()));
            this.sb.append(FileUtil.LINE_SEPARETOR);
            this.sb.append(ServerStatus.createDomClustIdMessage(this.clusterTbl.getClusterId()));
            this.sb.append(FileUtil.LINE_SEPARETOR);
            this.sb.append(ServerStatus.createQuery(this.condition.getQuery()));
            this.sb.append(FileUtil.LINE_SEPARETOR);
        }
        this.sb.append(string);
        this.sb.append(FileUtil.LINE_SEPARETOR);
    }

    @Override
    protected void after() {
        if (this.isCanceled() || this.isError() || !this.isExistResult()) {
            return;
        }
        try {
            FileUtil.outputFile(this.sb.toString(), this.getFilepath());
        }
        catch (IOException iOException) {
            logger.warn("Fail to save phylopat file.", iOException);
        }
    }

    public String getUpgmaId() {
        return this.upgmaId;
    }

    private void setUpgmaId(String string) {
        this.upgmaId = string;
    }

    public void setNCluster(int n) {
        this.nCluster = n;
    }

    public int getNCluster() {
        return this.nCluster;
    }

    public void setNClusterDom(int n) {
        this.nClusterDom = n;
    }

    public int getNClusterDom() {
        return this.nClusterDom;
    }

    @Override
    public boolean isExistResult() {
        return this.getNCluster() > 0 && this.getNClusterDom() > 0;
    }
}

