/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.histogram.AbstractHistogramRenderer;
import cgdp.recog.histogram.GeneValueHistogramContext;
import cgdp.recog.histogram.HistogramContext;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

abstract class AbstractValueRenderer
extends AbstractHistogramRenderer {
    protected GeneValueHistogramContext context = new GeneValueHistogramContext();

    AbstractValueRenderer() {
    }

    public void setContext(GeneValueHistogramContext geneValueHistogramContext) {
        this.context = geneValueHistogramContext;
    }

    public HistogramContext getContext() {
        return this.context;
    }

    protected void drawScale(Graphics2D graphics2D) {
        double d = this.context.calcScaleX();
        double d2 = this.context.calcX(d, 0.0);
        graphics2D.setColor(Color.black);
        graphics2D.drawLine((int)d2, this.context.getOffsetTop(), (int)d2, this.context.getHeight());
        graphics2D.drawLine(this.context.getOffsetX(), this.context.getOffsetTop(), this.context.getWidth(), this.context.getOffsetTop());
        double d3 = d2;
        graphics2D.setColor(Color.black);
        int n = 0;
        while (d3 > 0.0) {
            if (d3 > (double)this.context.getWidth()) {
                d3 -= this.context.getTickX() * d;
                ++n;
                continue;
            }
            graphics2D.drawLine((int)d3, this.context.getOffsetTop(), (int)d3, this.context.getOffsetTop() + this.context.getScaleHeight());
            graphics2D.drawString(String.valueOf((double)(-1 * n) * this.context.getTickX()), (int)d3 + 2, this.context.getScaleTitleStartY());
            d3 -= this.context.getTickX() * d;
            ++n;
        }
        d3 = d2;
        n = 0;
        while (d3 < (double)this.context.getWidth()) {
            if (d3 < 0.0) {
                d3 += this.context.getTickX() * d;
                ++n;
                continue;
            }
            graphics2D.drawLine((int)d3, this.context.getOffsetTop(), (int)d3, this.context.getOffsetTop() + this.context.getScaleHeight());
            graphics2D.drawString(String.valueOf((double)n * this.context.getTickX()), (int)d3 + 2, this.context.getScaleTitleStartY());
            d3 += this.context.getTickX() * d;
            ++n;
        }
    }

    protected void drawOrganism(Graphics2D graphics2D) {
        graphics2D.setFont(this.context.getOrganismFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (this.context.isValue()) {
            String string = this.context.getValueOrganismCode();
            int n = fontMetrics.stringWidth(string);
            int n2 = this.context.getWidth() - n + this.context.getOffsetX() - 5;
            graphics2D.drawString(string, n2, this.context.getOrganismTitleStartY());
        } else if (this.context.isDiff()) {
            String string = this.context.getPrimaryOrganismCode();
            String string2 = this.context.getSecondaryOrganismCode();
            int n = this.context.getOffsetX() + 2;
            graphics2D.drawString(string2, n, this.context.getOrganismTitleStartY());
            int n3 = fontMetrics.stringWidth(string2);
            int n4 = this.context.getWidth() - n3 + this.context.getOffsetX() - 5;
            graphics2D.drawString(string, n4, this.context.getOrganismTitleStartY());
        }
    }

    protected double adjustCellHeight(double d) {
        return d > 5.0 ? d - 1.0 : d;
    }

    protected void drawDataLabel(Graphics2D graphics2D, int n, double d, double d2, double d3, double d4, boolean bl) {
        if (!bl || !this.context.isShowDataLabel()) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        String string = String.valueOf((float)d4);
        int n2 = fontMetrics.stringWidth(string);
        int n3 = 4;
        if (d4 < 0.0) {
            n3 = (int)(d - (double)n2);
        }
        int n4 = (int)(d2 + (d3 > 1.0 ? d3 - 1.0 : d3) / 2.0) + fontMetrics.getAscent() / 2;
        graphics2D.setColor(this.context.isSelectedRow(n) ? Color.red.darker() : Color.black);
        graphics2D.drawString(string, n3, n4);
    }

    protected void drawBorderLine(Graphics2D graphics2D, double d, double d2, Color color) {
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        if (!optionValues.isBorderLineView()) {
            return;
        }
        graphics2D.setColor(color);
        graphics2D.draw(new Line2D.Double(0.0, d + d2 - 1.0, this.context.getWidth() - 1, d + d2 - 1.0));
    }

    protected void drawSelectBorderLine(Graphics2D graphics2D, int n, double d, double d2) {
        if (!this.context.isSelectedRow(n)) {
            return;
        }
        graphics2D.setColor(Color.black);
        graphics2D.draw(new Rectangle2D.Double(0.0, d, this.context.getWidth() - 1, d2 > 1.0 ? d2 - 1.0 : d2));
    }
}

