/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.bean.ClusterMap;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterUtil;
import cgdp.recog.funccat.FunctionColorUtil;
import cgdp.recog.histogram.AbstractHistogramRenderer;
import cgdp.recog.histogram.HistogramContext;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ColorUtil;
import cgdp.recog.util.StringTool;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DescriptionFuncRenderer
extends AbstractHistogramRenderer {
    private HistogramContext context = new HistogramContext();

    public void setContext(HistogramContext histogramContext) {
        this.context = histogramContext;
    }

    public HistogramContext getContext() {
        return this.context;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (!this.context.isExistClusterTbl()) {
            return;
        }
        graphics2D.setFont(this.context.getFont());
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.context.getWidth(), this.context.getHeight());
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        Color color = ColorUtil.str2Color(optionValues.getBorderLineColorString());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        ArrayList arrayList = new ArrayList(this.context.getViewClusterList());
        double d = this.context.calcIntervalY(arrayList.size());
        double d2 = d < 1.0 ? 1.0 : d;
        double d3 = this.context.getOffsetTop();
        boolean bl = ClusterMap.isDrawLabel(d2, fontMetrics.getAscent() + fontMetrics.getDescent());
        for (int i = 0; i < arrayList.size() && i < this.context.getRowCount(); ++i) {
            Cluster cluster = (Cluster)arrayList.get(i + this.context.getStartRow());
            String string = ClusterUtil.getFunctionCategoryNo(cluster, this.context.isOutgroup());
            graphics2D.setColor(FunctionColorUtil.getFuncCatColor(string));
            graphics2D.fill(new Rectangle2D.Double(0.0, d3, this.context.getWidth(), d2));
            if (bl) {
                String string2 = this.getDescription(cluster);
                List list = StringTool.adjustStringForDraw(fontMetrics, string2, this.context.getWidth() - 1, (int)d2);
                Collections.reverse(list);
                graphics2D.setColor(Color.black);
                for (int j = 0; j < list.size(); ++j) {
                    String string3 = (String)list.get(j);
                    int n = (int)(d3 + d2 - (double)((fontMetrics.getDescent() + fontMetrics.getAscent()) * j) - (double)fontMetrics.getDescent());
                    graphics2D.drawString(string3, 1, n);
                }
            }
            graphics2D.setColor(color);
            if (optionValues.isBorderLineView()) {
                graphics2D.draw(new Line2D.Double(0.0, d3 + d2 - 1.0, this.context.getWidth() - 1, d3 + d2 - 1.0));
            }
            if (this.context.isSelectedRow(i + this.context.getStartRow())) {
                graphics2D.setColor(Color.black);
                graphics2D.draw(new Rectangle2D.Double(0.0, d3, this.context.getWidth() - 1, d2 > 1.0 ? d2 - 1.0 : d2));
            }
            d3 += d;
        }
    }

    protected String getDescription(Cluster cluster) {
        return ClusterUtil.getDescription(cluster, this.context.isOutgroup());
    }
}

