/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.bean.ClusterMap;
import cgdp.recog.data.Cluster;
import cgdp.recog.histogram.AbstractValueRenderer;
import cgdp.recog.option.OptionTbl;
import cgdp.recog.option.OptionValues;
import cgdp.recog.util.ColorUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

class GeneValueRenderer
extends AbstractValueRenderer {
    GeneValueRenderer() {
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (!this.context.isExistClusterTbl()) {
            return;
        }
        graphics2D.setFont(this.context.getFont());
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.context.getWidth(), this.context.getHeight());
        OptionValues optionValues = OptionTbl.getInstance().getOptionValues();
        Color color = ColorUtil.str2Color(optionValues.getBorderLineColorString());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        ArrayList arrayList = new ArrayList(this.context.getViewClusterList());
        double d = this.context.calcIntervalY(arrayList.size());
        double d2 = d < 1.0 ? 1.0 : d;
        double d3 = this.context.calcScaleX();
        double d4 = this.context.getOffsetTop();
        double d5 = this.context.calcX(d3, 0.0);
        boolean bl = ClusterMap.isDrawLabel(d2, fontMetrics.getAscent() + fontMetrics.getDescent());
        for (int i = 0; i < arrayList.size() && i < this.context.getRowCount(); ++i) {
            int n = i + this.context.getStartRow();
            Cluster cluster = (Cluster)arrayList.get(n);
            double d6 = this.context.getValue(cluster);
            double d7 = this.context.calcX(d3, d6);
            if (d7 < d5) {
                graphics2D.setColor(this.context.getNegativeColor());
                graphics2D.fill(new Rectangle2D.Double(d7, d4, d5 - d7, this.adjustCellHeight(d2)));
            } else if (d7 > d5) {
                graphics2D.setColor(this.context.getPositiveColor());
                graphics2D.fill(new Rectangle2D.Double(d5, d4, d7 - d5, this.adjustCellHeight(d2)));
            }
            this.drawDataLabel(graphics2D, n, d5, d4, d2, d6, bl);
            this.drawBorderLine(graphics2D, d4, d2, color);
            this.drawSelectBorderLine(graphics2D, n, d4, d2);
            d4 += d;
        }
        this.drawScale(graphics2D);
        this.drawOrganism(graphics2D);
    }
}

