/*
 * Decompiled with CFR 0.152.
 */
package cgdp.recog.histogram;

import cgdp.recog.bean.MediatorImpl;
import cgdp.recog.data.Cluster;
import cgdp.recog.data.ClusterTbl;
import cgdp.recog.histogram.HistogramCondition;
import cgdp.recog.info.AbstractInfoTitle;
import cgdp.recog.info.cell.CellInfo;
import cgdp.recog.info.cell.CellInfoFacade;
import cgdp.recog.info.cell.CellInfoTitle;
import cgdp.recog.info.cluster.ClusterInfo;
import cgdp.recog.info.cluster.ClusterInfoFacade;
import cgdp.recog.info.cluster.ClusterInfoTitle;
import cgdp.recog.info.gene.GeneInfoFacade;
import cgdp.recog.info.gene.GeneInfoMultiInfoManager;
import cgdp.recog.info.gene.GeneInfoTitle;
import cgdp.recog.info.gene.LocusTagComparator;
import cgdp.recog.process.AbstractThreadProcess;
import cgdp.recog.process.ProgressImpl;
import cgdp.recog.util.ApplicationLogger;
import cgdp.recog.util.MessageManager;
import java.awt.Component;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HistogramDataCreater
extends AbstractThreadProcess {
    private static final ApplicationLogger logger = new ApplicationLogger(HistogramDataCreater.class);
    private Component parent;
    private MediatorImpl mediator;
    private ClusterTbl clusterTbl;
    private int startRow = -1;
    private List clusterList;
    private HistogramCondition condition;
    private double minValue = Double.MAX_VALUE;
    private double maxValue = -1.7976931348623157E308;
    private Map clusterValueMap = new HashMap();
    private Map clusterOrganismValueMap = new HashMap();

    public HistogramDataCreater(Component component, MediatorImpl mediatorImpl, ClusterTbl clusterTbl, List list, HistogramCondition histogramCondition) {
        this.parent = component;
        this.mediator = mediatorImpl;
        this.clusterTbl = clusterTbl;
        this.clusterList = list;
        this.condition = histogramCondition;
    }

    public void setStartRow(int n) {
        this.startRow = n;
    }

    @Override
    public void execute(ProgressImpl progressImpl) {
        if (this.condition.isValue()) {
            if (this.condition.isMultiOrganism()) {
                this.executeForMultiValue(progressImpl);
            } else {
                this.executeForValue(progressImpl);
            }
        } else if (this.condition.isDiff()) {
            this.executeForDiff(progressImpl);
        }
    }

    public void executeForValue(ProgressImpl progressImpl) {
        try {
            AbstractInfoTitle abstractInfoTitle = this.condition.getValueGeneInfoTitle();
            if (abstractInfoTitle.isGene()) {
                List list = this.condition.getValueOrganismCodeList();
                progressImpl.setTotal(this.clusterList.size() + list.size());
                String string = (String)this.condition.getValueOrganismCodeList().get(0);
                Map map = GeneInfoFacade.createGeneInfoMap(this.clusterList, string, abstractInfoTitle);
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.increment();
                LocusTagComparator locusTagComparator = new LocusTagComparator(this.condition, (GeneInfoTitle)this.condition.getValueGeneInfoTitle(), map);
                for (Cluster cluster : this.clusterList) {
                    Float f;
                    if (progressImpl.isCanceled()) {
                        this.setCancel(true);
                        return;
                    }
                    progressImpl.increment();
                    List list2 = cluster.getLocusTagWithoutDomainList(string);
                    if (list2 == null || (f = (Float)GeneInfoMultiInfoManager.getRepresentativeValue(this.condition, this.condition.getValueGeneInfoTitle(), list2, locusTagComparator, map)) == null || f.isNaN()) continue;
                    double d = f.doubleValue();
                    this.maxValue = Math.max(this.maxValue, d);
                    this.minValue = Math.min(this.minValue, d);
                    this.clusterValueMap.put(cluster, f);
                }
            } else if (abstractInfoTitle.isCluster()) {
                Map map = ClusterInfoFacade.createClusterInfoMap(this.clusterList, (ClusterInfoTitle)abstractInfoTitle, ClusterInfoFacade.createClusterInfoCalcCondition(this.clusterTbl));
                progressImpl.setTotal(map.keySet().size());
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    if (progressImpl.isCanceled()) {
                        this.setCancel(true);
                        return;
                    }
                    progressImpl.increment();
                    Cluster cluster = (Cluster)iterator.next();
                    ClusterInfo clusterInfo = (ClusterInfo)map.get(cluster);
                    Float f = (Float)clusterInfo.getInfo(abstractInfoTitle);
                    if (f == null || f.isNaN()) continue;
                    double d = f.doubleValue();
                    this.maxValue = Math.max(this.maxValue, d);
                    this.minValue = Math.min(this.minValue, d);
                    this.clusterValueMap.put(cluster, f);
                }
            } else if (abstractInfoTitle.isCell()) {
                String string = (String)this.condition.getValueOrganismCodeList().get(0);
                progressImpl.setTotal(this.clusterList.size());
                Map map = CellInfoFacade.createClusterCellInfoMap(string, this.clusterList, (CellInfoTitle)abstractInfoTitle);
                Iterator iterator = this.clusterList.iterator();
                while (iterator.hasNext()) {
                    Float f;
                    if (progressImpl.isCanceled()) {
                        this.setCancel(true);
                        return;
                    }
                    progressImpl.increment();
                    Cluster cluster = (Cluster)iterator.next();
                    CellInfo cellInfo = (CellInfo)map.get(cluster);
                    if (cellInfo == null || (f = (Float)cellInfo.getInfo(abstractInfoTitle)) == null || f.isNaN()) continue;
                    double d = f.doubleValue();
                    this.maxValue = Math.max(this.maxValue, d);
                    this.minValue = Math.min(this.minValue, d);
                    this.clusterValueMap.put(cluster, f);
                }
            }
        }
        catch (Exception exception) {
            String string = "Fail to show histogram.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    public void executeForMultiValue(ProgressImpl progressImpl) {
        try {
            AbstractInfoTitle abstractInfoTitle = this.condition.getValueGeneInfoTitle();
            List list = this.condition.getValueOrganismCodeList();
            progressImpl.setTotal(this.clusterList.size() * list.size());
            HashMap hashMap = new HashMap();
            HashMap hashMap2 = new HashMap();
            if (abstractInfoTitle.isGene()) {
                for (String string : list) {
                    Map map = GeneInfoFacade.createGeneInfoMap(this.clusterList, string, abstractInfoTitle);
                    if (progressImpl.isCanceled()) {
                        this.setCancel(true);
                        return;
                    }
                    progressImpl.increment();
                    LocusTagComparator locusTagComparator = new LocusTagComparator(this.condition, (GeneInfoTitle)this.condition.getValueGeneInfoTitle(), map);
                    for (Cluster cluster : this.clusterList) {
                        Float f;
                        if (progressImpl.isCanceled()) {
                            this.setCancel(true);
                            return;
                        }
                        progressImpl.increment();
                        List list2 = cluster.getLocusTagWithoutDomainList(string);
                        if (list2 == null || (f = (Float)GeneInfoMultiInfoManager.getRepresentativeValue(this.condition, this.condition.getValueGeneInfoTitle(), list2, locusTagComparator, map)) == null || f.isNaN()) continue;
                        double d = f.doubleValue();
                        this.prepareBoundaryValue(cluster, string, d, hashMap, hashMap2);
                        this.registerClusterOrganismValueMap(cluster, string, d);
                    }
                }
            } else if (abstractInfoTitle.isCell()) {
                for (String string : list) {
                    Map map = CellInfoFacade.createClusterCellInfoMap(string, this.clusterList, (CellInfoTitle)abstractInfoTitle);
                    Iterator iterator = this.clusterList.iterator();
                    while (iterator.hasNext()) {
                        Float f;
                        if (progressImpl.isCanceled()) {
                            this.setCancel(true);
                            return;
                        }
                        progressImpl.increment();
                        Cluster cluster = (Cluster)iterator.next();
                        CellInfo cellInfo = (CellInfo)map.get(cluster);
                        if (cellInfo == null || (f = (Float)cellInfo.getInfo(abstractInfoTitle)) == null || f.isNaN()) continue;
                        float f2 = f.floatValue();
                        this.prepareBoundaryValue(cluster, string, f2, hashMap, hashMap2);
                        this.registerClusterOrganismValueMap(cluster, string, f2);
                    }
                }
            }
            this.calcBoundaryValueForStackBar(hashMap2, hashMap);
        }
        catch (Exception exception) {
            String string = "Fail to show histogram.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private void prepareBoundaryValue(Cluster cluster, String string, double d, Map map, Map map2) {
        if (this.condition.isStackBar()) {
            if (d < 0.0) {
                Float f = (Float)map.get(cluster);
                double d2 = 0.0;
                if (f != null) {
                    d2 = f.doubleValue();
                }
                map.put(cluster, new Float(d2 += d));
            } else {
                Float f = (Float)map2.get(cluster);
                double d3 = 0.0;
                if (f != null) {
                    d3 = f.doubleValue();
                }
                map2.put(cluster, new Float(d3 += d));
            }
        } else {
            this.maxValue = Math.max(this.maxValue, d);
            this.minValue = Math.min(this.minValue, d);
        }
    }

    private void registerClusterOrganismValueMap(Cluster cluster, String string, double d) {
        HashMap<String, Float> hashMap = (HashMap<String, Float>)this.clusterOrganismValueMap.get(cluster);
        if (hashMap == null) {
            hashMap = new HashMap<String, Float>();
            this.clusterOrganismValueMap.put(cluster, hashMap);
        }
        hashMap.put(string, new Float(d));
    }

    private void calcBoundaryValueForStackBar(Map map, Map map2) {
        if (!this.condition.isStackBar()) {
            return;
        }
        this.maxValue = 0.0;
        this.minValue = 0.0;
        if (this.condition.isStackBar()) {
            for (Cluster cluster : this.clusterList) {
                Float f = (Float)map.get(cluster);
                Float f2 = (Float)map2.get(cluster);
                if (f != null) {
                    this.maxValue = Math.max(this.maxValue, f.doubleValue());
                }
                if (f2 == null) continue;
                this.minValue = Math.min(this.minValue, f2.doubleValue());
            }
        } else {
            for (Cluster cluster : this.clusterList) {
                Float f = (Float)map.get(cluster);
                Float f3 = (Float)map2.get(cluster);
                this.maxValue = Math.max(this.maxValue, f.doubleValue());
                this.maxValue = Math.max(this.maxValue, f3.doubleValue());
                this.minValue = Math.min(this.minValue, f.doubleValue());
                this.minValue = Math.min(this.minValue, f3.doubleValue());
            }
        }
    }

    public void executeForDiff(ProgressImpl progressImpl) {
        try {
            AbstractInfoTitle abstractInfoTitle = this.condition.getDiffGeneInfoTitle();
            if (abstractInfoTitle.isGene()) {
                progressImpl.setTotal(this.clusterList.size() + 20);
                GeneInfoTitle geneInfoTitle = (GeneInfoTitle)this.condition.getDiffGeneInfoTitle();
                String string = this.condition.getPrimaryOrganismCode();
                String string2 = this.condition.getSecondaryOrganismCode();
                Map map = GeneInfoFacade.createGeneInfoMap(this.clusterList, string, geneInfoTitle);
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.setCount(9);
                progressImpl.increment();
                Map map2 = GeneInfoFacade.createGeneInfoMap(this.clusterList, string2, geneInfoTitle);
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.setCount(19);
                progressImpl.increment();
                LocusTagComparator locusTagComparator = new LocusTagComparator(this.condition, (GeneInfoTitle)this.condition.getDiffGeneInfoTitle(), map);
                LocusTagComparator locusTagComparator2 = new LocusTagComparator(this.condition, (GeneInfoTitle)this.condition.getDiffGeneInfoTitle(), map2);
                for (Cluster cluster : this.clusterList) {
                    if (progressImpl.isCanceled()) {
                        this.setCancel(true);
                        return;
                    }
                    progressImpl.increment();
                    Float f = this.getValue(cluster, string, locusTagComparator, map);
                    Float f2 = this.getValue(cluster, string2, locusTagComparator2, map2);
                    double d = this.diff(f, f2);
                    this.maxValue = Math.max(this.maxValue, d);
                    this.minValue = Math.min(this.minValue, d);
                    this.clusterValueMap.put(cluster, new Float(d));
                }
            } else if (abstractInfoTitle.isCell()) {
                progressImpl.setTotal(this.clusterList.size() + 20);
                String string = this.condition.getPrimaryOrganismCode();
                String string3 = this.condition.getSecondaryOrganismCode();
                Map map = CellInfoFacade.createClusterCellInfoMap(string, this.clusterList, (CellInfoTitle)abstractInfoTitle);
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.setCount(9);
                progressImpl.increment();
                Map map3 = CellInfoFacade.createClusterCellInfoMap(string3, this.clusterList, (CellInfoTitle)abstractInfoTitle);
                if (progressImpl.isCanceled()) {
                    this.setCancel(true);
                    return;
                }
                progressImpl.setCount(19);
                progressImpl.increment();
                for (Cluster cluster : this.clusterList) {
                    if (progressImpl.isCanceled()) {
                        this.setCancel(true);
                        return;
                    }
                    progressImpl.increment();
                    Float f = this.getValueForCell(cluster, map);
                    Float f3 = this.getValueForCell(cluster, map3);
                    double d = this.diff(f, f3);
                    this.maxValue = Math.max(this.maxValue, d);
                    this.minValue = Math.min(this.minValue, d);
                    this.clusterValueMap.put(cluster, new Float(d));
                }
            }
        }
        catch (Exception exception) {
            String string = "Fail to show histogram.";
            logger.warn(string, exception);
            this.setError(true);
            this.setErrorMessage(string);
        }
    }

    private double diff(Float f, Float f2) {
        double d = 0.0;
        if (f != null && f2 == null) {
            d = f.doubleValue();
        } else if (f == null && f2 != null) {
            d = f2.doubleValue() * -1.0;
        } else if (f != null && f2 != null) {
            d = f.doubleValue() - f2.doubleValue();
        }
        return d;
    }

    private Float getValue(Cluster cluster, String string, Comparator comparator, Map map) {
        List list = cluster.getLocusTagWithoutDomainList(string);
        if (list == null) {
            return null;
        }
        Comparable comparable = GeneInfoMultiInfoManager.getRepresentativeValue(this.condition, this.condition.getDiffGeneInfoTitle(), list, comparator, map);
        if (comparable == null) {
            return null;
        }
        return (Float)comparable;
    }

    private Float getValueForCell(Cluster cluster, Map map) {
        CellInfo cellInfo = (CellInfo)map.get(cluster);
        if (cellInfo == null) {
            return null;
        }
        Float f = (Float)cellInfo.getInfo(this.condition.getDiffGeneInfoTitle());
        return f;
    }

    @Override
    public void done() {
        if (this.isCancel()) {
            return;
        }
        if (this.isError()) {
            MessageManager.showErrorMessage(this.parent, this.getErrorMessages());
            return;
        }
        if (!this.condition.isCalcedRange()) {
            this.condition.setMinValue(this.minValue);
            this.condition.setMaxValue(this.maxValue);
        }
        this.condition.setClusterValueMap(this.clusterValueMap);
        this.condition.setClusterOrganismValueMap(this.clusterOrganismValueMap);
        this.mediator.updateForHistogram(this.condition, this.startRow);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

